/* filename: PRINTCOM.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZPRINTCOM
#define _TZPRINTCOM
#define TZPRINTCOM

#ifdef TOPAZINI
#error You should put INIT.H as the last header file in your MAIN file.
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MaxQueueFiles 200  // absurd arbitrary number, actual Print.com
                           // maximum queue size setting cannot be determined
#define PrintComNotInstalled 0xFFFF // possible result of SpoolFile() and CancelSpoolFile()

typedef char SpoolFilename[64];
typedef SpoolFilename SpoolFileList[MaxQueueFiles];

extern BOOL DosSpoolerInstalled; // set by init code
extern unsigned PrintComErrorCount; // set by HoldPrintJobs
extern SpoolFileList *PrintQueue;

unsigned SpoolFile(char const *filename); // wildcards NOT ok
unsigned CancelSpoolFile(char const *filename); // wildcards ok
void     CancelAllSpoolFiles(void);
void     PrintComTimeSlice(void); // allow print.com to execute for a while (DOS 3.1 and greater)
unsigned PrintComStatus(void); // DOS 3.3 and greater
int      PrintQueueCount(void);
char    *PrintQueueItem(int  i);
void     ViewQueue(void); // list of names, tagged files are removed from the queue
void     TZPrintcomInit(void);

#ifdef __cplusplus
}
#endif

#endif
