/* filename: PICK.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZPICK
#define _TZPICK
#define TZPICK

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifndef TZVIDPOP
#include <vidpop.h>
#endif

#include <dos.h> // to refer to find_t structure

#ifdef __cplusplus
extern "C" {
#endif

typedef struct PickWindowType {
  unsigned char r1, R2, c1, c2;
  unsigned char fg, bg, barFG, barBG;  // colors
  unsigned char linestyle;
  unsigned char ShadowStyle;
  unsigned char BarWidth;
  char Header[81];
} PickWindowType, *PickWindowPtr;

// types for filename linked list:
typedef struct FileNameRec {
  char Name[16];
  int Tagged;
  char DateTimeSize[28];
  struct FileNameRec * PrevPtr, * NextPtr;
} FileNameRec, *LinkPtrType;

// types for item number linked list:
typedef struct ItemNumberRec {
  long ItemNumber;
  long SortNumber;
  struct ItemNumberRec *PrevPtr, *NextPtr;
} ItemNumberRec, *ItemPtrType;

// PICK DECLARATIONS
char *PickFile(char * mask);
long PickList(char *(*StringMakerPtr)(int), long _MinItem,
       long _MaxItem, long _StartingItem);
void ResetMaxItem(int i);
void SetPickColorTo(unsigned char fg, unsigned char bg,
       unsigned char barFG, unsigned char barBG);
void SetPickWindowTo(unsigned char r1, unsigned char c1, unsigned char R2,
      unsigned char c2, unsigned char linestyle, char * Header);

// TAG DECLARATIONS
void  SetTag(int i);
void  SetTagColorTo(unsigned char fg, unsigned char bg,
                    unsigned char barFG, unsigned char barBG);
void  SetTagOrderOn(void);  // items returned in Tag order, the default
void  SetTagOrderOff(void); // items returned in Display order
void  SetTagWindowTo(unsigned char a1, unsigned char b1, unsigned char a2,
                     unsigned char b2, unsigned char linestyle, char * Header);
int   TagFiles(char * mask);
char *TaggedFile(void);
long  TaggedItem(void);
int   TagItems(char *(*_StringMakerPtr)(int), long _MinItem,
               long _MaxItem, long _StartingItem);

// SHARED DECLARATIONS
void  SetHuntOn(void);
void  SetHuntOff(void);
void  SetPickCalcTo(void (*P)(void));

// PUBLIC VARIABLES & CONSTANTS
extern int EnableLeftRightExit;
extern int PickSaveWindow;   // pick saves & restores screen, default True
extern struct find_t PickFileResult, TagFileResult;
extern long CurrentPickListItem; // for use with PickList and TagItems
extern char _tzfar CurrentPickFileName[81]; // for use with PickFiles and TagFiles
extern PickWindowPtr PickSpecPtr, TagSpecPtr;

#ifdef __cplusplus
}
#endif

#endif
