/* filename: PARSER.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _NDXPARSER_H
#define _NDXPARSER_H
#define TZPARSER  // for initialization

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif
#ifndef _TZCOMMON
#include <common.h>
#endif

#define TZSAYGET
#define TZDBF


#define DYNAMIC_TYPE
// comment this line out if you do not want to use dynamic memory
// allocation during parsing process. In this case you will use
// a static parse buffer, which is redundant in most cases.

#define t_ABS 257
#define t_ACOS 258
#define t_ASC 259
#define t_ASIN 260
#define t_AT 261
#define t_ATAN 262
#define t_ATN2 263
#define t_CDOW 264
#define t_CEILING 265
#define t_CHR 266
#define t_CMONTH 267
#define t_COS 268
#define t_CTOD 269
#define t_DATE 270
#define t_DAY 271
#define t_DELETED 272
#define t_DISKSPACE 273
#define t_DOW 274
#define t_DTOC 275
#define t_DTOR 276
#define t_DTOS 277
#define t_EXP 278
#define t_FIELD 279
#define t_FILE 280
#define t_FLOOR 281
#define t_GETENV 282
#define t_IIF 283
#define t_INT 284
#define t_ISALPHA 285
#define t_ISLOWER 286
#define t_ISUPPER 287
#define t_LEFT 288
#define t_LEN 289
#define t_LOG 290
#define t_LOG10 291
#define t_LOWER 292
#define t_LTRIM 293
#define t_MAX 294
#define t_MIN 295
#define t_MOD 296
#define t_MONTH 297
#define t_PI 298
#define t_RECCOUNT 299
#define t_RECNO 300
#define t_REPLICATE 301
#define t_RIGHT 302
#define t_ROUND 303
#define t_RTOD 304
#define t_RTRIM 305
#define t_SIGN 306
#define t_SIN 307
#define t_SOUNDEX 308
#define t_SQRT 309
#define t_SPACE 310
#define t_STR 311
#define t_STUFF 312
#define t_SUBSTR 313
#define t_TAN 314
#define t_TIME 315
#define t_TRIM 316
#define t_TYPE 317
#define t_UPPER 318
#define t_VAL 319
#define t_YEAR 320
#define t_STRFIELD 321
#define t_NUMFIELD 322
#define t_LOGFIELD 323
#define t_DATFIELD 324
#define t_MEMFIELD 325
#define a_STRFIELD 326
#define a_NUMFIELD 327
#define a_LOGFIELD 328
#define a_DATFIELD 329
#define a_MEMFIELD 330
#define _STRINGTYPE 331
#define _NUMBERTYPE 332
#define _LOGICALTYPE 333
#define _DATETYPE 334
#define _MEMOTYPE 335
#define t_IDENT 336
#define t_FALSE 337
#define t_TRUE 338
#define t_NOT 339
#define t_OR 340
#define t_AND 341
#define NE 342
#define LE 343
#define GE 344
#define AEQ 345
#define CONTAIN 346
#define ADD_NN 347
#define ADD_ND 348
#define ADD_DN 349
#define ADD_SS 350
#define SUB_NN 351
#define SUB_DN 352
#define SUB_DD 353
#define SUB_SS 354
#define MUL_NN 355
#define DIV_NN 356
#define POW_NN 357
#define CEQ_NN 358
#define CEQ_DD 359
#define CEQ_SS 360
#define CEQ_LL 361
#define CAEQ_SS 362
#define CONTAIN_SS 363
#define CGT_NN 364
#define CGT_DD 365
#define CGT_SS 366
#define CLT_NN 367
#define CLT_DD 368
#define CLT_SS 369
#define CNE_NN 370
#define CNE_DD 371
#define CNE_SS 372
#define CNE_LL 373
#define CLE_NN 374
#define CLE_DD 375
#define CLE_SS 376
#define CGE_NN 377
#define CGE_DD 378
#define CGE_SS 379
#define OR_LL 380
#define AND_LL 381
#define NOT_L 382
#define CHS_N 383
#define UNARY 384

// Error codes
#define ExprOK                   0
#define ExpressionOK             0
#define PARSER_errors_start    350  // the first parser error
#define ErrorInDBaseExpression 351
#define SemanticStackOverflow  352
#define WorkingStackOverflow   353
#define WorkingPoolOverflow    354
#define WorkingStackEmpty      355
#define UnknownDataType        356
#define DivideByZero           357
#define ExprTooLong            358
#define EmptyKeyExpr           359
#define KeyExprIsNULL          360
#define NotLogicalExpr         361
#define NotValidKeyExpr        362
#define PARSER_errors_end      363  // the last parser error

#define MEMOPOOLSIZE   STRSIZ // Default Memobuffer size
#define MAXSTACKDEPTH  128    // Semantic and working stack depth

#ifdef __cplusplus
extern "C" {
#endif

typedef struct link_st {
   struct link_st *next, *prev;
} LINK, *PLINK, **PPLINK;

typedef char   *C_PTR; // character string
typedef double *D_PTR; // date
typedef double *F_PTR; // floating point
typedef int    *L_PTR; // logical
typedef char   *M_PTR; // memo field
typedef double *N_PTR; // numeric

// parser semantic stack node
typedef struct {
  int Action;
  int ArgsNo;
  int ArgType;
  union {
    double  N;
    char   *C;
    double  D;
    int     L;
  } type;
} StackNode, * PStackNode;

typedef struct {
  LINK link;
  StackNode snode;
} *PTag;

typedef struct {
  char     *Expression;  // store the expression that was specified
  char     ReturnType;  // 'C','L','M','N','F'or'D'
  unsigned Length;      // Memo length may be up to UINT_MAX-16
  unsigned char Decimals; // number of decimals
  void    *ReturnPtr;
  PLINK    conststr;
#ifdef DYNAMIC_TYPE
  PLINK  ss_list, ws_list;
  PLINK  ss_first, ws_first;
#else
  StackNode  SemanticStack[MAXSTACKDEPTH];
  StackNode  WorkStack[MAXSTACKDEPTH];
  int        SemanticStackPtr;
  int        WorkStackPtr;
#endif
  unsigned   WorkingPoolSize;
  char      *WorkingPool;
  char      *WorkingPoolPtr;
} ParseBufferStruct, *PParseBufferStruct, *ExprHandle, **PExprHandle;

// The following functions and variables are for internal use only
extern int   ParserDecimals;
extern char  IndexRecordType;
extern unsigned MemoGetSize;

#ifdef DYNAMIC_TYPE
 PStackNode  GetFirstSStackNode(void);
 PStackNode  GetNextSStackNode(void);
#else
 PStackNode  GetSStackNode(void);
#endif

void  BuildNewKey(void);
void *DBF_field_address(int field_no, void *buf_ptr, int workarea);
char *GetStringAddressInWS(void);
void  PushWD(int DataType, void *Data);
void *PopWD(void);
void  PushSA(int action, char ArgsNo);
void  PushSD(int DataType, void *Data);
void  PushMemoInWD(void *Data);
void  PushMemo(PParseBufferStruct P, PStackNode Sptr, void *Data);
void  InitEngine(PParseBufferStruct);
void *GetNewKeyPtr(void);
void  type_save_restore_parameters(int);
void  yyerror(char *s);
int   yylex(void);
int   yyparse(void);

// Intermediate level functions
void  aswap(char*, unsigned, unsigned);
void  add_to_llist(PPLINK list, PLINK link);
void *allocate_and_link(PPLINK ppointer, unsigned size);
void *get_next_in_llist(PPLINK list, PLINK link);
void *get_prev_in_llist(PPLINK list, PLINK link);
void *remove_from_llist(PPLINK list);

double CtoDInternal(const char *string_date);
double DBFtoInternal(const char *dbf_type_date);
double IntsToInternal(int year, int month, int day);
char  *InternalToDate(double date);
char  *Internal2DBF(double date);  // returns DBF-type CCYYMMDD date

// End user functions
ExprHandle AssignExpr(const char * db_expr);
void  DisposeExpr(ExprHandle * handle_ptr);
void *Evaluate(ExprHandle handle);     // generic function
char *SEvaluate(ExprHandle handle);    // string Evaluate
char *iEvaluate(const char * db_expr); // immediate Evaluate
void  SetDecimalsTo(int decimals);
void     SetMemoExprSizeTo(unsigned size);
unsigned GetMemoExprSize(void);
int   ValidKeyExpr(const char *db_expr);
int   ValidLogicalExpr(const char *db_expr);


#ifdef __cplusplus
}
#endif

#endif // _NDXPARSER_H

