/* filename: MEMO.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZMEMO
#define _TZMEMO
#define TZMEMO

#ifndef TZCOMMON
#include <common.h>
#endif

#ifndef TZDBF
#include <dbf.h>
#endif

#ifndef TZSAYGET
#include <sayget.h>
#endif

#ifndef TZVIDPOP
#include <vidpop.h>
#endif

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifdef _MSC_VER
#ifndef _GWINDOW
#include <graph.h>
#endif
#define window(x1,y1,x2,y2)  _settextwindow((short)y1, (short)x1, (short)y2, (short)x2)
#define clrscr()             _clearscreen(_GWINDOW)
#define fnsplit              _splitpath
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define Bsize          512
#define BsizePlusOne   513
#define ReservedMemory 1000

#define _fmOutput      0xB2
#define _fmInput       0xB1
#define _fmClosed      0xB0
#define _fmInOut       0xB3

typedef char BufferArray[STRSIZ-1];
typedef BufferArray *pBufferArray;
typedef struct MemoFile {
  unsigned Handle;
  unsigned mode;
  unsigned BufPos;
  unsigned BufEnd;
  unsigned BufSize;
  char     *BufPtr;
  int      (*OpenFunc)(struct MemoFile *);
  int      (*InOutFunc)(struct MemoFile *);
  int      (*FlushFunc)(struct MemoFile *);
  int      (*CloseFunc)(struct MemoFile *);
  long     *MemoPtr;
  int      Selected;
  char     Name[80];
} MemoFile;

typedef struct {
  long next_free_block;
  long size_cur_block;
  char filename[9];
  char reserved_1;
  int  version;
  int  block_size;
  char encrypt;
  char reserved_2;
} MEMO4_HDR;

typedef struct {
  int flag;
  int header_length;
  long group_length;
} GROUP_HDR;

typedef struct {
  long next_free_block;
  long size_in_blocks;
} DELGROUP_HDR;

extern int   DBMemoType;
extern char  EOFZ;
extern long  BlocksReadFromFile;
extern int   EndOfMemo;
extern char  _tzfar MemoTitle[81];

extern unsigned char MemoStyle;
extern unsigned char MemoX1;
extern unsigned char MemoX2;
extern unsigned char MemoY1;
extern unsigned char MemoY2;
extern unsigned char MemoRMargin;
extern unsigned char MemoLMargin;

// functions for internal use only
BOOL  GetMemo(long address, const char *callername);
BOOL  NoMemoInUse(const char *routinename);
char *DBT(void);

// end user functions
#ifdef WINDOWS

BOOL  WinReadMemo(long StartingMemoBlock, char *Dest,
	unsigned int MaxChars, unsigned int WrapWidth);
long  WinWriteMemo(char * AsciiBuffer, unsigned char Width);

#else

void  EditMemo(long *Memoadd, char *Parms);
void  SetMemoDisplayWindowTo(int x1, int y1, int x2, int y2,
        unsigned char style, char *title);
void  DisplayMemo(long BlockNumber);

#endif

double ActiveMemos(void);
void   SetMemoWidthTo(unsigned char LMargin, unsigned char RMargin);
void   PrintMemo(long BlockNumber);
void   SendMemo(long BlockNumber);
void   CreateMemoFile(char *Mfilename);
void   PackMemoFile(void);
long   CopyMemoFrom(unsigned char FromArea, long OriginalMemoField);
char   *ReadMemo(MemoFile *f, char *s);
char   *WriteMemo(MemoFile *f, char *s);
void   CloseMemo(MemoFile *f);
BOOL   EOFMemo(MemoFile *f);
MemoFile *OpenMemo(long *MemoPtr, char *Mode);

#ifdef __cplusplus
}
#endif

#endif //_TZMEMO
