/* filename: INIT.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TOPAZINI
#define _TOPAZINI

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#ifdef _MSC_VER
#include <signal.h>
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#define TOPAZINI

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WINDOWS
void  TZVidpopInit(void);
void  TZClockInit(void);
void  SyncTime(void);
void  TZCalcInit(void);
void  TZSaverInit(void);
void  TZBrowseInit(void);
void  TZDialogInit(void);
void  TZPickInit(void);
void  TZEditInit(void);
#endif

void  TZSayGetInit(void);
void  TZIndexInit(void);
void  TZParserInit(void);
void  TZDBFInit(void);
void  TZVFilesInit(void);
void  TZMemoInit(void);
void  TZPrintcomInit(void);

#ifndef WINDOWS
#ifdef _MSC_VER
static void topaz_c_break(int sig) {}
#else
static int topaz_c_break(void) { return 1; }
#endif
#endif

#ifdef __cplusplus
}
#endif

void InitTopaz(void)
{
  struct dosdate_t d;

#ifndef WINDOWS
 #ifdef _MSC_VER
  signal(SIGINT, topaz_c_break);
 #else
  ctrlbrk(topaz_c_break);
 #endif

  VectorTable[0].Vector = (void (interrupt *)()) _dos_getvect(TIMER_INTERRUPT);
  VectorTable[0].Handle = 1;
  atexit(TzCommonExitProc);
  TZVideoInit();
  ResetMouse();
#endif

  TopazRegisterFlags |= REGTZCOMMON;

  GetCountry();
  GetMachineInfo();
  _dos_getdate(&d);
  Epoch = (d.year / 100) * 100;  // sets the default epoch, dynamically

#ifndef WINDOWS
#ifdef TZVIDPOP
  TopazRegisterFlags |= REGTZVIDPOP;
  TZVidpopInit();
#endif
#endif

#ifdef TZSAYGET
  TopazRegisterFlags |= REGTZSAYGET;
  TZSayGetInit();
#endif

#ifndef WINDOWS
#ifdef TZCLOCK
  TopazRegisterFlags |= REGTZCLOCK;
  TZClockInit();
#endif

#ifdef TZTMDATE
  TopazRegisterFlags |= REGTZTMDATE;
  SyncTime();
#endif
#endif

#ifdef TZPARSER
  TopazRegisterFlags |= REGTZPARSER;
  TZParserInit();
#endif

#ifdef TZINDEX
  TopazRegisterFlags |= REGTZINDEX;
  TZIndexInit();
#endif

#ifdef TZDBF
  TopazRegisterFlags |= REGTZDBF;
  TZDBFInit();
#endif

#ifndef WINDOWS
#ifdef TZCALC
  TopazRegisterFlags |= REGTZCALC;
  TZCalcInit();
#endif

#ifdef TZSAVER
  TopazRegisterFlags |= REGTZSAVER;
  TZSaverInit();
#endif

#ifdef TZBROWSE
  TopazRegisterFlags |= REGTZBROWSE;
  TZBrowseInit();
#endif

#ifdef TZDIALOG
  TopazRegisterFlags |= REGTZDIALOG;
  TZDialogInit();
#endif

#ifdef TZPICK
  TopazRegisterFlags |= REGTZPICK;
  TZPickInit();
#endif

#ifdef TZEDIT
  TopazRegisterFlags |= REGTZEDIT;
  TZEditInit();
#endif
#endif

#ifdef TZVFILES
  TopazRegisterFlags |= REGTZVFILES;
  TZVFilesInit();
#endif

#ifdef TZMEMO
  TopazRegisterFlags |= REGTZMEMO;
  TZMemoInit();
#endif

#ifdef TZPRINTCOM
  TopazRegisterFlags |= REGTZPRINTCOM;
  TZPrintcomInit();
#endif
}

#ifndef WINDOWS
#ifndef _MSC_VER
#pragma startup InitTopaz
#define InitTopaz()
#endif
#endif

#endif //_TOPAZINI
