/* filename: INDEX.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZINDEX
#define _TZINDEX
#define TZINDEX

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifdef NETLOG
#ifdef WINDOWS
#error You shouldn't define NETLOG for Windows version.
#endif
#ifndef NET
#error You shouldn't define NETLOG before defining NET (in compiler #define-s).
#endif
#endif

#include <stdio.h>

#ifndef _TZCOMMON
#include <common.h>
#endif
#ifndef _NDXPARSER_H
#include <parser.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define DEFAULTCACHESIZE  0x4000 // default Cache size 16K

typedef char *(*PUDK_func)(void);// pointer to user defined keymaker
typedef char *  KeyPointer;
typedef char *  CacheType;

#ifdef NDX_TYPE

#define MAX_NDX_EXPRESSION_SIZE 100 // max index expression size < 100
#define BLOCK_SIZE 512 // our B-tree block size
#define PATH_DEPTH 9 // pseudo stack size
#define LESSNODE   (-1)
#define GRTRNODE   (-2)

typedef struct {
  // for details see Programmer's Journal v.8.6.
  // "B-tree indexing" by M.Steven Baker
  long   root;           // block No of the root block
  long   eof;            // block No where new blocks are added
  char   dummy1;         // 00
  char   type;           // db_type "C"-character,"D"-date,"N" or "F"
  char   dummy2[2] ;     // reserved
  short  key_len;        // length of the search key expression <=100
  short  keys_max;       // Maximum # of keys per block;  <= 56
  short  num_or_date;    // TRUE (1) if Numeric or Date Key
  short  group_len;      // key_len plus 8 padded to a multiple of 4
  char   dummy3[3];      // we do not use these now, maybe later ...
  char   unique;         // TRUE if index on unique keys only
  char  *expression;     // NULL-terminated key generation expression
 // char expression[100];  !dynamically allocated! up to 100 chars
} NDXHeader, * PNDXHeader;

typedef struct Node {
  long block_num;// For root and branch nodes, the block number
  long DBFRecNo; // The DBF record number for this key, -1 if PseudoNode
  char Key[100];
// char filler[??];  !key node length MUST be aligned on 4-byte boundary
//                    so if you need(?) to change Key size (say to Key[99])
//                    you should use filler (filler[1] for Key[99])
} Node, * PNode;

typedef struct {
  short num_keys; // number of keys in this block
  short modified; // pad to 4-byte boundary, I also use it as a flag
  char  block[BLOCK_SIZE - 2*sizeof(short)]; // the block read
} NDXBlock, * PNDXBlock;

typedef struct p_struct {
  struct p_struct *prev, *next;
  int      counter;
  int      filler;
  long     blockno[PATH_DEPTH]; // block numbers
  NDXBlock blocks[PATH_DEPTH];  // index blocks
} Path, * PPath;

// pointer to user-defined comparison routine that compares two items
// and returns a value based on the comparison. (memcmp syntax !)
typedef int (*PUDC_func)(const void *, const void *, size_t);

typedef struct IndexType {
  int       Ndx;    // file handle
  char     *fname;  // file name
  BOOL      parser; // flag either parser (TRUE) or KeyMaker (FALSE)
  NDXHeader header;
  PUDC_func cmp;

  BOOL Modified, kiss, reusable; // boolean flags
  BOOL BOFFlag, EOFFlag;
  BOOL SoundexFlag, Descending;

  PUDK_func KeyMaker;
  char     *KeyStorage;

  NDXBlock  BlockBuffer;    // current block
  PNDXBlock BlockBufferPtr; // pointer to current block
  long      currblock;      // current block no
  int       currnode;       // current nodeNo in block Index points to it
                            // currnode = -1 if Index points to Pseudo
  PNode Index; // current node ptr in the block
               //  (sometimes points  to Pseudo node)
  PPath cpath; // current block path in index tree beginning at root
  PPath path;  // linked list of paths
  PParseBufferStruct pparser;
} IndexType, * PIndexType;

#else  // NDX_TYPE

typedef struct HeaderRecordType { // must be same size as a node record !!
	unsigned      Version;
	long          FirstRec;
	long          LastRec;
	unsigned char KeyLength;
	unsigned char SpareFlag1; // boolean
	unsigned char SpareFlag2; // boolean
	long          TotalLiveNodes; // this should match the RECCOUNT in the DBF
  char          filler[111];    // padding up: to make the structure same size as a node record
} HeaderRecordType;

typedef struct {
    long DBFRecNo, // dbf record number for this key
         Entry,    // is this the node number?
         GrtrNode, // number of node containing key greater than this key
         LessNode, // number of node containing key less than this key
         PreviousNode;
         char Key[108];
} Node, * PNode;

typedef struct IndexType {
	int              Ndx;
  char            *fname;
	unsigned char    KeyLength;
	PUDK_func        KeyMaker;
	long             NodeSize;
	HeaderRecordType Anchor;
	Node             NodeBuffer;
  char            *KeyStorage;
  PNode            Index;
  BOOL             BOFFlag, EOFFlag;
  BOOL             Descending, SoundexFlag;
  BOOL             Modified;
} IndexType, * PIndexType;

#endif // NDX_TYPE

#ifdef NET
typedef struct SemaphoreType {
  char   Users, Reading;
  unsigned Changecount;
} SemaphoreType;

typedef struct SemaphoreRecord {
  int           SF;
  SemaphoreType Data;
  char          LogicalUser;
  unsigned      LastChange;
  int           LockFlag;
  int           Reading;
} SemaphoreRecord, * PSemaphoreRecord;

typedef enum {
  Login, Logout, IncRead, DecRead,
  LockSemaphore, UnlockSemaphore, CheckUserCount
} ActionType;
#endif

extern PIndexType    _tzfar Ind[AbsoluteMaxWorkareas][MaxOrder];
extern PIndexType    _tzfar SaveInd[AbsoluteMaxWorkareas][MaxOrder];
extern CacheType    *Cache[AbsoluteMaxWorkareas];
extern unsigned      CacheMemSize[AbsoluteMaxWorkareas];
extern PNode         PseudoNode[AbsoluteMaxWorkareas];
extern unsigned char OrderArray[AbsoluteMaxWorkareas];
extern long          IndexSize;
extern Node          NodeData;
extern unsigned char SoundexLength;

extern int  Found;
extern int  SyncOrder, SyncPOrder;
extern int  IndexFlushEnabled;
extern int  NeverCacheIndexes;
extern int  InhibitGo;
extern int  IndexExact;
extern int  FindingEdge;
extern int  IndexPresent;
extern int  ZerOrder[AbsoluteMaxWorkareas];


#ifdef NET

extern PSemaphoreRecord Semaphore[HelpWorkArea+1];

#ifdef NETLOG
extern int Sflog; // log file handle
#endif

#endif

#ifdef NDX_TYPE

extern void **CachePtrs[AbsoluteMaxWorkareas];
extern int    CachePtrsCount[AbsoluteMaxWorkareas];
extern int    UniqueOn;
extern int    NoDe; // node number, internal
extern int    ReusableBlocks;
extern BOOL   SilentValidMode;

#else

extern unsigned  CCacheSize[AbsoluteMaxWorkareas];
extern unsigned  CNSize[AbsoluteMaxWorkareas];

#endif

#define SetExactOn()  (IndexExact = TRUE)
#define SetExactOff() (IndexExact = FALSE)

#ifndef WINDOWS
#define SetOdometerOn()  (Odometer = TRUE)
#define SetOdometerOff() (Odometer = FALSE)
#endif

#ifdef NDX_TYPE

PNode Bfind_frst(PIndexType p);
PNode Bfind_last(PIndexType p);
PNode Bfind_key(PIndexType p, const void * key);
PNode Dfind_frst(PIndexType p, long block, int order, int path);
PNode Dfind_last(PIndexType p, long block, int order, int path);
PNode Dfind_key(PIndexType p, long block,int order,int path,const void * key);

void add_path(long block_no, int order);
void clean_path(int area, int order, int all);
int  double_compare(const void *, const void *, size_t);
long up_path(int order);
long up_path_next(int order);
long up_path_prev(int order);

int   AppendIndex(const char *key, int order);
void  BuildNewKey(void);
int   DeleteIndexNode(void *key, int order);
char *GetIndexExpr(int order);
void  IndexOn(const char *db_expr, const char *filename);
void  IndexOnCB(PUDK_func, const char *filename);
void  MakeIndex(const char *db_expr, const char *filename);
void  MakeIndexCB(PUDK_func, const char *filename);
void *ScanPaths(long block, int area, int order);
BOOL  SeekAndRead(int, int, long, void *);
BOOL  SeekAndWrite(int, int, long, void *);
BOOL  SetCacheTo(size_t size);
void  SetIndexExpr(const char *db_expr, int order);
void  SetIndexTo(const char *filenames);
void  SetIndexToCB(PUDK_func, const char *, int);
void  SetPseudoNode(int, int order);
void  SetUniqueOff(void);
void  SetUniqueOn(void);
BOOL  ValidIndex(const char *fname, BOOL thorough);
BOOL  ValidIndexCB(const char *fname, BOOL thorough, PUDK_func kmaker);

#else

void  AppendIndex(const char *key, int order);
void  DeleteIndexNode(int i);
unsigned GetNodeSize(const char *, char *);
void  IndexOn(PUDK_func, const char *filename);
void  MakeIndex(PUDK_func, const char *filename);
BOOL  SeekAndRead(int, int, long, PNode);
BOOL  SeekAndWrite(int, int, long, PNode);
BOOL  SetCacheTo(size_t size, const char *filename);
void  SetIndexTo(PUDK_func, const char *, int);
void  SetPseudoNode(int, int order, long entry);

#endif

void  assertJumper(void);
void  AppendNewKey(void);
void  CheckForAlreadyOpenIndex(const char *, int, int);
void  CloseIndexes(void);
void  CloseOneIndex(int area, int order);
void  CloseWorkArea(int area);
void  CompareKeys(void);
unsigned char CurrentOrder(void);
void  DeallocateCache(int area);
void  DeallocateInd(int area, int order);
void  DeallocateKeyStorage(int area, int order);
void  DeallocatePseudoNode(int area);
char *FarKey(int order);
long  FindFirstRecFunc(void);
long  FindLastRecFunc(void);
void  Find(const char *key);
void  _Find(const char *key);
void  FindNear(const char *key);
long  FindNextRecFunc(void);
long  FindPriorRecFunc(void);
void  GetNode(long nodenum, int order);
BOOL  IBOFFunc(void);
BOOL  IEOFFunc(void);
char *IndexName(int order);
BOOL  IndexOpenFunc(void);
void *KeyMakerFunc(int order);
char *MakeDescending(char * s);
char *NDX(int order);
void  OpenIndex(PUDK_func, const char *, int, int, int, int, char *);
void  Reindex(void);
void  SetBOF(void);
void  SetBOFFlagProc(void);
void  SetIndexCacheTo(unsigned size);
void  SetEOF(void);
void  SetEOFFlagProc(void);
void  SetIndexFlushOn(void);
void  SetIndexFlushOff(void);
void  SetOrderTo(unsigned char n);
void  SetOrderToPrim(unsigned char n);

#ifdef NET

BOOL CheckForChange(void);
void HandleSemaphore(char areano, ActionType action);
BOOL IndexesChanged(void);
void ReadAnchorNode(int area, int order);
void ResetCache(void);
void SetLockSemaphoreProc(int on);
void SetReadSemaphoreProc(int on);
unsigned char UserCount(char area);

#ifdef NETLOG
void OpenLogFile(void);
void WriteLog(const char * s);
#endif

#endif

void  SetSoundexTo(unsigned char len);
void  SoftSyncIndex(void);
int   SortOrderFlag(int order);
char *Soundex(char * s);
int   SoundexFlag(int order);
char *SqueezeExpression(char *, int if_fname);
void  StoreCurrentKeys(void);
void  SyncIndexProc(void);
void  TZIndexInit(void);
void  WriteAnchorNode(int area, int order);

void  RawGo(long); //--- in DbfProcedures
void  SUnlock(void);
int   IsExclusive(void);
int   SLock(void);
int   ValidRec(void);
char *DBF(void);
void *GetSyncProcPtr(void);
void  SetSyncProcPtr(void (*p)(void));
long  RecCount(void);
long  RecNo(void); //--- end in DbfProcedures

#ifdef __cplusplus
}
#endif

#endif // _TZINDEX

