/* filename: EDIT.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZEDIT
#define _TZEDIT
#define TZEDIT

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifndef _TZSAYGET
#include <sayget.h>
#endif

#ifndef _TZVIDPOP
#include <vidpop.h>
#endif

#ifndef _TZPICK
#include <pick.h>
#endif

#ifndef _TZDIALOG
#include <dialog.h>
#endif

#ifndef _TZDBF
#include <dbf.h>
#endif


#ifdef _MSC_VER
#ifndef _GWINDOW
#include <graph.h>
#endif
#define window(x1,y1,x2,y2) _settextwindow((short)y1, (short)x1, (short)y2, (short)x2)
#define clrscr()            _clearscreen(_GWINDOW)
#define getcwd              _getcwd
#define chdir               _chdir
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define FALSE  0
#define TRUE   1
#define AF10   'q'
 // feature constants for use with SetEditorColorTo and SetMemoColorTo
#define NormalText  1
#define BlockText   2
#define Frame       3
#define Status 	    4
#define DialogFrame 5
#define DialogText  6
#define PickText    7
#define PickBar     8
#define HelpFrame   9
#define HelpText   10
 // function constants for assigning key functions to the key maps
#define _nofunc     0
#define _backsp     1
#define _blockoff   2
#define _readblock  3
#define _writeblock 4
#define _copyblock  5
#define _moveblock  6
#define _delblock   7
#define _printblock 8
#define _quicksave  9
#define _exitsave  10
#define _quitnosave 11
#define _searchcont 12
#define _search     14
#define _replace    15
#define _findblockb 16
#define _findblocke 17
#define _delword  18
#define _delline  19
#define _tab      20
#define _enter 	  21
#define _insline  22
#define _escape   23
#define _backtab  24
#define _help     25
#define _sethelp  26
#define _savefile 27
#define _setdir   28
#define _loadfile 29
#define _setext   30
#define _merge 	  31 // not implemented
#define _setmerge 32 // not implemented
#define _print 	  34
#define _setprint 35
#define _gotoln   36
#define _resize   37
#define _zap      38
#define _home     40
#define _pgdown   41
#define _curleft  42
#define _curright 43
#define _curdown  44
#define _curup 	  45
#define _pgup     46
#define _endln    47
#define _ins 	  48
#define _del      49
#define _prevword 50
#define _nextword 51
#define _endfile  52
#define _beginfile 53
#define _blockbeg  54
#define _blockend  55
#define _end 	   56
#define _quickexit 58
#define _ctrchars  59
#define _setwidth  60
#define _reformat  61
#define _togglewrap 62
#define _changefilename 63 
#define _userdefined    255

#define BSIZE 512 // Memo block size
#define RulerChars "1234567890"
#define hard TRUE
#define soft FALSE
#define _UNDEFINED 254
#define ReservedMemory 1000
#define SoftCR '\x8D'

typedef char String80[81];
typedef char Scrtype[66][80][2]; // support up to 66 line screens
typedef char String3[4];
typedef char DirStr[68];
typedef char NameStr[9];
typedef char ExtStr[5];
typedef char String256[STRSIZ];

typedef struct EdMenuRecord {
  String80 MenuItem;
  int ItemLoc;
} EdMenuRecord;

typedef EdMenuRecord MenuType[50]; // Menuvars for help system

typedef struct ColorScheme {
  unsigned char
  TextFG,        TextBG,
  BlockFG,       BlockBG,
  FrameFG,       FrameBG,
  StatusFG,      StatusBG,
  DialogFrameFG, DialogFrameBG,
  DialogTextFG,  DialogTextBG,
  PickTextFG, 	 PickTextBG,
  PickBarFG, 	 PickBarBG,
  HelpFrameFG,   HelpFrameBG,
  HelpTextFG,    HelpTextBG;
}ColorScheme;

typedef struct BoxRecord {
  unsigned char blox, bloy, brux, bruy; //box coordinates
  unsigned char wlox, wloy, wrux, wruy; // window coordinates
  unsigned char LineStyle;
  String80 Header;
}BoxRecord;

typedef enum { NoMoveMode,Grow,Shrink,MoveMode } MoveModeType;
typedef char getbuftype[BSIZE];
typedef struct Configuration {// things the user can change at run time
  char HeaderConf[40];
  unsigned char Version[16];
  unsigned char c1, r1, c2, r2; //box coordinates
  PathStr HelpFile; // help filename
  PathStr DefaultDir; // active directory
  char DefaultExt[4];
  char LPTNumber[2];
  int LeftMargin;
  int TopMargin;
  int LinesPerPage;
  int WrapEnabled;
  unsigned char WrapWidth;
  PathStr filename;
  unsigned char SpareBytes[128];
}Configuration;

typedef enum { SaveBlock,SaveWithPrompt,SaveWithNoPrompt } FilePromptMode;
typedef struct SaveMemoRecord {
  int SaveWrap;
  unsigned char SaveWordWrapWidth;
  ColorScheme PushedMemoColors;
  BoxRecord PushedMemoBox;
  char *SaveJumpTable[AF10+1];
}SaveMemoRecord;

extern void (*UserFunction)(int *);
void EditText(const char *);
void SetEditorWindowTo(int, int, int, int, unsigned char, char *);
void SetEditorColorTo(unsigned char, unsigned char, unsigned char);
void SetMaxLinesTo(unsigned);
void SetEditFKey(char, void (*HotKeyPtr)(void));
void ResetDefaultEditorKeys(void);
void PasteString(char *);
void SaveEditConfig(char *);
void RestoreEditConfig(char *);
void SetTextPosTo(unsigned, unsigned);
 // Memo related routines
void SetMemoWindowTo(unsigned char, unsigned char, unsigned char,
     unsigned char, unsigned char, char *);
void SetMemoColorTo(unsigned char, unsigned char, unsigned char);
int  BwriteOK(FilePromptMode);
void ClearBlockMarkers(void);
void ComputeWindowCoordinates(void);
void CursorDown(void);
void CursorLeft(void);
void CursorRight(int);
void CursorUp(void);
void Del(void);
void DeleteLine(void);
void DisplayEditorStatus(void);
void DrawScreen(void);
void EdBackSpace(void);
void EdBox(unsigned char,unsigned char,unsigned char,
           unsigned char, unsigned char, char *);
char EditDialogBox(const char *);
void EdReformat(unsigned char);
void Enter(void);
void ForgetEdiDynString(int);
void FuncEnd(void);
void GetBlockEdgeStrings(void);
void GetRawName(char *, char *);
void Home(void);
void InsertEdit(char *, char *, int);
void MakeEdiDynString(char *, int);
void PadTo(char *, int);
void RefreshStatus(void);
void Scroll(void);
int  ScrollLock(void);
void SetBlockColors(void);
void SetChangedFlags(void);
void SetStatusColors(void);
void SetTextColors(void);
void WindowEdit (char *, char *);
void WriteToEOL(char *, unsigned char, unsigned char);
//  Help related routines--for use by TOPAZ help system only
int  PushMemoData(void);
void PopMemoData(void);
void GetMemoCoordinates(long *, long *, long *, long *);
void TZEditInit(void);

extern int  ScrollBarsEnabled, Zapped, NeverChanged;
extern int  EditorShade,  Expl, EditInsertmode, ScreenLine;
extern int  CurrentLine,  Ruler, EditNoDisplay,  EditScreenSaved,  EditChanged;
extern int  AutoSaveChanged, EditColumn, ScreenColumn;
extern int  copyb, copye, Lmarg, TMarg, lpp, Wrap, BlockMarked;
extern int  BlockStartLine, BlockEndLine, BlockDiff, BlockStream;
extern int  editnoedit, noresize, norestore;
extern int  nostatus, AutoSave, fullscreen;
extern int  NoHelp, nocreate, NoMouse, PrinterEject;
extern int  ExitEdit, SaveOrder, strokes;
extern char LPTNumber[2], _tzfar RawFilename[13];
extern char _tzfar BlockHead[STRSIZ],_tzfar BlockTail[STRSIZ], _tzfar Defaultname[80];
extern char DefaultExt[4];
extern char Retry_Abort_Chars[3], yes_no_chars[3];

#ifdef GERMAN
extern char  yes_no_buttons[16],  Retry_Abort_buttons[30];
#else
extern char  yes_no_buttons[15],  Retry_Abort_buttons[20];
#endif

extern unsigned char  minwid, BlockStartColumn, _tzfar KeyMap[28][28];
extern unsigned char  WordWrapWidth, BlockEndColumn, _tzfar FKeyMAP[241];
extern PathStr _tzfar editfilename, _tzfar BlockFilename,_tzfar helppath,_tzfar actdir;
extern MoveModeType  ResizeMode;
extern ColorScheme  EditColors, MemoColors, ActiveColors;
extern BoxRecord  EditBox, MemoBox, ActiveBox;
extern Scrtype *BufPtr, *Screen;

#ifdef __cplusplus
}
#endif

#endif
