/* filename: DIALOG.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZDIALOG
#define _TZDIALOG
#define TZDIALOG

#ifdef TOPAZINI
#error You should put INIT.H as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifndef _TZVIDPOP
#include <vidpop.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define TZSAYGET  // TZDialog internally uses SayGet and VIDPOP
                  // so they both must be initialized

#define Bright 		"\x01"
#define Dim  		"\x02"
#define Highlight 	"\x03"
#define Flash 		"\x04"
#define Reverse 	"\x05"
#define EndFrame   	"\x06"

#define CenterHoriz 255
#define CenterVert  255
#define MaxTriggers 50

#define StayOn            "\x01"// tells DialogBox not to wait for a key,
								// but leave the message on the screen
#define StayOnNoCursor    "\x02"// same as above, but leave with the cursor off
#define PressAnyKey       "\x03"
#define ScrollPressAnyKey "\x04"
#define BlinkPressAnyKey  "\x05"

typedef struct ProgressRecord {
  int           r1, c1, r2, c2;
  int           LineStyle;
  char          Header[81];
	unsigned char BarFG, BarBG, BoxFG, BoxBG;
	char          Alias[11];
} ProgressRecord;

typedef struct DialogRecord {
  int           r1, c1;
	int           LineStyle;
	char          Header[81];
	unsigned char MessageFG, MessageBG, BoxFG, BoxBG;
	unsigned char ButtonSFG, ButtonSBG, ButtonFG, ButtonBG;
} DialogRecord;

#define SuspendProgress() (ProgressEnabled = FALSE)
#define ResumeProgress()  (ProgressEnabled = TRUE)

void  SetProgressWindowTo( int c1, int r1, int c2, int r2,
                           int lineStyle, const char *header);
void  SetProgressColorTo(unsigned char boxFG, unsigned char boxBG,
                         unsigned char barFG, unsigned char barBG);
void  SetProgressHeaderTo(const char * msg);
void  SetProgressOn(void);
void  SetProgressOff(void);
void  LowLevelSetProgressOn(void);
void  UpdateProgress(void);

void SetDialogWindowTo(int c, int r, int lstyle, const char *header);
void SetDialogColorTo(unsigned char _boxFG, unsigned char _boxBG,
                      unsigned char _messageFG, unsigned char _messageBG);
void SetButtonColorTo(unsigned char fg, unsigned char bg,
                      unsigned char sfg, unsigned char sbg);
char  DialogBox(char *message, char *permissableReturnChars);
void  RemoveDialogBox(void);

void  Menu(const char * MenuChoices);
void  RemoveMenu(void);
void  SetMenuWindowTo( int col, int row, int lstyle,const char *head );
void  SetMenuColorTo(unsigned char FGBoxColor, unsigned char BGBoxColor,
       unsigned char FGBarColor, unsigned char BGBarColor);
void  SetMenuTriggerTo(unsigned char FGColor, unsigned char BGColor);

void  StartProgress(long max);
void  AdvanceProgress(void);
void  PositionProgress(long n);
char *Alias(void); // DBF4 function

// VARS FOR ALL ROUTINES
extern char ProgressChar;   //  Default: half char  
extern char MenuSeparatorChar;
extern char DialogNewLine; // initialized to ';'
extern int  AddProgressScale;  // boolean
extern int  LeaveMenusDisplayed;  // boolean
extern int  StayOnUntilRemoved;  // boolean

extern unsigned char  MenuMargin;
extern DialogRecord * DialogSpecPtr;
extern unsigned char  DialogCol;   //  Column and row where a dialog box actually appears
extern unsigned char  DialogRow;   //  meaningless except when dialog is active

extern int FancyButtons;   // if true, buttons are done with half-shadows,
                           // else buttons are simply moving bar menu

extern int  WindowsOnStack;
extern int  WithScale;
extern char _tzfar MenuHeading[STRSIZ];
extern int  MenusOnStack;

extern unsigned char MenuLineStyle;
extern unsigned char BGBar;
extern unsigned char BGBox;
extern unsigned char FGBar;
extern unsigned char FGBox;
extern unsigned char BGTrig;
extern unsigned char FGTrig;
extern unsigned char ULCol;   // User specified menu corner coordinates
extern unsigned char ULRow;

extern int DontTouchCursor;   // boolean
extern int ProgressEnabled;
extern int SkipThisTime;
extern int AutoProgress;

extern ProgressRecord _tzfar Progress;
extern DialogRecord   _tzfar _Dialogue;

extern unsigned char  FullBar;
extern unsigned char  LastBarPos;
extern unsigned char  StartingBarPos;
extern unsigned char  BarWidth;
extern unsigned char  Pr1, Pr2, Pc1, Pc2;
extern unsigned int   CursorVariable, ProgressX;
extern long           LastRecNo, ProgressN, PriorRecNo, ProgressPos;

extern WindowRec SaveWindow;

#ifdef __cplusplus
}
#endif

#endif // _TZDIALOG

