/* filename: DBF.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZDBF
#define _TZDBF
#define TZDBF

#include <stdio.h>
#include <share.h>

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef _TZCOMMON
#include <common.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MaxFieldCount 255    //  maximum number of fields allowed per database record
#define MaxHeaderSize (32*(MaxFieldCount+1)+1) // maximum number of bytes in a file header

#define DB2File 0x02
#define DB4File 0x03
#define DB3WithMemo    0x83
#define DB4WithDB3Memo 0x83
#define DB4WithDB4Memo 0x8B

// FileMode constants:
#define DefaultReadWriteMode SH_DENYRW

#ifdef NET
#define NonSharableReadWrite SH_DENYRW
#define SharableReadWrite    SH_DENYNO
#endif

#define FirstLock        -1
#define LastLock         -2
#define AllLocks         -3
#define FLockSize  0x3FFFFFFFL // foxbase compatible
#define LockOffset 0x40000000L // foxbase compatible

typedef enum { NotLocked, FileLocked, AppendLocked, RecordLocked } LockType;

typedef struct LockListRec {
  long RecNo;
  struct LockListRec *NextLock;
} LockListRec;

// public global types
typedef char Fldname[11];
typedef char string10[11];

// Maximum record size of 4000 bytes + deleted flag = 4001 bytes
typedef struct FieldRecord {
  Fldname Name; // field name
  char Typ; // field data type
  char Len; // field length including any decimal point and decimal places
  char Dec; // number of decimal places for numeric fields
  unsigned Off; // field offset calculated at runtime
} FieldRecord;

typedef enum {
  doNothing, doCloseLL, doDeleteLL, doGetLL, doOpenLL, doPackLL,
  doPopLL, doPushLL, doPutLL, doRecallLL, doSnipLL, doSortLL, doZapLL
}  LLActionType;

typedef FieldRecord FieldArray[MaxFieldCount]; // Max fields per record
typedef FieldRecord *dFields;
typedef enum { NotOpen, NotUpdated, Updated, Appended } StatusType;
typedef enum { Disk, Heap,  Ems, Ext, Best, Biggest } DataStorageType;
typedef enum { FIFO,  LIFO, INSERTION, ASCENDING, DESCENDING } LStatusType;
typedef char FieldDescType[32];
typedef char HeaderPrologType[32];
typedef char HeaderType[MaxHeaderSize+1]; // maxheadersize
typedef struct dbfRecord {
  char         FileName[65];
  HeaderPrologType HeadProlog;
  int      HasMemo;
  int      HeadLen;
  unsigned RecLen;
  int      NumFields; // number <= 255
  FieldRecord *Fields;
  StatusType dStatus;
  char     LastUpdate[9];
  char     *CurRecord;
  long     NumRecs;
  long     CurRecNo;
  int      EOFile;
  int      BOFile;
  unsigned Fmode; // file mode
  int      HighLevel; // was USE called to open this file?
  void (*EncryptProc)(char *rec, unsigned reclen);
  void (*DecryptProc)(char *rec, unsigned reclen);
  union {
    int   dFile;
    struct {
      void *LLHeadPtr;
      void *LLTailPtr;
      void *CurrentPtr;
      LStatusType LStatus;
      long  TargetRecNo;
      LLActionType Action;   // set of byte
      DataStorageType DataLoc;
      char *(*KeyMaker)(void);
      char  Spare[9]; // this pads the record to 32 bytes
      // this is the first byte of the user part of the file var
      int   LinkedList;
    } strue;
   } v;
} dbfRecord;

typedef struct MemoAreaType {
  FILE * Memofile;
  PathStr Memofilename;
} MemoAreaType;

typedef struct WorkAreaType {
  dbfRecord Handle;
  void *UserRec;
  unsigned UserRecSize;
  int Deallocate; // flag to tell us that we need to deallocate an "untyped" buffer
  BOOL (*FilterFunc)(void);    // address of call-back filter function
  void *FilterExprHandle; // expression handle of filter expression
  BOOL (*WhileFunc)(void);  // address of call-back "while" function
  void *WhileExprHandle; // expression handle of "while" expression
  void (*SyncProc)(void);
  string10  Alias;
  void (*DataDef)(void);
  MemoAreaType *MemoArea;
  LockType LockStatus;
  unsigned LockCount;
  struct LockListRec *LockList;
#ifdef NET
  int  Exclusive; // try to unlock different bytes
  void *SwapBuffer; // used during replace
#endif
} WorkAreaType;

typedef struct MemoRoutinesRecord {
  void (*_LowLevelMemoPack)(void);
  void (*_OpenMemoFile)(char *fname);
  void (*_CloseMemoFile)(void);
  long (*_CopyMemo)(unsigned char * n, long *d);
  void (*_CreateMemoFile)(char *fname);
  long (*_AddMemo)(char * s);
} MemoRoutinesRecord;

// enumerated types of word processors for use with CopyToMerge procedure
typedef enum {
   WordPerfectA, WordPerfectB, WordStar2000, WordStarClassic,
   WordStar60, LeadingEdge, MSWord, MSWorks, Excel, AmiPro
} WordProcessorType;

extern int AutoFixRecCount;

// public global vars
extern WorkAreaType *WorkArea[AbsoluteMaxWorkareas];
extern unsigned DbfFileMode;
extern unsigned MaxRecordLocks;
extern int ExitSearch;
extern int CreateMemoType;
extern void (*UsersEncryptProc)(char *record, unsigned reclen);
extern void (*UsersDecryptProc)(char *record, unsigned reclen);

#ifndef WINDOWS
extern int  RotorEnabled;
extern int  RotorX, RotorY;
extern char *RotorPointer;
#endif

extern int  FlushEnabled; // not version conditional
extern int  FileMode;
extern unsigned char CRLF[]; // = { 10, 13 };

// memo handling vars for internal use
extern MemoRoutinesRecord MemoRoutines;

// high level procedures and functions
char *Alias(void);
void  Append(void);
void  AppendFrom(const char *FileName);
void  ClearRecord(void); // clears copy of record in memory only
void  CloseDatabases(void);
void  CopyFile(const char *source, const char *dest);
void  CopyStruTo(const char *newfile);
void  CopyTo(const char *newfile);
char  CurrentArea(void);
void  DeleteRec(void); // updates user record and writes flag only to disk
char *DBF(void);
void  EraseFile(const char *FileName);
char *Field(int n);
void *FieldAddress(int i);
int   FieldCount(void);
int   FieldNo(const char *fieldname);
char  FieldType(int i);
unsigned char FieldLen(int i);
char  FieldDec(int i);
char *SField(int i);
BOOL  Deleted(void);
void  Go(long n);
void  GoBottom(void);
void  GoTop(void);
char  *LUpdate(void);
void  Pack(void);
long  RecCount(void);
long  RecNo(void);
unsigned RecSize(void);
void  RecallRec(void); // updates user record and writes flag only to disk
void  RenameFile(const char *FileName, const char *newfilename);
void  Replace(void);

#ifndef WINDOWS
void  SetTalkOff(void); // default
void  SetTalkOn(void); // permits display of counter during PACK
#endif

void  Skip(long n);
void  Select(char area); // default = 1
void  SelectAlias(const char *Alias);
void  SetAutoHaltOff(void);
void  SetAutoHaltOn(void); // default
void  SetAliasTo(const char *alias);
void  SetDataDefinitionTo(void (*UsersDefPtr)(void));
void  SetDeletedOff(void); // default
void  SetDeletedOn(void);
void  SetFilterToCB(int (*filterproc) (void));
void  SetFilterTo(const char *expr);
void  SetFlushOff(void); // default
void  SetFlushOn(void); // causes DOS buffers to be flushed to disk after edits
void  SetSafetyOff(void); // default
void  SetSafetyOn(void); // only works with and PACK and ZAP
void  SetSearchTo(void (*ScanPtr)(void));
void  SetRelationTo(void (*sync)(void));
void  Use(const char *filename, void *buffer, unsigned size);
void UseEncrypted(const char * filename, void * buffer, unsigned size,
                  void (*EncryptProc)(char * rec, unsigned len),
                  void (*DecryptProc)(char * rec, unsigned len));
void  Zap(void);
BOOL  dBOF(void);
BOOL  dEOF(void);
int   ValidFilename(const char *fn);
void  Search(const char *s, int *fieldno, BOOL startattop); // selected DBF
void  SearchFile(const char *FileName, const char *S, long *offset); // any non-open file
char *Peek(int FieldNum, long RecordNum);
void  Poke(const char *s, int FieldNum, long RecordNum);
void  FlushDbf(void); // for use when Flush is not ON

//  low level procedures
void  AppendDbf(dbfRecord *d);
void  CloseDbf(dbfRecord *d);
void  CreateDbf(dbfRecord *d, const char *NewName, int fcount, FieldRecord *Structure);
void  GetDbfRecord(dbfRecord *d, long RecNum);
void  OpenDbf(dbfRecord *d);
void  PutDbfRecord(dbfRecord *d, long RecNum);

#ifndef WINDOWS
void  DisplayStatus(void);
void  SetRotorOn(void);
void  SetRotorOff(void);
void  SetRotorTo(int x, int y);
void  SetRotorSymbols(char s1, char s2, char s3, char s4);
void  AdvanceRotor(void);
#endif

void  List(const char * Command);
void  SetWhileToCB(int (* UsersWhilePtr)(void));
void  SetWhileTo(const char *expr);
char  WhichArea(const char * AliasName);
int   Different(const char * a, const char * b, unsigned size);

// "major" network routines
BOOL FLock(void);
BOOL RLock(void);
BOOL ALock(void);
void Unlock(void);
BOOL IsLocked(LockListRec *ListPtr, long n);
BOOL AddLock(void);
long LockCount(void);
void SetExclusiveOn(void);
void SetExclusiveOff(void);

// routines to determine existance of a LAN, and drive location
extern int (*NetErrorProc)(void);

BOOL  NetworkFound(void);
BOOL  DriveIsRemote(unsigned char Drive);

// "minor" network routines
BOOL  bad_field_param(const char *, int, int);
void  SetRetryTo(char count, char delay);
void  SetDosRetryTo(int count, int delay);
void  SetNetErrorTo(int (* p)(void));
char *UniqueFilename(void);
void  CommitDbf(void); // makes sure directory is updated on network drives
unsigned LockUnlock(char mode, unsigned Handle, long offset, long size);
BOOL  NotInUseError(const char *FuncName);
void  CopyToSDF(const char *fn);
void  AppendFromSDF(const char * fn, BOOL (* ValidFunc)(void));
void  CopyToMerge(const char * fn, WordProcessorType WP, void (*CleanUpProc)(void));

#ifdef __cplusplus
}
#endif

#endif
