/* filename: COMMON.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZCOMMON
#define _TZCOMMON
#define TZCOMMON
#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

typedef int BOOL; // Boolean type Windows compatible

#ifdef GERMAN
#include <topaz.ger>
#else
#include <topaz.eng>
#endif

#include <msc.h>    // some additions for Microsoft C

#ifdef __cplusplus
extern "C" {
#define SQZfile extern "C" void _pascal
#else
#define SQZfile            void _pascal
#endif

#ifndef WINDOWS

#define NoLine     0
#define SingleLine 1
#define DoubleLine 2
#define SolidLine  3
#define SingleTopDoubleSide 4
#define DoubleTopSingleSide 5
#define Shadow     0x80
#define Explode    0x40
#define Raised     0x20
#define Recessed   0x10
#define NoHeader   ""

#endif

//---------------------------------------------------------------------
//   You can comment out the next line to use the old index schema
//   with default .IND extension. Otherwise dBASE compatible NDX-schema
//   will be used (has default .NDX extension)
//---------------------------------------------------------------------
#define NDX_TYPE
//#define NETLOG

#define FALSE  0
#define TRUE   1
#define STRSIZ 256  // default string length
#define MAXINT 0x7FFF  // maximum value of a signed integer
#define TIMER_INTERRUPT  0x1C
#define MAX_VECTORS 10

#ifdef __TURBOC__
#define _tzfar _far
#endif

#define AbsoluteMaxWorkareas 35

// hidden workareas
#define HelpWorkArea   (AbsoluteMaxWorkareas - 1) // 34
#define HiddenWorkArea (AbsoluteMaxWorkareas - 2) // 33 used in CopyTo, etc.

// maximum number of _available_ workareas
#define MaxWorkAreas   (AbsoluteMaxWorkareas - 2) // 33
#define MaxOrder 16   // maximum number of index files per database

// predefined identifiers for date formats and country code
#define American 0
#define USA 0
#define Ansi 1
#define British 2
#define Britain 2
#define Italian 3
#define Italy 3
#define French 4
#define France 4
#define German 5
#define Germany 5
#define Spanish 6
#define Spain 6
#define FrenchCanadian 7
#define Quebec 7
#define Russian 8
#define Russia 8

// unit registration flags

#define REGTZCOMMON   0x00000001L
#define REGTZVIDPOP   0x00000002L
#define REGTZSAYGET   0x00000004L
#define REGTZCLOCK    0x00000008L
#define REGTZTMDATE   0x00000010L
#define REGTZINDEX    0x00000020L
#define REGTZDBF      0x00000040L
#define REGTZCALC     0x00000080L
#define REGTZSAVER    0x00000100L
#define REGTZBROWSE   0x00000200L
#define REGTZDIALOG   0x00000400L
#define REGTZPICK     0x00000800L
#define REGTZEDIT     0x00001000L
#define REGTZVFILES   0x00002000L
#define REGTZMEMO     0x00004000L
#define REGTZPRINTCOM 0x00008000L
#define REGTZPARSER   0x00010000L

// error number assignments

// DBF and INDEX error codes returned in DBFError
#define NotDbfFile    210  // first Byte was not a 3, 83h, or 2 (dBASE II)
#define InvalidField  211  // invalid field type was found in file header
#define OutOfRange    212  // tried to read a record beyond the correct range
#define PartialRead   213  // only a partial record was read from disk
#define AlreadyInUse  214  // dbf already open in another workarea
#define NotInUse      215  // no database open in current work area
#define BadSize       216  // user data structure wrong size
#define InsufficientMemory 217 // not enough memory
#define DupeHandleError  219   // unable to flush buffer of current file
#define InvalidParameter 220   // e.g. select(34)
#define IndexNotOpen     221
#define CorruptedFile    222
#define WrongVersion     223
#define CyclicalRelation 224
#define ExclusiveUseRequired 225
#define BrowseNotActive  226
#define dBASEIVMemosNotSupported 229

// TimeDate TimeError codes
#define NoColon            239
#define BadChar            240
#define InvalidTime        241
#define NegativeTime       242
#define DifferenceNegative 243

#define InternalError      254

// Linked list (Virtual file) error codes
#define InvalidLLOperation 1100
#define LLUnitNotThere     1101
#define MemoryManagement   1102

#define InvalidOperation   1103

// Multi-user errors
#define RecordNotLocked    1200
#define FileNotLocked      1201
#define SemaphoreError     1202

#define FileTypeNotSupported 1300

#define SetEpochTo(x)      (Epoch = x)

#ifndef WINDOWS
typedef struct VectorTableType {
  void (interrupt _far *Vector)();
  unsigned char Handle;
} VectorTableType;
#endif

typedef struct DataDefinitionType {
  unsigned char Column;
  char Prompt[81];
  char Picture[81];
  char LoRange[15];
  char HiRange[15];
  int BlankField;
  int NoEdit;
  void (* ValidatePtr)(void);
  void (* AutoHelpPtr)(void);
  unsigned char PromptForeGround, PromptBackGround;
  char DBFAlias[11];
  char FieldName[11];
  unsigned char Row;
  int Required;
  char VirtualField[81]; // column contents specified at run-time
} DataDefinitionType;

// Since DBF do not "use" INDEX (and others each other), the
// following data structures are used to communicate pointers to shared
// routines between them.

typedef struct IndexProcedures {
  void  (*FindProc)(const char *);
  BOOL  (*IndexOpenFunc)(void);
  void  (*SyncIndexProc)(void);
  long  (*FindNextRecFunc)(void);
  long  (*FindPriorRecFunc)(void);
  long  (*FindFirstRecFunc)(void);
  long  (*FindLastRecFunc)(void);
  BOOL  (*IEofFunc)(void);
  BOOL  (*IBofFunc)(void);
  void  (*AppendNewKey)(void);
  char *(*IndexNameProc)(int);
  void  (*StoreCurrentKeys)(void);
  void  (*CompareKeys)(void);
  void *(*KeyMakerFunc)(int x);
  void  (*SetBofFlagProc)(void);
  void  (*SetEofFlagProc)(void);
  int    *FoundVar;
  void  (*ReindexProc)(void);
  void  (*CloseSelectedProc)(void);
  BOOL  (*SortOrderFlag)(int v);
  BOOL  (*SoundexFlag)(int v);
#ifdef NET
  void  (*SetReadSemaphoreProc)(int semaphore);
  void  (*SetLockSemaphoreProc)(int semaphore);
#endif
} IndexProcedures;
extern IndexProcedures IndexRoutines;

typedef struct ParserProcedures {
  void *(*AssignExprFunc)(const char *);
  void *(*EvaluateFunc)(void *);
  void  (*DisposeExprProc)(void *);
} ParserProcedures;
extern ParserProcedures ParserRoutines;

#ifdef NET
BOOL  IsExclusive(void);
#endif

// string types used for filenames
typedef char String3[4];
typedef char PathStr[80];
typedef char DirStr[68];
typedef char NameStr[9];
typedef char ExtStr[5];

#ifdef WINDOWS
typedef struct {
  unsigned char Xmin, Ymin, Xmax, Ymax;
} CrtWindType;
extern CrtWindType *CrtWindow;

#else
typedef struct EditorProcedures {
  void (*EditTextProc)(char *);
} EditorProcedures;
extern EditorProcedures EditorRoutines;

extern void (*EditMemoProc)(long *, char *);

typedef struct HelpProcedures {
  void (*DoHelpProc)(char);
} HelpProcedures;
extern HelpProcedures HelpRoutines;

// help system types:
typedef enum {
  _None, _Menu, _Dialog, _DataEntry, _Pick,
  _Tag, _Browse, _Calendar, _Edit, _Memo,
  _Wait, _HelpSystem, _Calculator, _User
} ActivityType; // for user-defined activities
#endif

// external arrays, pointers and variables 
extern long  TopazRegisterFlags;

extern DataDefinitionType *DataDefinition;

extern void (* LLRoutines)(void *d);// points to linked-list jump table when VFILES is linked in
extern int   IndexPresent;  // TRUE if INDEX linked in
extern unsigned int  DBFError;
extern BOOL  UsingDbaseOrder;
extern char  _tzfar ErrorMessage[STRSIZ];
extern int   AutoHalt;
extern int   CenturyOn;
extern unsigned Epoch;
extern int   SafetyOn;
extern int   IgnoreDel;
extern unsigned char DateFormat; // American..Spanish
extern unsigned char Country;   // USA..Spain
extern int   dBASEOrder;

extern int   FileModeOverride; //  user's choice of FileMode
extern char  _tzfar AlternateName[80];
extern int   AlternateOn;
extern int   PrintOn;
extern int   AlternateOpen;

// modified by SetCountryTo:
extern char BooleanSaySet[3];
extern char DecimalSymbol; // except Germany, Italy, France, Spain
extern char ThousandsSeparator;

extern unsigned char (* PrinterStatus)(void);
extern BOOL (_far * UserPrinterCheck)(void);// used by PrinterReady to check printer status
extern void (* UserErrorHandler)(void);

// Vars shared by MEMO and EDIT
extern char  EndE[3];
extern unsigned int MaxLines;// default maximum lines in editor and memos
extern int MemoIn;
extern int Txtin;
extern int Wrap;
extern int Highestline;

#ifdef NET
extern int SyncAll;   // used by index routines
#endif
extern int Indexing; // TRUE while indexing in progress
extern unsigned int LockUnlockReason;
extern BOOL MultiUser;
extern int  Selected; // internally 0...34,  for the user 1..35

extern unsigned char NumberOfParallelPorts;
extern unsigned char NumberOfSerialPorts;
extern unsigned char NumberOfFloppyDrives;
extern unsigned int  TotalMemory;
extern char _tzfar SDosVersion[8];   // xxx.xxx

extern char  ** Linebuffer;

#ifndef WINDOWS
extern void  (*PollRoutine)(void);
extern unsigned char CalculatorState; // must be a public var for the help
                                      // system, but not necessary to be
                                      // in the .H file
extern BOOL  EditorPresent; // TRUE if EDIT linked in
extern BOOL  HelpEnabled;
extern BOOL  EscapeEnabled;
extern unsigned char ScoreRow;

extern int  CaseSensitivePassword;
extern char LastKey; // Contains an interpreted version of the Last Key
                     // read, so the arrow keys can be retuned in 1 char.
                     // LastKey is only set by ReadGets,Browse,Edit,EditRecord
extern char NextKey;
extern int  Show;
extern int  Repaint;
extern unsigned char NextScanCode;
extern unsigned char ShadowColor;  // DarkGray
extern unsigned char SelectedColor;

// for Topaz internal use only:
extern void (*SGIncWhich)(void);
extern void (*SGDecWhich)(void);

extern long int *BiosTimerTicks;  // defined in tzexit.c
extern unsigned int BaseOfScreen; // Base address of video memory
extern int WaitForRetrace; // Prevent snow with color graphics adapters (CGA)

extern unsigned char WindowDepth;
extern unsigned char WindowWidth;
extern int  EditorResult;
extern BOOL TalkEnabled;
extern BOOL Odometer;
extern BOOL ConsoleOn;
extern BOOL Hunt;
extern BOOL WaitOnError;
extern void (*ProgressPtr)(void);

extern VectorTableType VectorTable[10];
extern unsigned char LastKeyStroke;// Contains the last user keystroke read by TZCommon.ReadKey

//  help system variables
extern ActivityType  Activity;    // normally set by Topaz
extern unsigned char SubActivity; // user-defined subactivity
extern unsigned int  ContextNo;
extern char  _tzfar ContextID[19]; // user help context, as a string
extern char  HelpContextHotKey;   // F1
extern char  HelpAuthoringHotKey; // Shift-F1
extern char  HelpTopicHotKey;     // Ctrl-F1
#endif

// external functions declaration

#ifdef WINDOWS
#define SetConsoleOn()
#define SetConsoleOff()
#else
#define SetConsoleOn()  (ConsoleOn = TRUE)
#define SetConsoleOff() (ConsoleOn = FALSE)        //  default
#endif

char *AddExt(const char * Filename, const char * DefaultExt);
BOOL  CheckRegisteredUnits(const char *funcname, long flagswanted);
char *DefaultCentury(const char *);
unsigned int DosCountryCode(void);
int   DosVersion(void);
BOOL  FileExists(const char *pathname);// allows wildcard chars, i.e. *.*
void  FSplit(const char * fname, char * dir, char * name, char * ext);
void  FreePtrClear(void **ptr);
void  GetCountry(void);
void  GetMachineInfo(void);
char *Ltrim(const char *);
char *Message(void);
void  OnErrorHalt(void);
char *Pad(const char * x, int width); // defined in sayget
char *RemoveExt(const char * Filename);
char *ReplaceExt(const char * Filename, const char * NewExt);
void  SetError(int error, int number_of_strings, ...);
void  SetErrorHandlerTo(void (*)(void));
void  SetPrinterReadyTo(int (_far *)(void));
unsigned ThisCentury(const char *);
char *Trim(const char *);

#ifndef WINDOWS
// functions in FASTWR.ASM
void cdecl _far FastWrite(char _far *St, int Row, int Col, int Attr);
void cdecl _far FastWriteNA(char _far *St, int Row, int Col);
void cdecl _far ChangeAttribute(int Number, int Row, int Col, int Attr);
void cdecl _far MoveScreenData(void _far *src, void _far *dst, int Len);
BOOL cdecl _far EgaInstalled(void);
int  cdecl _far CurrentVideoMode(void);
void cdecl _far PutFont(void _far *FontPtr, unsigned StartingChar, 
                        unsigned Count, BOOL Primary);

void  TZVideoInit(void);
void  Convert(int * col, int * row);
BOOL  KeyPressed(void);
void  MakeArrow(unsigned char i);
unsigned char MaxAvailRows(void);
unsigned char ReadKey(void);
void  SetPollTo(void (*p)(void));
void  SetPasswordTo(const char * password, BOOL CaseSensitive);
void  TzCommonExitProc(void);
//  Routines to manage the timer interrupt, used by Spooler and Clock
unsigned char AddISRVector(void (interrupt _far *)());
void  (interrupt _far * ChainISRAddress(unsigned char MyHandle))();
void  RemoveISRVector(unsigned char);
void  SuspendISRs(void);
void  ResumeISRs(void);
#else
char *FExpand(const char *fname);
char *FSearch(char *Path, char *DirList);
void  FindFirst(char * filename, unsigned int attr, char * s);
int   WDialogBox(const char *, const char *, unsigned int);
#endif

#ifdef __cplusplus
}
#endif

#include <mouse.h> // mouse related variables and functions

#endif // TZTopaz
