/* filename: CALC.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZCALC
#define _TZCALC
#define TZCALC
#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifndef TZCOMMON
#include <common.h>
#endif

#ifndef TZVIDPOP
#include <vidpop.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define NormalText  1
#define CalcFrame   2
#define CalcDisplay 3
#define TriggerKeys 4

#define ON             TRUE
#define OFF            FALSE
#define NormalState    1
#define MoveState      2
#define OverflowState  3
#define ImportState    4
#define MemoryState    5

#define ClearAllTarget   -11
#define ClearEntryTarget -12
#define BackSpaceTarget  -13
#define SevenDigitTarget -7
#define EightDigitTarget -8
#define NineDigitTarget  -9
#define DivisionTarget   -14
#define ChangeSignTarget -15
#define ImportTarget     -16
#define FourDigitTarget  -4
#define FiveDigitTarget  -5
#define SixDigitTarget   -6
#define MultiplyTarget   -17
#define EnterTarget      -18
#define EscapeTarget     -19
#define OneDigitTarget   -1
#define TwoDigitTarget   -2
#define ThreeDigitTarget -3
#define MinusTarget      -20
#define ScrollLockTarget -21
#define ZeroDigitTarget  -22
#define DotTarget        -23
#define EqualTarget      -24
#define PlusTarget       -25
#define MemPlusTarget    -26
#define MemMinusTarget   -27
#define MemTimesTarget   -28
#define MemDivideTarget  -29
#define MemRecallTarget  -30
#define MemClearTarget   -31
#define MoveCalcTarget   -32
#define FullScreenTarget -100

typedef enum { NoKey,UpperArrow,DnArrow,LtArrow,RtArrow,Esc,CalcEnter } MoveKeys;

typedef enum {
  NoCmd, AddCmd, SubtractCmd, MultiplyCmd, DivideCmd, MemoryCmd, RecallCmd,
  ClearCmd, ClearEntryCmd, ChangeSignCmd, ImportCmd, EqualsCmd, EnterCmd,
  BackSpaceCmd, DecimalCmd, DigitCmd, AbandonCmd, QuitCmd, MoveCmd
} CommandKeys;

typedef char Scrtype[66][80][2];   //  support up to 66 line screens

typedef struct CalcColorScheme {
  unsigned char TextFG, TextBG, FrameFG, FrameBG, lcdFG, lcdBG,
  TrigKeyFG, TrigKeyBG;
} CalcColorScheme;

typedef struct UC {
  unsigned char FG, BG, GFG, GBG;
} UC;
extern UC UCM;

extern ActivityType SaveActivity;   // must be a public var for the help system
extern CalcColorScheme CalcColors;
extern int  CalcX1, CalcY1, CalcX2, CalcY2, DispRow, DispCol, CalcShade;
extern unsigned char CalcLineStyle, TapeWidth, Calc_X, Calc_Y;
extern unsigned char SaveNumLocks, RowsSaved;
extern unsigned char far *KeyboardFlags;
extern int SaveDBaseOrder, CalcScreenSaved, DestX, DestY, SaveAutoMousePlacement;
extern Scrtype *CalcScreen;   //  pointer to video card buffer
extern Scrtype *CalcBufPtr;   //  pointer to saved screen
extern char _tzfar CalcHeading[29], CalcDigit, _tzfar SeedValue[23];
extern char _tzfar Accumulator[23], _tzfar Register[23], _tzfar Memory[23], _tzfar CalcResult[23];
extern int CalcDone, calcrestorecursor, ClearRegisterOnDigit, UpdateOperationFlag;
extern CommandKeys LastOperation;
extern int DoubleEnter, Calclen, _dec;
extern char (*UsersTapeProc)(char *);

#ifdef _MSC_VER
extern struct _rccoord tp;
#else
extern unsigned char CalcSaveX, CalcSaveY;
#endif

void  TZCalcInit(void);
char *Calculator(char *CalcSeed, unsigned char len, unsigned char _dec);
void  SetCalcColorTo(unsigned char Feature, unsigned char Fg,
unsigned char Bg);
void  SetCalcWindowTo(unsigned char Col, unsigned char Row,
unsigned char LineStyle, char *Heading);
void  SaveCalcConfig(char *Filename);
void  RestoreCalcConfig(char *Filename);

void  DisplayCalculator(int FirstTime);
void  BuildMouseTargetList(void);
void  CalcTurnNumLock(int SetOn);
void  CalcTurnScrollLock(int SetOn);
int   CalcScrollLock(void);
char *CopyCharNull(char *s, int num);
void  InsertFirst(char *dest, char ch);
void  InsertLast(char *dest, char ch);
void  CalcScroll( char *s);
MoveKeys Calc_k(void);
MoveKeys MoveCalc_k(char *s);
void  MoveCalculator(void);
char *OpSymbol(CommandKeys op);
char *FormatDisplay(char *s, int FullDecimals);
void  UpdateTape(void);
void  DisplayAllRegisters(void);
void  OverFlow(void);
void  ChangeSign(void);
void  ClearCalculator(void);
void  Operation(char *r, char *a, CommandKeys op);
char *CalcAfter(char SubStr, char *s);
void  ClearRegister(void);
void  AppendDigit(void);
void  AppendDecimal(void);
CommandKeys CalcGetKey(void);
void  CalcProcessMemory(CommandKeys *_k);
void  FourFunction(CommandKeys key);
void  RestScreen(int KeepBuf);
void  InitializeCalculator(void);
char *ImportedNumber(void);
char *ImportRegister(void);
void  CalcProcessKey(CommandKeys key);

#ifdef __cplusplus
}
#endif

#endif
