/* filename: BROWSE.H

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef _TZBROWSE
#define _TZBROWSE
#define TZBROWSE

#ifndef TZCOMMON
#include <common.h>
#endif

#ifndef TZVIDPOP
#include <vidpop.h>
#endif

#ifndef TZSAYGET
#include <sayget.h>
#endif

#ifndef TZDBF
#include <dbf.h>
#endif

#ifdef TOPAZINI
#error You should put init.h as the last header file in your MAIN file.
#endif

#ifdef _MSC_VER
#ifndef _GWINDOW
#include <graph.h>
#endif
#define window(x1,y1,x2,y2)    _settextwindow((short)y1, (short)x1, (short)y2, (short)x2)
#define clrscr()               _clearscreen(_GWINDOW)
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define MaxRowsSupported         66 // Video-7 VGA supports 60 rows and
									// Genius full page monitor supports 66 lines
#define MaxRowsSupportedPlusOne  67 // for turbo 4.0 compatiblity

#define bUpArrow      'H'
#define bDnArrow      'P'
#define bLtArrow      'K'
#define bRtArrow      'M'
#define bCtrlLtArrow  's'
#define bCtrlRtArrow  't'
#define bCtrlHome     'w'
#define bCtrlEnd      'u'
#define bPgUp         'I'
#define bPgDn         'Q'
#define bHome         'G'
#define b_End         'O'
#define bESC          '\x1B'
#define bPseudoF2     '\xBC'    // causes edit without @K picture clause
#define bToggleDeleteKey  '\x15'
#define bGotoCell         '\xFD' 
#define bGotoCellThenEdit '\xFE' 
#define ExceptionUsed     1

#define ClearBrowseExitKeys()  *BrowseExitKeys = 0

typedef struct BrowseColorsRecord {
  unsigned char F;   // foreground; these 2 are actually handled by SET_COLOR_TO
  unsigned char B;   // background
  unsigned char HF;  // hilite foreground
  unsigned char HB;  // hilite background
  unsigned char DF;  // deleted foreground
  unsigned char DB;  // deleted background
  unsigned char DHF; // deleted hilite foreground
  unsigned char DHB; // deleted hilite background
  unsigned char SF;  // status line foreground
  unsigned char SB;  // status line background
} BrowseColorsRecord;

typedef struct TagSwitchType {
  int NoModify;
  int NoPack;
  int NoDelete;
  int NoFollow;
  int NoMenu;
  int NoStatus;
  int Command;
  int Freeze;
  int NoPrompt;
  int NoFunctionKeys;
  int NoAppend;
} TagSwitchType;

typedef struct FieldAliasType {
  void *NextAlias;
  unsigned char ColumnNumber;
  unsigned char AreaNumber;
  unsigned char fieldnumber;
  char FieldName[STRSIZ];
} FieldAliasType;

typedef struct BrowseBoxType {
  unsigned char c1, r1, c2, r2;
  unsigned char LineStyle;
  char Header[81];
} BrowseBoxType;

typedef struct MenuListType {
  char MenuItem[11];
  unsigned char Index;
} MenuListType;

typedef MenuListType MenuListArray[11];   //  for moving bar menu

typedef enum { JTop,JBottom,JLeft,JRight } OrientationType;
typedef enum { OneField,ScreensWorth,SuperPan } DistanceType;

extern int BrowseCursorOn;

extern char BrowseFieldSeparator[2];
extern char BrowseVerticalChar[2];
extern unsigned char BrowseVerticalColor;
extern char _tzfar BrowseExitKeys[40];
extern int ExitBrowse;
extern void *SavePublicVars;
extern char BrowseMenuKey;

#ifdef NET
void AnnounceLockFailure(char *x);
#endif

unsigned char BackGroundColorAtCursor(void);
unsigned char BrowseCol(void);
unsigned char BrowseField(void);
unsigned char BrowseLevel(int Change);
unsigned int  FieldFromCol(unsigned char col);

char *SetToString(void *x);
char *Shorten(char *s, unsigned char width);
char *VirtualData(int i);
char *_Field(int i);
BOOL AddBrowseExitKey(char key);
void AddMenuItem(char *ItemName, unsigned char index);
void AppendRecord(void);
void Browse(char *Cmd);
BOOL BrowseEdit(void);
void BrowseGetKey(void);
BOOL BrowseIsActive(void);
int  BrowseRow(void);
void ClearBrowseArea(void);
int  DataWidth(int j);
int  DisplayBarMenu(void);
void DisplayBlankData(void);
void DisplayHeadings(void);
void DisplayRecordData(void);
void DisplayRecordNumber(void);
void DoUsersCalculations(void);
void DrawVerticalBars(void);
void EditCell(void);
void FindRecord(void);
void FlushKeyboard(void);
void FollowEditedRecord(void);
void GetCellColors(void);
void GetColumns(void);
void GetNewCommandLine(char *Command);
void GoToBottom(void);
void GoToRecord(void);
void GoToTop(void);
void HandleDisplayAfterDelete(void);
void HandleDnArrow(void);
void HandleScrollDown(void);
void HandleScrollUp(void);
void HandleUpArrow(void);
void InitializeBrowse(char *Command);
void JoinLines(unsigned char row, unsigned char col, unsigned char HLineStyle, unsigned char VLineStyle, OrientationType Orientation);
void LocateString(void);
int  Offset(void);
void PackDataBase(void);
void PaintCell(void);
void PaintScreen(void);
void PaintScreenAfterDelete(void);
void PaintScreenWithoutChangingRow(void);
void PanLeft(DistanceType Distance);
void PanPaintScreen(void);
void PanRight(DistanceType Distance);
void ParseCommand(char *CommandStr);
void PopBrowse(void);
void PushBrowse(void);
long RecordFromRow(unsigned char row);
void RedefineLRecNo(void);
void ReleaseAliasMemory(void);
BOOL RemoveBrowseExitKey(char key);
void ResetFirstField(int fieldnumber);
void RestoreVideoLine(void);
void SaveVideoLine(void);
void SayNotPermitted(char *x);
void ScrollDown(void);
void ScrollUp(void);
void SetBrowseAttrTo(void (*AttrProc)(void));
void SetBrowseCalcTo(void (*CalcProcPtr)(void));
void SetBrowseColorTo(unsigned char Dsf, unsigned char Dsb, unsigned char Dgf, unsigned char Dgb, unsigned char STf, unsigned char STb);
void SetBrowseCursorOff(void);
void SetBrowseCursorOn(void);
void SetBrowseWindowTo(int lc, int tr, int rc, int br, int _LineStyle, char * _Header);
void SetEditDirectionTo(char Direction);
void TZBrowseInit(void);
void ToggleDelete(void);
void UnPaintCell(void);
void UpdateBrowseRow(void);
void UpdateBrowseScreen(void);
void UpdateUserRec(int i, char *data);
BOOL WaitBTT(BOOL up);

#ifdef __cplusplus
}
#endif

#endif
