; >>> DOS Executive Window  Copyright (c) 1993 SSI\Russia <<<
;
; >>> Open DOS window
; -------------------
; C prototype:
; int _cdecl _far OpenDOSWindow(char x1, char y1, char x2, char y2, char attr);
;
; input values:
; x1, y1, x2, y2 - 1-base screen coordinates
; attrib         - attribute for window text
;
; return value:
;  0 - Ok
; -1 - error in coordinates value or DOS window already open
;
; >>> Close DOS window
; --------------------
; C prototype:
; void _cdecl _far CloseDOSWindow(void);
;
          .MODEL LARGE, C
          .CODE
          PUBLIC  OpenDOSWindow, CloseDOSWindow
;+++++++++++++++++++++++
X   EQU byte ptr 0
Y   EQU byte ptr 1
;+++++++++++++++++++++++
.PushR  macro regs
         irp  r, <regs>
          push r
         endm
        endm

.PopR   macro regs
         irp  r, <regs>
          pop r
         endm
        endm

.SetVect macro intr, entry
          mov  ax, seg entry
          mov  ds, ax
          mov  dx, offset entry
          mov  ah, 25h
          mov  al, intr
          int  21h
         endm

.GetVect macro intr, memory
          mov  ah, 35h
          mov  al, intr
          int  21h
          mov word ptr memory + 0, bx
          mov word ptr memory + 2, es
         endm

.RestoreVect macro intr, memory
          mov  ax, word ptr memory + 2
          mov  ds, ax
          mov  dx, word ptr memory
          mov  ah, 25h
          mov  al, intr
          int  21h
         endm

.SetupCursorPosition macro x, y, vpage
          ifnb <x>
            mov dl, x
          endif
          ifnb <y>
            mov dh, y
          endif
          ifnb <vpage>
            mov bh, vpage
          endif
          mov  ah, 02h
          int  10h
         endm
;+++++++++++++++++++++++
@@Position         dw   0
@@WindowLoXY       dw   0
@@WindowHiXY       dw   0
@@Attribute        db   0
@@Int29OldEntry    dd   0
@@Active           db   0
;+++++++++++++++++++++++
Int29Entry proc far
    .PushR <bx, cx, dx, ds, bp>

    cmp     al, 07h                 
    jz      MakeBell                

    mov     dx, @@Position          

    cmp     al, 08h                 
    jz      WriteBackSpace
    cmp     al, 09h                 
    jz      WriteTab
    cmp     al, 0Ah                 
    jz      WriteLF
    cmp     al, 0Dh                 
    jz      WriteCR

    call    ShowChar                

SetCorsorPosition:                  
     .SetupCursorPosition ,, 0      
     mov     @@Position, dx         

ExitInt29:
    .PopR   <bp, ds, dx, cx, bx>
    iret

MakeBell:
    mov     ah, 0Eh
    mov     bx, 07h
    int     10h
    jmp     ExitInt29

WriteCR:
    mov     dl, @@WindowLoXY.X      
    jmp     SetCorsorPosition

WriteLF:
    cmp     dh, @@WindowHiXY.Y      
    jb      @@1
    mov     ax, 0601h               
    mov     cx, @@WindowLoXY
    mov     dx, @@WindowHiXY
    mov     bh, @@Attribute
    int     10h
    jmp     ExitInt29
@@1:
    inc     dh                      
    jmp     SetCorsorPosition       
WriteTab:
    mov     cl, dl
    sub     cl, @@WindowLoXY.X      
    add     cl, 08h
    and     cl, 0F8h                
    add     cl, @@WindowLoXY.X      
    sub     cl, dl                  
    xor     ch, ch                  
@@2:
    mov     al, 20h                 
    push    cx
    call    ShowChar                
    .SetupCursorPosition ,, 0
    mov     @@Position, dx          
    pop     cx
    loop    @@2                     
    jmp     ExitInt29

WriteBackSpace:
    cmp     dl, @@WindowLoXY.X      
    jbe     ExitInt29               
    dec     dl                      
    .SetupCursorPosition ,, 0
    mov     @@Position, dx
    mov     cx, 1                   
    mov     bl, @@Attribute
    mov     ax, 0920h               
    int     10h
    jmp     ExitInt29               

Int29Entry endp
;+++++++++++++++++++++++
ShowChar proc near
    mov     cx, 1                   
    mov     bl, @@Attribute
    xor     bh, bh
    mov     ah, 09h
    int     10h

    cmp     dl, @@WindowHiXY.X      
    jb      IncCol                  
    cmp     dh, @@WindowHiXY.Y      
    jb      IncRow                  

    mov     ax, 0601h               
    mov     cx, @@WindowLoXY
    mov     dx, @@WindowHiXY
    mov     bh, @@Attribute
    int     10h
    dec     dh                      
IncRow:
    inc     dh                      
    mov     dl, @@WindowLoXY.X      
    dec     dl                      
IncCol:
    inc     dl                      
    ret
ShowChar endp
;+++++++++++++++++++++++
OpenDOSWindow proc far
X1   equ    byte ptr [bp+06h]
Y1   equ    byte ptr [bp+08h]
X2   equ    byte ptr [bp+0Ah]
Y2   equ    byte ptr [bp+0Ch]
ATTR equ    byte ptr [bp+0Eh]

    push    bp
    mov     bp, sp
    .PushR  <bx, cx, dx, ds, es>    

    mov     ax, -1

    cmp     @@Active, 1             
    je      OpenFailed              

    mov     dl, [ATTR]
    mov     @@Attribute, dl         

    mov     dl, [X1]                
    mov     dh, [Y1]
    mov     cl, [X2]
    mov     ch, [Y2]

    or      dl, dl                  
    jz      OpenFailed              
    or      dh, dh                  
    jz      OpenFailed              
    cmp     dl, cl                  
    ja      OpenFailed              
    cmp     dh, ch                  
    ja      OpenFailed              

    dec     dl                      
    dec     dh                      
    dec     cl                      
    dec     ch                      

    mov     @@WindowLoXY, dx
    mov     @@WindowHiXY, cx

    mov     ah, 0fH                 
    int     10h
    .SetupCursorPosition            
    mov     @@Position, dx          
    cli
    .GetVect 29h, @@Int29OldEntry   
    .SetVect 29h, Int29Entry        
    sti

    mov     @@Active, 1             
    xor     ax, ax                  

OpenFailed:
    .PopR   <es, ds, dx, cx, bx>    
    pop     bp
    ret                             
OpenDOSWindow endp
;+++++++++++++++++++++++
CloseDOSWindow proc far
    .PushR  <dx, ds>

    cmp     @@Active, 0             
    je      QuitClose               

    cli
    .RestoreVect 29h, @@Int29OldEntry
    sti

    mov    @@Active, 0

QuitClose:
    .PopR  <ds, dx>
    ret
CloseDOSWindow endp

    end
