#define  CREATE
#include <stdio.h>
#include "install.h"
#include "init.h"

struct dbfRecord database;
struct FieldRecord structure[6] = {
		{ "SECTION",  'C', 15, 0, 0 },
		{ "SUBDIR",   'C', 40, 0, 0 },
		{ "SIZE",     'N',  8, 0, 0 },
		{ "DISKNO",   'N',  2, 0, 0 },
		{ "ARCNAME",  'C', 12, 0, 0 }
};

InstDBFrecord  far record_list[] = {
	{ 0, "",         "Borland C++ 3.x library names", 0, 0, "" },
	{ 0, LIBRARY_BM, "MULIB",              833747L,  2, "TOPAZBMU.ZIP" },
	{ 0, LIBRARY_BS, "SULIB",              700000L,  2, "TOPAZBSU.ZIP" },

	{ 0, "",         "Microsoft C/C++ 7.00 library names", 0, 0, "" },
	{ 0, LIBRARY_MM, "MULIB",               900000L,  3, "TOPAZMMU.ZIP" },
	{ 0, LIBRARY_MS, "SULIB",               800000L,  3, "TOPAZMSU.ZIP" },

	{ 0, "",         "Compiler-independent options", 0, 0, ""          },
	{ 0, ALWAYS,     "INCLUDE",            220413L,  1, "INCLUDE.ZIP"  },
	{ 0, UTILITIES,  "UTIL",               250000L,  4, "UTIL.ZIP"     },
	{ 0, MAKECODE,   "MAKECODE",            89387L,  4, "MAKECODE.ZIP" },
	{ 0, MAKECODE,   "MAKECODE\\TEMPLATE",  39672L,  4, "TEMPLATE.ZIP" },
	{ 0, EXAMPLES,   "EXAMPLES",            50000L,  4, "EXAMPLES.ZIP" },
	{ 0, DOCUMENT,   ".",                   70000L,  5, "DOC.ZIP"      },
	{ 0, SOURCE,     "SOURCE\\BROWSE",     160582L,  5, "BROWSE.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\CALC",        35771L,  5, "CALC.ZIP"     },
	{ 0, SOURCE,     "SOURCE\\CLOCK",       11839L,  5, "CLOCK.ZIP"    },
	{ 0, SOURCE,     "SOURCE\\COMMON",      92940L,  5, "COMMON.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\DBF",        211084L,  5, "DBF.ZIP"      },
	{ 0, SOURCE,     "SOURCE\\DBFEDIT",     21905L,  5, "DBFEDIT.ZIP"  },
	{ 0, SOURCE,     "SOURCE\\DIALOG",      71744L,  5, "DIALOG.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\EDIT",       240566L,  5, "EDIT.ZIP"     },
	{ 0, SOURCE,     "SOURCE\\HELP",        25701L,  5, "HELP.ZIP"     },
	{ 0, SOURCE,     "SOURCE\\INDEX",      175576L,  5, "INDEX.ZIP"    },
	{ 0, SOURCE,     "SOURCE\\MEMO",        88356L,  5, "MEMO.ZIP"     },
	{ 0, SOURCE,     "SOURCE\\PICK",        83758L,  5, "PICK.ZIP"     },
	{ 0, SOURCE, 	 "SOURCE\\PRINTCOM",    876876L, 5, "PRINTCOM.ZIP" },
	{ 0, SOURCE,     "SOURCE\\TZPRINT",     43085L,  5, "TZPRINT.ZIP"  },
	{ 0, SOURCE,     "SOURCE\\REPORT",      69169L,  5, "REPORT.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\SAVER",       25567L,  5, "SAVER.ZIP"    },
	{ 0, SOURCE,     "SOURCE\\SAYGET",     151734L,  5, "SAYGET.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\SCRNEDIT",    49924L,  5, "SCRNEDIT.ZIP" },
	{ 0, SOURCE,     "SOURCE\\SPOOLER",     31553L,  5, "SPOOLER.ZIP"  },
	{ 0, SOURCE,     "SOURCE\\TIMEDATE",    86431L,  5, "TIMEDATE.ZIP" },
	{ 0, SOURCE,     "SOURCE\\UTILS",       45767L,  5, "UTILS.ZIP"    },
	{ 0, SOURCE,     "SOURCE\\VFILES",     118253L,  5, "VFILES.ZIP"   },
	{ 0, SOURCE,     "SOURCE\\VIDPOP",     114465L,  5, "VIDPOP.ZIP"   },
	{ 0, SOURCE,     "SOURCE",              26953L,  5, "BUILD.ZIP"    },

	{ 0, "",         "Archive driver command line",  0, 0, ""          },
	{ 0, ARC_DRV,    "PKUNZIP.EXE -d -o",  0,        0, ""             },
	{ 0, "", "", 0, 0, "" }  // this line is a terminating one !!!
};

InstDBFrecord  db;
char name[30];

extern unsigned _stklen = 10000;

void nf(int i)
{
	InstDBFrecord  *rec = &record_list[i];

	memset(&db, 0, sizeof(InstDBFrecord));

	strcpy(db._SECTION, rec->_SECTION);
	strcpy(db._SUBDIR,  rec->_SUBDIR);
	db._SIZE   = 		rec->_SIZE;
	db._DISKNO = 		rec->_DISKNO;
	strcpy(db._ARCNAME, rec->_ARCNAME);

	Append();
}

void main(void)
{
	int i;

	InitTopaz();

	CreateDbf(&database, DBFNAME, 5, structure); // DBFNAME is #define'd
	sprintf(name, "%s EXCLUSIVE", DBFNAME);      // in INSTALL.H
	Use(name, &db, sizeof(InstDBFrecord));

	for (i=0; (*record_list[i]._SECTION || *record_list[i]._SUBDIR) != 0; i++)
		nf(i);

	CloseDatabases();
}
