;
;                     MEMBLOCK Init for Memory Allocation
;
;
; Borland C++ 4.0 for WIN32 prototype:
; int   __pascal mbinit (MEMBLOCK *mb);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBINIT, MBheadersize


;
Segment _DATA dword public use32 'DATA'

MBheadersize        dd MBSigSize + (size MemNode)

EndS    _DATA


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 0                ; -> MEMBLOCK

MBINIT:         push ebx
pct = (4)+(1*4)         ; # bytes pushed on stack after last argument

                ;-- Get memblock info
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [eax+MEMBLOCK.base]
                mov  ecx, [eax+MEMBLOCK.size]

                ;-- Align MEMBLOCK base
IN_AlignBase:   test bl, 03h
                jz   IN_AlignSize
                inc  ebx
                dec  ecx
                jmp  short IN_AlignBase

                ;-- Align MEMBLOCK size
IN_AlignSize:   and  cl, NOT(03h)

IN_CheckSize:   ;-- Is size too big or small??
                cmp  ecx, 0ch                   ; high bit is needed for node
                jle  IN_BadMBSize               ; availability flag
                ; 12 < ecx < 2^31

                ;-- Writeback base and size of MEMBLOCK
                mov  [eax+MEMBLOCK.base], ebx
                mov  [eax+MEMBLOCK.size], ecx

                ;-- Convert linear base adx to relative
                sub  ebx, [_database]

If DebugMode    ;-- Write memory block signature
                mov  [dword ebx], MBSig
                add  ebx, MBSigSize             ; -> first node
EndIf

                ;-- Write first node
                sub  ecx, (MBSigSize + size MemNode)    ; size of 1st mem area
                mov  [ebx+MemNode.size], ecx
If DebugMode
                xor  ecx, NodeSigKey
                mov  [ebx+MemNode.sig], ecx
EndIf

                ;-- Init ok
                mov  eax, 1
IN_Exit:        pop  ebx
                ret  4

IN_BadMBSize:   xor  eax, eax
                jmp  short IN_Exit


;
EndS            _TEXT
End
