/****************************************************************************/
/*                                                                          */
/*    PROGRAM NAME: SHAREDEL                                                */
/*    -------------                                                         */
/*    OS/2 Lan Server 3.0  API sample program.                              */
/*    @Copyright International Business Machines Corp. 1984, 1992           */
/*    @Copyright Microsoft Corp. 1984, 1991                                 */
/*                                                                          */
/*    What this program does:                                               */
/*                It takes command line information on a device and         */
/*            (optionally) a Netname. It checks that the device is shared   */
/*            and returns basic information on the device type.             */
/*            The user may stop sharing for a particular Netname            */
/*            associated with that device.                                  */
/*                                                                          */
/*    REQUIRED FILES:                                                       */
/*    ---------------                                                       */
/*    SHAREDEL.MAK    - NMake File, to compile and link the program using   */
/*                      IBM C-set/2                                         */
/*    SHAREDEL.C      - C source code for the main program.                 */
/*    ERRMSG.C        - C source code for the Error_Message function.       */
/*                                                                          */
/*    REQUIRED LIBRARIES:                                                   */
/*    -------------------                                                   */
/*    NETAPI.LIB     -  Netapi library for OS/2.                            */
/*                                                                          */
/*    NetAPI functions used in this program:                                */
/*    -------------------------------                                       */
/*    NetShareDel                                                           */
/*    NetShareCheck                                                         */
/*                                                                          */
/****************************************************************************/

/*------------------ OS/2 Include definitions ------------------------------*/
#define  INCL_BASE
#include <os2.h>

/*----------------- LAN Server API Include definitions ---------------------*/
#define  INCL_32                        /* use 32bit includes */
#include <lanserv\netcons.h>
#include <lanserv\shares.h>
#include <lanserv\access.h>
#include <lanserv\neterr.h>

/*--------------------- C Include definitions ------------------------------*/
#include <stdlib.h>
#include <stdio.h>

/*--------------------- Function Declarations ------------------------------*/

VOID Error_Message( USHORT, PSZ );


/****************************************************************************/
/* Main C Function                                                          */
/*--------------------------------------------------------------------------*/

VOID main(argc, argv)
SHORT argc;
PCHAR argv[];
{
  CHAR               chStop_Sharing[4]   ;   /* Input string                */
  PCHAR              pchServername = NULL;   /* Server machine name.        */
  PCHAR              pchDevname    = NULL;   /* Shared device name.         */
  PCHAR              pchNetname    = NULL;   /* Shared resource netname.    */
  USHORT             usReserved       = 0;   /* Reserved field - must be 0  */
  USHORT             usRc             = 0;   /* Return code                 */
  USHORT             usType              ;   /* Type of Resource            */

  /* Assign the input arguments to the appropriate variables.               */

  switch ( argc ) {

  case 2 :
        pchDevname = argv[1];
     break;
  case 3 :
     if ( *argv[1] == '\\'){
        pchServername = argv[1];
        pchDevname    = argv[2];
     }
     else {
        pchDevname = argv[1];
        pchNetname = argv[2];
     } /* endif */
     break;
  case 4 :
     if ( *argv[1] == '\\' || * argv[1] == 'N')
        pchServername = argv[1];
     else {
           usRc = 1;
           printf("Invalid Servername format. \n");
     } /* endif */
     pchDevname = argv[2];
     pchNetname = argv[3];
     break;
  default :
           usRc = 1;
           printf(" Incorrect number of arguments.\n");
     break;
  } /* endswitch */

  /* If the input parameters are invalid, give instructions and exit.       */

  if ( usRc != 0) {
     printf(" \n");
     printf(" Remote server usage :\n");
     printf("    %s <servername> <Devicename> <Netname> \n",argv[0]);
     printf(" OR %s <servername> <Devicename> \n",argv[0]);
     printf(" Local server usage :\n");
     printf("    %s <Devicename> <Netname>\n",argv[0]);
     printf(" OR %s <Devicename> \n\n",argv[0]);

     printf(" Servername : \\\\<server machinename>\n");
     printf(" Devicename : <devicename> (i.e. C: OR LPT1:) \n");
     printf(" Netname    : <Alias name or Netname> \n");

     DosExit(EXIT_PROCESS, usRc);
  } /* endif */


  usRc = NetShareCheck( pchServername,   /* Verify that the device exists   */
                        pchDevname,      /* and that it is shared.          */
                       &usType);

  Error_Message(usRc,"NetShareCheck");   /* If necessary, send an error msg */

  printf("The shared device %s is",pchDevname);

  switch ( usType ) {                    /* Print out the device type       */
  case STYPE_DISKTREE :
     printf(" a disk drive.\n");
     break;
  case STYPE_PRINTQ :
     printf(" a printer spooler queue.\n");
     break;
  case STYPE_DEVICE :
     printf(" a serial device.\n");
     break;
  case STYPE_IPC    :
     printf(" an Interprocess Communication Device.\n");
     break;
  default:
     printf(" of unknown type.\n");
     break;
  } /* endswitch */

  /* Stop sharing if the user has specified a Netname                       */

  if (pchNetname != NULL) {
     printf("Stop sharing %s on device %s (Y/N)?", pchNetname, pchDevname);
     scanf("%s",chStop_Sharing);

     if (*chStop_Sharing == 'y' || *chStop_Sharing == 'Y') {
        usRc = NetShareDel( pchServername,
                            pchNetname,
                            usReserved);

        Error_Message(usRc, "NetShareDel");
        printf("Sharing of %s has been stopped.\n", pchNetname);
        }
     else
        printf("Sharing has not been stopped.\n");
  } /* endif */

} /* end main */

