/****************************************************************************/
/*                                                                          */
/*    PROGRAM NAME: ACCADD                                                  */
/*    -------------                                                         */
/*    OS/2 Lan Server 3.0  API sample program.                              */
/*    @Copyright International Business Machines Corp. 1984, 1992           */
/*    @Copyright Microsoft Corp. 1984, 1991                                 */
/*                                                                          */
/*    What this program does: It   creates an access control profile        */
/*    on the server where it is running. It reads access control            */
/*    definitions from a file named ACC.BIN.                                */
/*                                                                          */
/*    REQUIRED FILES:                                                       */
/*    ---------------                                                       */
/*    ACCADD.C        -  Source code for this program                       */
/*                                                                          */
/*    REQUIRED LIBRARIES:                                                   */
/*    -------------------                                                   */
/*    NETAPI.LIB     -  Netapi library (in \IBMLAN\NETSRC\LIB directory)    */
/*                                                                          */
/*    NetAPI functions used in this program:                                */
/*    -------------------------------                                       */
/*    NetWkstaGetInfo                                                       */
/*    NetAccessAdd                                                          */
/*                                                                          */
/*    HOW TO COMPILE THIS PROGRAM:                                          */
/*    ----------------------------                                          */
/*    cl /AL accadd.c   /link netapi                                        */
/*                                                                          */
/****************************************************************************/

/*------- OS/2 include files -----------------------------------------------*/
#define INCL_BASE
#include <os2.h>

/*------- LAN Systems NET APIs include files -------------------------------*/
#define INCL_32                         /* use for 32bit compiler */
#include <lanserv\neterr.h>
#include <lanserv\netcons.h>
#include <lanserv\access.h>
#include <lanserv\wksta.h>

/*------- C include files --------------------------------------------------*/
#define __TILED__                       /* use tiled (16bit compat) memory */
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#include <memory.h>
#include <string.h>

/*------- Definitions ------------------------------------------------------*/
#define  FILENAME "ACC.BIN"

/*------- Function declaration ---------------------------------------------*/
VOID GetMachineName(PCHAR);
VOID ReadAccessData (PCHAR, USHORT);
VOID DisplayAccessInfo( struct access_info_1 LSFAR *buf);

/****************************************************************************/
/* MAIN C function                                                          */
/*--------------------------------------------------------------------------*/
VOID main(argc, argv)
   int argc;
   char *argv[];
{
   USHORT   usRc=0;
   USHORT   usBuflenAccess = 0;
   USHORT   usTotalAvail   = 0;
   SEL      selector;
   CHAR     Servername[CNLEN+1];
   struct   access_info_1  LSFAR *BufAccess;

   argc;/* do nothing */

   printf("%s reading machine name\n",argv[0]);

   strcpy(Servername,"\\\\");
   GetMachineName( &Servername[2]);

   printf("%s machine name is %s\n",argv[0],Servername);

   /* allocate buffer */

   usBuflenAccess = sizeof(struct access_info_1) + PATHLEN +
                    64 * sizeof(struct access_list);

/*
   DosAllocMem( (PPVOID )&BufAccess, usBuflenAccess, OBJ_TILE|PAG_READ|PAG_WRITE);
*/
   BufAccess = _tmalloc( usBuflenAccess);

   memset( BufAccess,'\x00',usBuflenAccess);

   printf("%s reading file %s\n",argv[0],FILENAME);

   ReadAccessData ((PCHAR) BufAccess, usBuflenAccess);

   /* adjust pointers in access_info structure according to starting
      address of the allocated buffer */

   BufAccess->acc1_resource_name = (PCHAR) (
               (((LONG) BufAccess->acc1_resource_name) & 0x0000FFFF) |
               (((LONG) BufAccess) & 0xFFFF0000) );

/*
   DisplayAccessInfo(BufAccess);
*/

   printf( "%s creating access control\n", argv[0]);

   usRc = NetAccessAdd( Servername,            /* server name */
                        1,                     /* level of detail */
                        (char LSFAR *)BufAccess, /* ptr to access_info structure */
                        usBuflenAccess );      /* size of data structure */

   if (usRc != NERR_Success ) {
      if (usRc == NERR_ResourceExists) {
         printf("Resource %s already has access control profile\n",
                BufAccess->acc1_resource_name);
      } else {
         printf("NetAccessAdd usRc = %d\n",usRc);
      } /* endif */
   } /* endif */

   _tfree( BufAccess);
   printf("%s ending\n",argv[0]);

   exit( usRc);
}


/****************************************************************************/
/*  Function  DisplayAccessInfo                                             */
/*--------------------------------------------------------------------------*/
VOID DisplayAccessInfo (struct access_info_1 *buf)
{
   struct access_list LSFAR *list;
   SHORT  count;

   printf("\n-----------------------");
   printf("\nResource name         : %s ",buf->acc1_resource_name);
   printf("\nAttributes            : %x ",buf->acc1_attr);
   printf("\nCount                 : %d ",buf->acc1_count);

   if (buf->acc1_count) {

      count = buf->acc1_count;
      list =(struct access_list *) (++buf);

      while (count--) {
         printf("\n-----------------------");
         printf("\nUser/Group name       : %s ",list->acl_ugname);
         printf("\nPermissions           : %x ",list->acl_access);
         list++;
      } /* endwhile */

   } /* endif */
}


/****************************************************************************/
/*  Functions declaration                                                   */
/*--------------------------------------------------------------------------*/
VOID GetMachineName(PCHAR pcMname)
{
   USHORT   usRc=0;
   USHORT   usBuflen      = 0;
   USHORT   usTotalAvail;
   SEL      selector;
   struct   wksta_info_10 LSFAR *buf;

   usBuflen=sizeof(struct wksta_info_10)+CNLEN+1+UNLEN+1+2*(DNLEN+1)+4*(DNLEN+1);

/*
** comment out old 16bit version
   DosAllocSeg(usBuflen,&selector,SEG_NONSHARED);
   buf = (struct wksta_info_10 LSFAR *) MAKEP(selector,0);
*/
   buf = _tmalloc( usBuflen);

   memset(buf,'\x00',usBuflen);

   usRc = NetWkstaGetInfo (NULL,           /* server name */
                          10,              /* level of detail */
                          (char LSFAR *)buf, /* ptr to wksta_info
                                              data structure */
                          usBuflen,        /* size of data structure */
                          &usTotalAvail);  /* number of bytes of
                                              information available */
   if (usRc != NERR_Success ) {
      printf("NetWkstaGetInfo usRc = %d\n",usRc);
      _tfree( buf);
      exit( usRc);
   } /* endif */

   strcpy( pcMname, buf->wki10_computername);
   _tfree( buf);
}


/****************************************************************************/
/*  Functions ReadAccessData                                                */
/*            reads access control record from a file                       */
/*--------------------------------------------------------------------------*/
VOID ReadAccessData (PCHAR pchBuff, USHORT usBuflen)
{
   SHORT    sHandle;

   if ( (sHandle = open(FILENAME,O_RDONLY|O_BINARY)) == -1 ) {
      printf("Error opening file %s\n",FILENAME);
      exit(1);
   } /* endif */

   if ( read(sHandle, pchBuff, usBuflen) != usBuflen ) {
      printf("Error reading file %s\n",FILENAME);
      exit(1);
   } /* endif */

   if (close(sHandle) == -1) {
      printf("Error closing file %s\n",FILENAME);
      exit(1);
   } /* endif */
}

