/**************************************************************************/
/*                                                                        */
/*              IBM OS/2(tm) Local Area Network (LAN) Server              */
/*                            Version 3.0                                 */
/* (c) Copyright International Business Machines Corporation, 1988, 1992  */
/*                                                                        */
/**************************************************************************/

/********************************************************************
 *								    *
 *  About this file ...  MAILSLOT.H				    *
 *								    *
 *  This file contains information about the Mailslot APIs.	    *
 *								    *
 *	Function prototypes.					    *
 *								    *
 ********************************************************************/


#ifdef  INCL_32
#pragma pack(1)
#endif


#ifndef NETMAILSLOT_INCLUDED

#define NETMAILSLOT_INCLUDED


/****************************************************************
 *                                                              *
 *               Function prototypes - Mailslot                 *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  DosMakeMailslot ( const char LSFAR * pszName,
                    unsigned short     cbMessageSize,
                    unsigned short     cbMailslotSize,
                    unsigned LSFAR *   phMailslot );

extern API_FUNCTION
  DosPeekMailslot ( unsigned  LSINT        hMailslot,
                    char LSFAR *           pbBuffer,
                    unsigned short LSFAR * pcbReturned,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority );

extern API_FUNCTION
  DosDeleteMailslot ( unsigned LSINT hMailslot );

extern API_FUNCTION
  DosMailslotInfo ( unsigned LSINT         hMailslot,
                    unsigned short LSFAR * pcbMessageSize,
                    unsigned short LSFAR * pcbMailslotSize,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority,
                    unsigned short LSFAR * pcMessages);

extern API_FUNCTION
  DosPeekMailslot ( unsigned  LSINT        hMailslot,
                    char LSFAR *           pbBuffer,
                    unsigned short LSFAR * pcbReturned,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority );

extern API_FUNCTION
  DosReadMailslot ( unsigned  LSINT        hMailslot,
                    char LSFAR *           pbBuffer,
                    unsigned short LSFAR * pcbReturned,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority,
                    long                   cTimeout );

extern API_FUNCTION
  DosWriteMailslot ( const char LSFAR * pszName,
                     const char LSFAR * pbBuffer,
                     unsigned short     cbBuffer,
                     unsigned short     usPriority,
                     unsigned short     usClass,
                     long               cTimeout );


/****************************************************************
 *								*
 *	  	Special values and constants - Mailslot		*
 *								*
 ****************************************************************/

#define MAILSLOT_NO_TIMEOUT	-1

#endif /* NETMAILSLOT_INCLUDED */

#ifdef  INCL_32
#pragma linkage (DosMakeMailslot, far16 pascal)
#pragma linkage (DosPeekMailslot, far16 pascal)
#pragma linkage (DosDeleteMailslot, far16 pascal)
#pragma linkage (DosMailslotInfo, far16 pascal)
#pragma linkage (DosPeekMailslot, far16 pascal)
#pragma linkage (DosReadMailslot, far16 pascal)
#pragma linkage (DosWriteMailslot, far16 pascal)
#pragma pack()
#endif
