/* wcldsi.h  DSI Interface Control Blocks                               */
/************************************************************************/
/* Change Activity:                                                     */
/* @000 P0000000 920521 MJS: Initial code drop                          */
/* @001 P0005448 940201 MJS: Change rc prefix to avoid conflict with    */
/*                           ISDN network specific RCs                  */
/* @A02 P0005722 940223 JIS: Undo the changes made for 5448. Refer to   */
/*                           defect for explanation.                    */
/* @A03 P0005768 940310 MJS: add versioning                             */
/************************************************************************/
#include "wcl1632.h"

extern WORD DSI(void *);

typedef                                 /* msg buffer header used       */
STRUCT16 _START_DIAL                    /* privately by allc/free       */
{
  WORD   request_type;                  /* REQUEST_START_DIAL           */
                                        /* Dial Services ind entry pt   */
  VOID    (*post_addr)();
} START_DIAL;

typedef                                 /* msg buffer header used       */
STRUCT16 _MAKE_CALL                       /* privately by allc/free       */
{
  WORD   request_type;          /* REQUEST_MAKE_CALL                    */
  BYTE   dir_entry[16];         /* outgoing call directory entry        */
  BYTE   protocol_id;           /* requested protocol id                */
  BYTE   reserved1;             /*                                      */
  DWORD  call_identifier;       /* assigned by DSI                      */
  BYTE   dial_out_cp[16];       /* Dial Out CP Name             @001    */
  BYTE   dial_out_mac[12];      /* Dial Out CP Mac address      @001    */
  BYTE   user_id[10];           /* user id for auto logon       @001    */
  BYTE   reserved2[6];          /* for user id growth           @001    */
  BYTE   password[40];          /* Password for auto logon      @001    */
  WORD   number_count;          /* # of overriding numbers              */
  WORD   number_wifs;           /* # of overriding numbers              */
  BYTE   number_array[1];       /* array of phone number strings        */
  BYTE   wif_array[1];          /* array of 6 byte binary addresses     */
} MAKE_CALL;

typedef                                 /* msg buffer header used       */
STRUCT16 _LOCAL_HANGUP                    /* privately by allc/free       */
{
  WORD   request_type;          /* REQUEST_LOCAL_HANGUP                 */
  DWORD  call_identifier;       /* call to be cleared                   */
} LOCAL_HANGUP;

typedef                                 /* msg buffer header used       */
STRUCT16 _START_AUTOANSWER                /* privately by allc/free       */
{
  WORD   request_type;          /* REQUEST_START_AUTOANSWER             */
  BYTE   dir_entry[16];         /* Incoming call directory entry        */
  BYTE   protocol_id;           /* requested protocol id                */
  BYTE   reserved;              /* word boundry                         */
  DWORD  ans_identifier;        /* assigned by DW                       */
  BYTE   answer_cp[16];         /* Name of CP to put in answer  @001    */
  BYTE   answer_mac[12];        /* Dial Out CP Mac address      @001    */
  WORD   display_flag;          /* Notification of session events       */
} START_AUTOANSWER;

typedef                                 /* msg buffer header used       */
STRUCT16 _STOP_AUTOANSWER                 /* privately by allc/free       */
{
  WORD   request_type;          /* REQUEST_STOP_AUTOANSWER              */
  DWORD  ans_identifier;        /* answer id to be stopped              */
} STOP_AUTOANSWER;

typedef                                 /* msg buffer header used       */
STRUCT16 _START_QUERY                     /* privately by allc/free @001  */
{
  WORD   request_type;          /* REQUEST_START_QUERY                  */
  BYTE   query_string[80];      /* string to query for (ie.             */
                                /* \layer\component)                    */
  DWORD  query_id;              /* returned id assigned to this query   */
} START_QUERY;

typedef                                 /* msg buffer header used  @001 */
STRUCT16 _STOP_QUERY                      /* privately by allc/free       */
{
  WORD   request_type;          /* REQUEST_STOP_QUERY                   */
  DWORD  query_id;              /* id of query to stop                  */
} STOP_QUERY;

typedef                                 /* msg buffer header used       */
STRUCT16 _DIAL_EVENT                      /* privately by allc/free       */
{
  WORD    event_type;              /* See EVENT_* defines               */
  DWORD   identifier;              /* call or answer identifier         */
  WORD    event_rc;                /* event return code                 */
  BYTE    call_type;               /* inc/out, connected event only     */
  BYTE    reserved;                /*                                   */
  DWORD   call_id;                 /* call id, inc connected event only */
  WORD    display_lgth;            /* length of following display info  */
  BYTE    display_info[1];         /* variable lgth display array       */
} DIAL_EVENT;

typedef                                 /* msg buffer header used       */
STRUCT16 _QUERY_EVENT                     /* privately by allc/free  @001 */
{
  WORD    event_type;              /* See EVENT_* defines               */
  DWORD   query_id;                /* id of associated query request    */
  BYTE    cp_name[16];             /* name of CP responding to query    */
  BYTE    cp_region[16];           /* region of responding CP           */
  BYTE    cp_description[80];      /* description of responding CP      */
  BYTE    reserved[12];            /* ASCII mac address                 */
  BYTE    cp_sec;                  /* Security Capability               */
} QUERY_EVENT;

#define SEC_OFF                         0x00
#define SEC_ON                          0x01

/* reported in the cp_sec byte to distinguish remote node type @BFD */
#define CP_RESPONSE                     0x00
#define WKS_RESPONSE                    0x02
                                /* protocol types                         */
#define PROT_TYPE_LAN                   0x01
                                /* Display flag (for START AUTOANSWER)    */
#define DISPLAY_STATUS_YES              0x00
#define DISPLAY_STATUS_NO               0x01
                                /* Call Type (For Dial Events)            */
#define CALL_TYPE_OUTGOING              0x00
#define CALL_TYPE_INCOMING              0x01
                                /* request types                          */
#define REQUEST_STOP_AUTOANSWER         0x0004
#define REQUEST_START_AUTOANSWER        0x0005
#define REQUEST_MAKE_CALL               0x0006
#define REQUEST_HANGUP_CALL             0x0007
#define REQUEST_START_QUERY             0x0008          /*              @001 */
#define REQUEST_STOP_QUERY              0x0009          /*              @001 */
#define REQUEST_START_DIAL              0x0000
                                /* event types                            */
#define EVENT_CALL_CONNECTED            0x0001
#define EVENT_REMOTE_HANGUP             0x0002
#define EVENT_CALL_LOST                 0x0003
#define EVENT_STOP_AUTOANSWER           0x0004
#define EVENT_DISPLAY_INFO              0x0005
#define EVENT_CALLBACK_SEQUENCE         0x0006
#define EVENT_QUERY_RESPONSE            0x0008          /*              @001 */


#define DS_CP_NOT_RUNNING               0x3501
#define DS_CP_NOT_FOUND                 0x3502
#define DS_REMOTE_CP_HANGUP             0x3503
#define DS_DAC_ERROR_1_0                0x3504    /* @A03 */
#define DS_SEC_FAILURE                  0x3505
#define DS_SEC_CALLBACK_ENTRY_NOT_FOUND 0x3506    /* @BZA */
#define DS_SEC_CALLBACK_ENTRY_ERROR     0x3507    /* @BZA */
#define DS_SEC_CALLBACK_EXHAUSTED       0x3509    /* @BZA */
#define DS_SEC_CALLBACK_PENDING         0x3508    /* @BCA */

#define DS_DAC_ERROR                    0x3604    /* @A03 */
#define DS_DUP_NETBIOS_NAME             0x3609    /* @A03 */
