/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - utils.h                       */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




#ifndef MPTNUTILS
#define MPTNUTILS

#ifdef OS2
#ifndef SO32
u_long lswap( u_long );
u_short bswap( u_short );
#else /* SO32 */

/* Definition for lswap */

#ifndef lswap
#define lswap(x) ((x&0xFF)<<24)|((x&0xFF00)<<8)|((x&0xFF0000)>>8)|((x&0xFF000000)>>24)
#endif /* lswap */

/* Definition for bswap */

#ifndef bswap
#define bswap(x) ((u_short)(((u_short)x)>>8)) | ((u_short)(((u_short)x)<<8))
#endif /* bswap */
#endif /* SO32 */
#else  /* OS2 */
u_long lswap();
#endif /* OS2 */

#define htonl(x)   (lswap(x))
#define ntohl(x)   (lswap(x))
#define htons(x)   (bswap(x))
#define ntohs(x)   (bswap(x))

/* #define htonl(x)  (((u_long)x)>>24) | (((u_long)x)<<24) | \       */
/*                   (((x)&0x00FF0000L)>>8) | (((x)&0x0000FF00L)<<8) */
/* #define ntohl(x) htonl(x)                                         */

/* #define htons(x) (((unsigned)x)>>8) | (((unsigned)x)<<8)          */
/* #define ntohs(x) htons(x)                                         */

/* #define bzero(x,y) memset((x),0,(y))                              */
#define bzero(x,y) memset((x),'\0',(y))
#ifdef KERNEL
#define bcopy(x,y,z) mymemcpy((y),(x),(z))
#else
#define bcopy(x,y,z) memcpy((y),(x),(z))
#endif
#define ovbcopy(x,y,z) bcopy((x),(y),(z))
#define copyout(x,y,z) memcpy((y),(x),(z))
#define bcmp(x,y,z)  memcmp((y),(x),(z))
#define strcasecmp(x,y) strcmpi((x),(y))
#define strncasecmp(x,y,z) strnicmp(x,y,z)
#ifndef KERNEL
#define sleep(x) DOSSLEEP(((long)(x))*1000L)
#endif

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#define imin(x,y) MIN((x),(y))
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif
#ifndef min
#define min(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef FP_SEG
#define FP_SEG(fp) (*((unsigned *)&(fp)+1))
#endif
#ifndef FP_OFF
#define FP_OFF(fp) (*((unsigned *)&(fp)))
#endif

#define timercmp(t1,t2,op) (((t1)->tv_sec op (t2)->tv_sec) || \
                           (((t1)->tv_sec == (t2)->tv_sec) \
                           && ((t1)->tv_usec op (t2)->tv_usec)))
#define random() ((u_long)rand())
#define srandom(x) srand(x)

#endif /* MPTNUTILS */
