/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - socket.h                      */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




/*
 * Copyright (c) 1982, 1985, 1986 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of California at Berkeley. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 *      @(#)socket.h    7.2 (Berkeley) 12/30/87
 */
/*
 * Definitions related to sockets: types, address families, options.
 */

#ifndef MPTNSOCKET
#define MPTNSOCKET

#ifndef  MPTN
#define  MPTN      1                    /* enable for MPTN   */
#endif

/*
 * Types
 */

#define SOCK_STREAM     1               /* stream socket */
#define SOCK_DGRAM      2               /* datagram socket */
#define SOCK_RAW        3               /* raw-protocol interface */
#define SOCK_RDM        4               /* reliably-delivered message */
#define SOCK_SEQPACKET  5               /* sequenced packet stream */

/*
 * Option flags per-socket.
 */
#define SO_DEBUG        0x0001          /* turn on debugging info recording */
#define SO_ACCEPTCONN   0x0002          /* socket has had listen() */
#define SO_REUSEADDR    0x0004          /* allow local address reuse */
#define SO_KEEPALIVE    0x0008          /* keep connections alive */
#define SO_DONTROUTE    0x0010          /* just use interface addresses */
#define SO_BROADCAST    0x0020          /* permit sending of broadcast msgs */
#define SO_USELOOPBACK  0x0040          /* bypass hardware when possible */
#define SO_LINGER       0x0080          /* linger on close if data present */
#define SO_OOBINLINE    0x0100          /* leave received OOB data in line */

/*
 * Additional options, not kept in so_options.
 */
#define SO_SNDBUF       0x1001          /* send buffer size */
#define SO_RCVBUF       0x1002          /* receive buffer size */
#define SO_SNDLOWAT     0x1003          /* send low-water mark */
#define SO_RCVLOWAT     0x1004          /* receive low-water mark */
#define SO_SNDTIMEO     0x1005          /* send timeout */
#define SO_RCVTIMEO     0x1006          /* receive timeout */
#define SO_ERROR        0x1007          /* get error status and clear */
#define SO_TYPE         0x1008          /* get socket type */

/*
 * Structure used for manipulating linger option.
 */
struct  linger {
        int     l_onoff;                /* option on/off */
        int     l_linger;               /* linger time */
};

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#ifdef SO32
#define SOL_SOCKET      -1              /* options for socket level */
#else
#define SOL_SOCKET      0xffff          /* options for socket level */
#endif
/*
 * Address families.
 */
#define AF_UNSPEC       0               /* unspecified */
#define AF_UNIX         1               /* local to host (pipes, portals) */
#define AF_INET         2               /* internetwork: UDP, TCP, etc. */
#define AF_IMPLINK      3               /* arpanet imp addresses */
#define AF_PUP          4               /* pup protocols: e.g. BSP */
#define AF_CHAOS        5               /* mit CHAOS protocols */
#define AF_NS           6               /* XEROX NS protocols */
#define AF_NBS          7               /* nbs protocols */
#define AF_ECMA         8               /* european computer manufacturers */
#define AF_DATAKIT      9               /* datakit protocols */
#define AF_CCITT        10              /* CCITT protocols, X.25 etc */
#define AF_SNA          11              /* IBM SNA */
#define AF_DECnet       12              /* DECnet */
#define AF_DLI          13              /* Direct data link interface */
#define AF_LAT          14              /* LAT */
#define AF_HYLINK       15              /* NSC Hyperchannel */
#define AF_APPLETALK    16              /* Apple Talk */
#ifndef MPTN
#define AF_MAX          17
#else

#define AF_OS2          AF_UNIX         /* OS/2 local IPC */
#define AF_NB           17              /* Netbios */
#define AF_NETBIOS      AF_NB

#define AF_DIRECT       254             /* MPTN Direct user */
#define AF_GW           255             /* MPTN Gateway Device Driver*/
#define AF_GATEWAY      AF_GW

#define AF_MAX          18
#endif

/*
 * Structure used by kernel to store most
 * addresses.
 */
struct sockaddr {
        u_short sa_family;              /* address family */
        char    sa_data[14];            /* up to 14 bytes of direct address */
};
/*
 * Structure used by kernel to pass protocol
 * information in raw sockets.
 */
struct sockproto {
        u_short sp_family;              /* address family */
        u_short sp_protocol;            /* protocol */
};

/*
 * Protocol families, same as address families for now.
 */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK
#define PF_PUP          AF_PUP
#define PF_CHAOS        AF_CHAOS
#define PF_NS           AF_NS
#define PF_NBS          AF_NBS
#define PF_ECMA         AF_ECMA
#define PF_DATAKIT      AF_DATAKIT
#define PF_CCITT        AF_CCITT
#define PF_SNA          AF_SNA
#define PF_DECnet       AF_DECnet
#define PF_DLI          AF_DLI
#define PF_LAT          AF_LAT
#define PF_HYLINK       AF_HYLINK
#define PF_APPLETALK    AF_APPLETALK

#define PF_MAX          AF_MAX

#ifndef MPTN
#define PF_OS2          PF_OS2
#define PF_NB           AF_NB
#define PF_NETBIOS      PF_NB

#define PF_DIRECT       AF_DIRECT
#define PF_GW           AF_GW
#define PF_GATEWAY      PF_GW
#endif

/*
 * Maximum queue length specifiable by listen.
 */
#define SOMAXCONN       5

/*
 * Message header for recvmsg and sendmsg calls.
 */
struct msghdr {
        caddr_t msg_name;               /* optional address */
        int     msg_namelen;            /* size of address */
        struct  iovec *msg_iov;         /* scatter/gather array */
        int     msg_iovlen;             /* # elements in msg_iov */
        caddr_t msg_accrights;          /* access rights sent/received */
        int     msg_accrightslen;
};

struct iovec {
        caddr_t iov_base;
        int     iov_len;
};

struct uio {
        struct  iovec *uio_iov;
        int     uio_iovcnt;
        off_t   uio_offset;
        int     uio_segflg;
        int     uio_resid;
};
enum    uio_rw { UIO_READ, UIO_WRITE };
#define FREAD  1
#define FWRITE 2

#define MSG_OOB         0x1             /* process out-of-band data */
#define MSG_PEEK        0x2             /* peek at incoming message */
#define MSG_DONTROUTE   0x4             /* send without using routing tables */

#define MSG_MAXIOVLEN   16

#ifdef OS2
#ifndef KERNEL

/* 32 bit socket prototype definition */
#ifdef SO32

/* Accept */
int  _System accept( int, struct sockaddr *, int * );

/* Bind */
int  _System bind( int, struct sockaddr *, int );

/* Connect */
int  _System connect( int, struct sockaddr *, int );

/* GetHostID */
unsigned long _System gethostid( );

/* GetPeerName */
int  _System getpeername( int, struct sockaddr *, int * );

/* GetSockName */
int  _System getsockname( int, struct sockaddr *, int * );

/* GetSockOpt */
int  _System getsockopt( int, int, int, char *, int * );

/* Listen */
int  _System listen( int, int);

/* READV */
int  _System readv( int, struct iovec *, int);

/* RECVMSG */
int  _System recvmsg( int, struct msghdr *, int);

/* Recv */
int  _System recv( int, char *, int, int );

/* Recvfrom */
int  _System recvfrom(int, char *, int, int, struct sockaddr *, int * );

#ifndef BSD_SELECT
/* Select */
int  _System select( int *, int, int, int, long );
#endif /* BSD_SELECT */

/* Send */
int  _System send( int, char *, int, int );

/* SENDMSG */
int  _System sendmsg( int, struct msghdr *, int);

/* Sendto */
int  _System sendto( int, char *, int, int, struct sockaddr *, int );

/* Setsockopt */
int  _System setsockopt( int, int, int, char *, int );

/* shutdown */
int  _System shutdown( int, int);

/* SOCK_INIT */
int  _System sock_init( void );

/* Socket */
int  _System socket( int, int, int );

/* Soclose */
int  _System soclose( int );

/* TCPERRNO */

/* WRITEV */
int  _System writev( int, struct iovec *, int);

/* SOCK_ERRNO */
int  _System sock_errno( void );

/* PSOCK_ERRNO */
#ifndef MPTN
#define psock_errno psock_errno1
void _System psock_errno1( char * );
#else
void _System psock_errno( char * );
#endif

#else /* SO32 */

/* 16 bit socket prototype definition */

int accept( int, struct sockaddr *, int * );
int bind( int, struct sockaddr *, int );
int connect( int, struct sockaddr *, int );
int getpeername( int, struct sockaddr *, int * );
int getsockname( int, struct sockaddr *, int * );
int getsockopt( int, int, int, char *, int * );
int listen( int, int );
int readv( int, struct iovec *, int);
int recvmsg( int, struct msghdr *, int);
int recv( int, char *, int, int );
int recvfrom(int, char *, int, int, struct sockaddr *, int * );
#ifndef BSD_SELECT
int select( int *, int, int, int, long );
#endif /* BSD_SELECT */
int sendmsg( int, struct msghdr *, int);
int send( int, char *, int, int );
int sendto( int, char *, int, int, struct sockaddr *, int );
int setsockopt( int, int, int, char *, int );
int shutdown( int, int );
int sock_cancel( int );                  /* not defined for 32 bit or in TCP */
int sock_init( void );
int socket( int, int, int );
int socketpair( int, int, int, int );
int soclose( int );
int writev( int, struct iovec *, int);
#endif /* SO32 */

#endif /* KERNEL */
#endif /* OS2 */

#endif /* MPTNSOCKET */
