/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - netlib.h                      */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




/* IBM COPYRIGHT 1989 */

#ifndef MPTNNETLIB
#define MPTNNETLIB

#ifndef _TIMEVAL
#define _TIMEVAL
struct timeval {
   unsigned long tv_sec;
   unsigned long tv_usec;
};

struct timezone {
  unsigned short tmz;
};
#endif

/* remove duplicate definition of prototype definition with netdb.h */

/* struct hostent * gethostbyaddr(char *, int, int); */
/* struct hostent * gethostent() ;                   */
/* struct hostent * gethostbyname(char *);           */

#ifdef SO32
/* Inet_Addr */
u_long _System inet_addr(char *);
#else /* SO32 */
u_long inet_addr(char *);
#endif /* SO32 */

struct in_addr inet_makeaddr(u_long, u_long);
u_long inet_network(char *);

#ifdef SO32
/* inet_ntoa */
char * _System inet_ntoa(struct in_addr);
#else /* SO32 */
char * inet_ntoa(struct in_addr);
#endif /* SO32 */

u_long inet_lnaof(struct in_addr);
u_long inet_netof(struct in_addr);

struct netent * getnetbyname(char *);
struct netent * getnetent();
struct protoent * getprotobyname(char *);
struct servent * getservbyport(int, char *);
/* remove duplicate definition of prototype definition with netdb.h */
/* struct servent * getservbyname( char *, char *);                 */
struct servent * getservent();
struct netent * getnetbyname(char *);
struct netent * getnetbyaddr(unsigned long, int);

char * rindex(char *, char);
#define SIGALRM 0
int     gettimeofday(struct timeval *,struct timezone *);
int     dn_expand(u_char *, u_char *, u_char *, u_char *, int);
int     dn_comp(u_char *, u_char *, int, u_char **, u_char **);
int     dn_skipname(u_char *, u_char *);
u_short _getshort( u_char *);
u_long  _getlong( u_char *);
int     putshort(u_short , u_char *);
int     putlong( u_long ,  u_char *);
int     p_query( char *);
char *  p_type(int);
char *  p_class(int);
char *  p_time(u_long);
int     res_init();
int     res_mkquery(int, char *, int, int, char *, int, struct rrec *, char *, int);
int     res_send(char *, int, char *, int);
int     _res_close();
int     res_query(char *, int, int, u_char *, int);
int     res_search(char *, int, int, u_char *, int);
int     res_querydomain(char *, char *, int, int, u_char *, int);
char *  hostalias( char *);

#endif /* MPTNNETLIB */
