/********************************************************Copyright.IBM*****/
/*                                                                        */
/*                                                                        */
/*      Multi-Protocol Transport Services - lint.h                        */
/*                                                                        */
/*      Licensed Materials - Property of IBM (R)                          */
/*      5622-069                                                          */
/*      (C) Copyright IBM Corp. 1993, All right reserved.                 */
/*      US Government Users Restricted Rights - Use, duplication,         */
/*      disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                        */
/********************************************************Copyright.IBM*****/




#ifdef OS2
#DEFINE RECOMPILE
#endif

arpwhohas(struct arpcom *, struct in_addr *);
arpresolve(struct arpcom *, struct mbuf *, struct in_addr *, u_char *, int *);
tr_arpresolve(struct arpcom *, struct mbuf *, register struct in_addr *,
              u_char *, int *, u_short *, u_short [] );
arpinput(struct arpcom *, struct mbuf *);
tr_arpinput(struct arpcom *, struct mbuf *, register struct mac_hdr *);
tr_in_arpinput(struct arpcom *, struct mbuf *, struct mac_hdr *);
in_arpinput(struct arpcom *, struct mbuf *);
arptfree(struct arptab *);
struct arptab * arptnew(struct in_addr *);
arpioctl(int, char *);
char * ether_sprintf(u_char *);
inet_hash(struct sockaddr_in *, struct afhash *);
inet_netmatch(struct sockaddr_in *,struct sockaddr_in *);
struct in_addr in_makeaddr(u_long, u_long);
u_long in_netof( struct in_addr);
u_long in_lnaof( struct in_addr);
in_localaddr( struct in_addr);
in_canforward( struct in_addr);
in_control(struct socket *, int, caddr_t, struct ifnet *);
in_ifinit(struct ifnet *, struct in_ifaddr *, struct sockaddr_in *);
struct in_ifaddr * in_iaonnetof( u_long );
in_broadcast( struct in_addr);
in_cksum(struct mbuf *,int );
in_pcballoc( struct socket *, struct inpcb *);
in_pcbbind(struct inpcb *, struct mbuf *);
in_pcbconnect(struct inpcb *, struct mbuf *);
in_pcbdisconnect( struct inpcb *);
in_pcbdetach( struct inpcb *);
in_setsockaddr(struct inpcb *, struct mbuf *);
in_setpeeraddr( struct inpcb *, struct mbuf *);
in_pcbnotify(struct inpcb *, struct in_addr *, int, int (*)());
in_losing( struct inpcb *);
in_rtchange( struct inpcb *);
struct inpcb * in_pcblookup(
  struct inpcb *, struct in_addr, u_short, struct in_addr, u_short, int);
icmp_error(struct ip *, int, int, struct ifnet *, struct in_addr );
icmp_reflect(struct ip *, struct ifnet *);
struct in_ifaddr * ifptoia( struct ifnet *ifp);
icmp_send( register struct ip *, struct mbuf *);
struct ip * ip_reass(struct ipasfrag *, struct ipq *);
ip_freef( struct ipq *);
ip_enq(struct ipasfrag *,struct ipasfrag *);
ip_deq(struct ipasfrag *);
ip_dooptions(struct ip *,struct ifnet *);
struct in_ifaddr * ip_rtaddr( struct in_addr);
save_rte( u_char *, struct in_addr);
struct mbuf * ip_srcroute();
ip_stripoptions( struct ip *, struct mbuf *);
ip_forward(struct ip *, struct ifnet *);
insque(struct qhdr *,struct qhdr *);
remque(struct qhdr *);
struct mbuf * ip_insertoptions(struct mbuf *,struct mbuf *,int *);
ip_optcopy(struct ip *, struct ip *);
ip_pcbopts( struct mbuf **, register struct mbuf *);
tcp_reass(struct tcpcb *, struct tcpiphdr *);
tcp_pulloutofband( struct socket *, struct tcpiphdr *);
tcp_mss( struct tcpcb *);
tcp_setpersist(struct tcpcb *);
struct tcpiphdr * tcp_template( struct tcpcb *);
#ifdef RECOMPILE
#include "tcp.h"
#else
#include "..\netinet\tcp.h"
#endif
tcp_respond(struct tcpcb *, struct tcpiphdr *, tcp_seq, tcp_seq, int);
struct tcpcb * tcp_newtcpcb( struct inpcb *);
struct tcpcb * tcp_drop(struct tcpcb *, int);
struct tcpcb * tcp_close(struct tcpcb *);
tcp_notify(struct inpcb *);
tcp_ctlinput(int, struct sockaddr *);
tcp_abort( struct inpcb *);
tcp_quench( struct inpcb *);
tcp_canceltimers( struct tcpcb *);
struct tcpcb * tcp_timers(struct tcpcb *, int);
udp_input( struct mbuf *, struct ifnet *);
udp_notify(struct inpcb *);
udp_ctlinput( int, struct sockaddr *);
udp_output(struct inpcb *, struct mbuf *);
udp_usrreq(struct socket *, int, struct mbuf *, struct mbuf *, struct mbuf *);
struct protosw * pffindtype(int, int);
struct protosw * pffindproto(int, int, int);
pfctlinput(int, struct sockaddr *);
caddr_t m_clalloc(int, int, int);
m_pgfree(caddr_t, int);
m_expand(int);
struct mbuf * m_get(int, int);
struct mbuf * m_getclr(int, int);
struct mbuf * m_free(struct mbuf *);
struct mbuf * m_more(int, int) ;
m_freem(struct mbuf *);
struct mbuf * m_copy(struct mbuf *, int, int);
m_cat(struct mbuf *, struct mbuf *);
m_adj(struct mbuf *, int);
struct mbuf * m_pullup(struct mbuf *, int);
panic(char *s);
socreate(int, struct socket **, int, int);
sobind( struct socket *, struct mbuf *);
solisten(struct socket *, int);
sofree(struct socket *);
soclose(struct socket *);
soabort( struct socket *);
soaccept( struct socket *, struct mbuf *);
soconnect(struct socket *, struct mbuf *);
soconnect2(struct socket *, struct socket *);
sodisconnect(struct socket *);
sosend(struct socket *, struct mbuf *, struct uio *, int, struct mbuf *, unsigned);
soreceive(struct socket *, struct mbuf **,struct uio * , int, struct mbuf **);
soshutdown(struct socket *, int);
sorflush(struct socket *);
sosetopt(struct socket *, int, int, struct mbuf *);
sogetopt(struct socket *, int, int, struct mbuf **);
sohasoutofband(struct socket *);
soisconnecting(struct socket *);
soisconnected(struct socket *);
soisdisconnecting(struct socket *);
soisdisconnected(struct socket *);
struct socket * sonewconn(struct socket *);
soqinsque(struct socket *, struct socket *, int);
soqremque(struct socket *, int);
socantsendmore(struct socket *);
socantrcvmore(struct socket *);
sbselqueue(struct sockbuf *);
sbwait(struct sockbuf *);
sbwakeup(struct sockbuf *);
sowakeup(struct socket *, struct sockbuf *);
soreserve(struct socket *, u_long, u_long);
sbreserve(struct sockbuf *, u_long);
sbrelease(struct sockbuf *);
sbappend( struct sockbuf *, struct mbuf *);
sbappendrecord( struct sockbuf *, struct mbuf *);
sbappendaddr(struct sockbuf *, struct sockaddr *, struct mbuf *,struct mbuf * );
sbappendrights(struct sockbuf *, struct mbuf *, struct mbuf *);
sbcompress(struct sockbuf *, struct mbuf *, struct mbuf *);
sbflush(struct sockbuf *);
sbdrop(struct sockbuf *, int);
sbdroprecord(struct sockbuf *);
sfree(int);
sleep(char *,unsigned);
wakeup(char *);
