;;; emx-cmd.el --- specialized comint.el for running the OS/2 shell.

;; Copyright (C) 1993, 1994 Eberhard Mattes

;; Author: Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
;; Keywords: emx, processes

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Code:

(require 'shell)
(provide 'emx-cmd)

(defun cmd ()
  "Run CMD.EXE with I/O through buffer *cmd*.
See shell for details."
  (interactive)
  (cond ((not (comint-check-proc "*cmd*"))
	 (let* ((prog "cmd")
		(name (file-name-nondirectory prog))
                (shell-prompt-pattern "^\\[[^]]*\\] *"))
           (setenv "PROMPT")
           (set-buffer (make-comint "cmd" prog))
	   (shell-mode)
	   (setq comint-process-echoes t))))
  (switch-to-buffer "*cmd*"))

;;; emx-cmd.el ends here
