@echo *************************************************************************
@echo *         Installing Presentation Manager support on Windows NT         *
@echo *                    Release 1.0, April 1994                            *
@echo * Please read the release notes before proceeding with the installation *
@echo *************************************************************************
@echo.

@if "%1"=="" goto usage
@if "%1"=="/h" goto usage
@if "%1"=="-h" goto usage
@if "%1"=="/H" goto usage
@if "%1"=="-H" goto usage
@if "%1"=="/help" goto usage
@if "%1"=="-help" goto usage
@if "%1"=="/?" goto usage
@if "%1"=="-?" goto usage

@if exist %1\system32\ntoskrnl.exe goto wait_user
@echo ERROR: %1 does not seem to be the root of a WINNT installation.
@echo        Please check and run INSTALL again with the correct target path.
@echo        (for example: INSTALL C:\WINNT)
@goto end

:wait_user

@if not exist \YNC.EXE goto disk1
@\ync -c yn Proceed with PM Subsystem installation ?
@echo.
@if not errorlevel 1 goto ok_winnt

@echo Aborting !
@echo.
@goto end

:disk1
@echo *** Please insert Disk#1 in drive ***
@pause

:ok_winnt

@if exist \OS2.EXE goto ok_disk1
@echo ERROR: wrong disk !
@echo.
@goto disk1

:ok_disk1

@REM Checking if C:\OS2 exists
@if not exist C:\OS2\DLL\KBDCALLS.DLL goto no_os2
@echo WARNING: C:\OS2 seems to contain an OS/2 installation.
@echo          If you want to keep OS/2, you should back-up this directory.
@\ync -c yn Is it OK to delete C:\OS2 and all its sub-directories ?
@echo.
@if not errorlevel 1 goto no_os2

@echo Aborting !
@echo.
@goto end

:no_os2
@\tlist | \checkos2
@if not errorlevel 1 goto update_env
@echo WARNING: It seems that OS/2 programs are currently running. The install
@echo          procedure requires that no OS/2 program is currently running.
@\ync -c yn Is it OK to kill these OS/2 programs now ?
@echo.
@if not errorlevel 1 goto kill_app

@echo Aborting !
@echo.
@goto end

:kill_app
@echo Killing OS/2 application(s) ...
@echo.
@\kill os2.exe
@\tlist | \checkos2
@if not errorlevel 2 goto update_env
@echo WARNING: It seems that OS/2 programs are still running. The install
@echo          procedure requires that no OS/2 program is currently running.
@\ync -c yn Is it OK to kill these OS/2 programs now ?
@echo.
@if not errorlevel 1 goto kill_app

@echo Aborting !
@echo.
@goto end

:update_env
@\kill os2srv.exe
@\kill os2srv.exe
@\kill os2ss.exe
@echo Copying: \OS2.EXE to %1\SYSTEM32\.
@copy \OS2.EXE %1\system32\.
@echo Copying: \OS2SRV.EXE to %1\SYSTEM32\.
@copy \OS2SRV.EXE %1\system32\.
@echo Copying: \OS2SS.EXE to %1\SYSTEM32\.
@copy \OS2SS.EXE %1\system32\.
@echo Updating system environment variables ...
@echo.
@set save_path=%Path%
@set path=.;%Path%
@set save_libpath=%Os2LibPath%
@set Os2LibPath=.;%Os2LibPath
@\instcnfg
@set Os2LibPath=%save_libpath%
@set Path=%save_path%
@set save_path=
@set save_libpath=
@\kill os2srv.exe
@\kill os2srv.exe
@\kill os2srv.exe

@echo Deleting old C:\OS2 and creating new ...
@\delnode /q C:\OS2
@mkdir c:\OS2 1>nul 2>&1
@mkdir c:\OS2\DLL 1>nul 2>&1
@mkdir c:\OS2\HELP 1>nul 2>&1
@echo Copying: \DOSCALLS.DLL to C:\OS2\DLL\.
@copy \DOSCALLS.DLL C:\OS2\DLL\.
@echo Copying: \NETAPI.DLL to C:\OS2\DLL\.
@copy \NETAPI.DLL C:\OS2\DLL\.
@echo Copying: \OS2\DLL\*.* to C:\OS2\DLL\.
@copy \OS2\DLL\*.* c:\os2\dll\.
@del %1\SYSTEM32\OS2\DLL\DOSCALLS.DLL 1>nul 2>&1
@del %1\SYSTEM32\OS2\DLL\NETAPI.DLL 1>nul 2>&1
@echo.

:disk2
@echo *** Please insert Disk#2 in drive ***
@pause

@if exist \OS2\DLL\COURIER.FON goto ok_disk2
@echo ERROR: wrong disk !
@echo.
@goto disk2

:ok_disk2

@echo Copying: \OS2\DLL\*.* to C:\OS2\DLL\.
@copy \OS2\DLL\*.* c:\os2\dll\.
@echo Copying: \OS2\*.* to C:\OS2\.
@copy \OS2\*.* c:\os2\.
@echo.

:disk3
@echo *** Please insert Disk#3 in drive ***
@pause

@if exist \OS2\DLL\PMGPI.DLL goto ok_disk3
@echo ERROR: wrong disk !
@echo.
@goto disk3

:ok_disk3

@echo Copying: \OS2\DLL\*.* to C:\OS2\DLL\.
@copy \OS2\DLL\*.* c:\os2\dll\.
@echo Copying: \OS2\HELP\*.* to C:\OS2\HELP\.
@copy \OS2\HELP\*.* c:\os2\help\.
@echo Copying: \OS2\*.* to C:\OS2\.
@copy \OS2\*.* c:\os2\.
@echo.

:disk4
@echo *** Please insert Disk#4 in drive ***
@pause

@if exist \WINNT\SYSTEM32\DRIVERS\PMNTDD.SYS goto ok_disk4
@echo ERROR: wrong disk !
@echo.
@goto disk4

:ok_disk4

@echo Copying: \OS2\DLL\*.* to C:\OS2\DLL\.
@copy \OS2\DLL\*.* c:\os2\dll\.
@echo Copying: \OS2\*.* to C:\OS2\.
@copy \OS2\*.* c:\os2\.
@if not exist %1\SYSTEM32\DRIVERS\PMNTDD.SYS goto no_driver
@echo Warning: renaming old %1\SYSTEM32\DRIVERS\PMNTDD.SYS to %1\SYSTEM32\DRIVERS\PMNTDD.OLD
@echo          (you may delete that file after the next reboot)
@\mv %1\SYSTEM32\DRIVERS\PMNTDD.SYS %1\SYSTEM32\DRIVERS\PMNTDD.OLD
:no_driver
@echo Copying: \WINNT\SYSTEM32\DRIVERS\*.* to %1\SYSTEM32\DRIVERS\.
@copy \WINNT\SYSTEM32\DRIVERS\*.* %1\system32\drivers\.
@echo.
@echo Installing PM Subsystem driver ...
@regini \PMNTDD.INI 1>nul 2>&1
@echo.
@echo Copying: \WINNT\SYSTEM32\OS2\*.* to %1\SYSTEM32\OS2\.
@if exist %1\system32\os2 goto os2_dir
@mkdir %1\system32\os2 1>nul 2>&1
:os2_dir
@copy \WINNT\SYSTEM32\OS2\*.* %1\system32\os2\.
@echo.
@\pmgroup

@echo .-------------------------------------------------------------------.
@echo *                   Installation has completed                      *
@echo * Please remove Disk#4 from the floppy drive and reboot your system *
@echo `-------------------------------------------------------------------'
@goto end

:usage
@echo ERROR, illegal invocation. Usage:
@echo  INSTALL winnt_path
@echo  (for example: INSTALL C:\WINNT)
@echo.
@goto end

:end

