/*  ******************************************************************  *\
 *    SysteMCV.CMD --- Yes folks !  This is REXX !                      *
 *                                                                      *
 *    JdeBP's LiveWire script file for connecting to SysteM-C-V and     *
 *    performing a fully automated mail run.  This could probably       *
 *    be adapted to work with any PC Board 15 BBS.                      *
 *                                                                      *
 *    (c) Copyright 1994 Jonathan de Boyne Pollard                      *
 *        Jonathan.de.Boyne.Pollard@p3.f4.n440.z2.fidonet.org           *
 *        JdeBP@donor2.ukmail.net                                       *
 *                                                                      *
 *    Permission is hereby granted to post, steal and abuse this        *
 *    script for your own purposes to your heart's content, as long     *
 *    as you realise that I take no responsibility whatsoever for       *
 *    what it does to your machine, data, cat, or marital status.       *
\*  ******************************************************************  */

/* All of these adapted from the learned script */
Trace(Off);
SetLW(TimeOut,60);
SetLW(Pacing,40);
SetLW(Emulation,1);
SetLW(Echo,0);
SetLW(Linefeeds,0);
SetLW(XonXoff,0);
SetLW(BSIsDel,0);

/* Here's the main bit folks !                                          */

    SendUserName() ;          /* All that logging on stuff is handled   */
    SendLW("Mail^M") ;        /* Enter the mail door from the main menu */
    CamMail() ;               /* My mail door is Cam-Mail               */
    HangUpLW() ;              /* We've said (G)oodbye, so ...           */

    exit

/*  Wasn't that simple !  That's the power of REXX you know.  (-:       */

/*                                                                      */
/*  SendUserName -  This function handles all of the initial logging    */
/*  on nastiness.  The idea of it being a loop is that on noisy lines   */
/*  it should keep reentering your name until either it works, or the   */
/*  BBS hangs up on you in disgust.                                     */
/*                                                                      */

SendUserName:

    /*  Customise the following for your PC Board setup.                */

    /*  The backspaces before my name are to clear up a load of ANSI    */
    /*  junk that somehow gets entered into the username field.         */

    /*  Note how we pick the password up from the dialling list entry.  */

    Username = "^H^H^H^H^H^H^HJonathan de Boyne Pollard^M"
    Password = GetLW("DialerPassword")||"^M"
    Language = "2"

    do forever

    /* **************************************************************** *\
     * The following are the modifications needed to login to Channel 1 *
     * in the United State, and are good examples of the modifications  *
     * that may be required in some cases.                              *
     *                                                                  *
     * login=FindLW("anguage # to use",                                 *
     *             ,"graphics (Enter)=no? ",                            *
     *             ,"you want Color? ",                                 *
     *             ,"our first name?",                                  *
     *             ,"Is this correct? ",                                *
     *             ,"rd (Dots will echo)? ",                            *
     *             ,"ead your personal mail",                           *
     *             ," Main Board Command? ");                           *
     *                                                                  *
     * select                                                           *
     * when login="anguage # to use"      then SendLW(Language||"^M") ; *
     * when login="you want Color? "      then SendLW("^M") ;           *
     * when login="graphics (Enter)=no? " then SendLW("^M") ;           *
    \* **************************************************************** */

       login=FindLW("used (Enter)=Normal? ",
                   ,"graphics (Enter)=no? ",
                   ,"our first name?",
                   ,"Is this correct? ",
                   ,"rd (Dots will echo)? ",
                   ,"ead your personal mail",
                   ," Main Board Command? ");

       select
       when login="used (Enter)=Normal? "  then SendLW(Language||"^M") ;
       when login="graphics (Enter)=no? "  then SendLW("^M") ;
       when login="our first name?"        then SendLW(Username) ;
       when login="Is this correct? "      then SendLW("Y^M") ;
       when login="rd (Dots will echo)? "  then SendLW(Password) ;
       when login="ead your personal mail" then SendLW("N^M") ;
       when login=" Main Board Command? "  then Leave ;
       otherwise do

          /*  The only thing that usually will bring you here is   */
          /*  a timeout.  What you do here is up to you.  I just   */
          /*  panic myself.                                        */

                 Say "SCRIPT FAILED !!!! The prompt was " login
                 HangUpLW() ;
                 Exit ;
       end
       end

    end

    /*  We are now at the main board command prompt.                    */

    return "" ;

/*                                                                      */
/*  CamMail -- A simplistic handler for the Cam-Mail mail door.  This   */
/*  will upload a REP if it exists, then download a QWK and hangup.     */
/*                                                                      */

CamMail:
    UploadDir = GetLW("ULDir") ;
    if UploadDir \= "" then UploadDir = UploadDir||"\" ;
    RepFile = UploadDir||"SysteMCV.rep" ;
    Protocol = GetLW("DialerProtocol") ;

    /*  These variables track what is going on */
    Uploaded = ( stream(RepFile, 'C', 'Query Exists')="" )
    Downloaded = 0 ;
    Done = 0 ;


    do until (Done)

       cammail=FindLW(" Cam-Mail Command? ",
                     ,"you want to receive these messages",
                     ,"Prepare To Download",
                     ,"(H)angup");

       select
       when cammail=" Cam-Mail Command? " then do

            select

            when \ Uploaded then do
                 SendLW("u^M") ;
                 DelayLW(300) ;
                 SendFilesLW(Protocol, RepFile) ;
                 Uploaded = 1
            end
            when \ Downloaded then do
                 DelayLW(700) ;
                 SendLW("d^M") ;
            end
            otherwise  do
                 SendLW("G^M") ;
                 Done = 1 ;
            end

            end

       end
       when cammail="you want to receive these messages" then do
            SendLW("Y^M") ;
       end
       when cammail="Prepare To Download" then do
            ReceiveFilesLW(Protocol, "SysteMCV.qwk") ;
            Downloaded = 1 ;
       end
       when cammail="(H)angup" then do
            DelayLW(100) ;
            SendLW("h") ;
            Done = 1 ;
       end
       otherwise nop ;
       end

    end

    /* This is the fun bit which you can adapt to your own ends.  You   */
    /* now potentially have a QWK in your download directory.  What I   */
    /* do is to start a batch file in the background that copies it to  */
    /* an archive directory, and moves the original into the mail       */
    /* reader's inbound directory.  Of course, TRANSFER.BTM handles all */
    /* of my QWKs, so it takes the BBSID as a parameter.                */

    Start "/bg /c Transfer SysteMCV"

    /* The transfer now is running in the background.  Good, innit ?    */

    return "" ;

