
if {$Debug} {
  proc grab {args} {
    return
  }
}

################################################################
####		 Error Messages Procedures                  ####
################################################################

## MessageBox
proc MessageBox {mess} {
  
  if [winfo exists .confirm] {
    destroy .confirm
  }
  toplevel .confirm
  
  # Window manager configurations
  global tkVersion
  wm positionfrom .confirm ""
  wm sizefrom .confirm ""
  wm maxsize .confirm 1000 900
  wm minsize .confirm 10 10
  wm title .confirm {Picasso}
  
  
  # build widget .confirm.abort
  button .confirm.quit -command "destroy .confirm" \
    -text "Ok"
  
  label .confirm.visu -text $mess
  
  # pack widget .confirm
  pack append .confirm  .confirm.visu {top frame center expand fill}  .confirm.quit {left frame center expand fill}
  
  return .confirm
}

# ConfirmBox
proc ConfirmBox { {message ""} args } {
  
  if [winfo exists .confirm] {
    destroy .confirm
  }
  toplevel .confirm
  
  # Window manager configurations
  global tkVersion
  wm positionfrom .confirm ""
  wm sizefrom .confirm ""
  wm maxsize .confirm 1000 900
  wm minsize .confirm 10 10
  wm title .confirm {Picasso}

  label .confirm.confirmLabel \
    -text $message
  
  pack append .confirm \
    .confirm.confirmLabel {top frame n expand pady 10}

  while {$args != ""} {
    set label [lvarpop args]
    set action [lvarpop args]

    button .confirm.$label \
      -command "destroy .confirm; $action" \
      -text $label

    pack append .confirm \
      .confirm.$label {left frame center expand fill pady 8}
  }
  tkwait window .confirm
}

# Procedure: ChangeMode
proc ChangeMode {modeName} {
  global CurrentMode ModeHelp HelpEntries

  grab release [cv]
  # ImageMode == false mode! #

  if {$modeName == "ImageMode"} {
    cimage_dialog
    return
  }
  
  ModeExitHook $CurrentMode
  [SN $CurrentMode] configure -relief raised
  ModeEntryHook $modeName
  [SN $modeName] configure -relief sunken 
  set CurrentMode $modeName
  if {[catch {keylset HelpEntries "top[translit "." "_" [cv]]" $ModeHelp($CurrentMode)}]} {
    catch {keyldel HelpEntries "top[translit "." "_" [cv]]"}
  }
}

################################################################
####			 Gripe                              ####
################################################################

proc Gripe {} {
  global gripeFile

  if {$gripeFile == ""} { return }

  set content [textBox {Gripe Message:} "" Ok Cancel]
  if {[catch {open $gripeFile "a"} st]} {
    warn "Couldn't open $gripeFile for writing"
    return
  }

  puts $st "[lindex $content 1]\n"
  close $st
}  

##
##  Circulate Entry bindings
##

proc circEntryBind {fwd bwd args} {

  set ids [lindex $args 0]
  set l [llength $ids]
  foreach action $fwd {
    loop i 0 $l {
      bind [lindex $ids $i] $action \
	"+ focus [lindex $ids [expr ($i+1)%($l)]]"
    }
  }

  foreach action $bwd {
    loop i 0 $l {
      bind [lindex $ids $i] $action \
	"+ focus [lindex $ids [expr ($i-1)%($l)]]"
    }
  }
}

################################################################
####	  Handling of displayed option frames               ####
####     3 option frames are simultaneously displayed.      ####
####  The older one is removed when a new one is requested  ####
################################################################

proc optionViewRaise {option} {
  ##  puts option on head of the view list  ##
  ##  then calls optionViewHandle  ##
  global optionViewOrder

  set order $optionViewOrder
  set optionViewOrder $option
  foreach elt $order {
    if {$elt != $option} { lappend optionViewOrder $elt }
  }
  optionViewHandle
}

proc optionViewHandle {} {
  global optionBtState optionBtVar optionViewOrder optionViewSeps

  ####  disable configure binding to avoid nested calls !  ####
  bind .optionFr <Configure> {}

  set toadd [lindex $optionViewOrder 0]
  if {$optionBtVar($toadd) == 1} {
    pack forget .optionFr.sep$toadd
    pack forget [SN "optionFrame$toadd"]
  }

  set optionBtVar($toadd) 1
  pack [SN "optionFrame$toadd"] \
    -after .optionFr.sep -side top -fill x
  pack .optionFr.sep$toadd \
    -after [SN "optionFrame$toadd"] -side top -fill x

  update

  ##  Remove option sets until it fits in  ##

  if {[winfo height .optionFr] > [winfo height [cv]]} {
    #  find 2 last children  #
    if {[regsub {[.]optionFr[.]sep} [llast [pack slaves .optionFr]] {} option]} {
      pack forget .optionFr.sep$option
      pack forget [SN "optionFrame$option"]
      set optionBtVar($option) 0
      update
    }
  }

  ##  restore configure binding  ##
  update	
  bind .optionFr <Configure> { optionViewHandle }
}

proc MenuPopupHandle { xfMenu xfW xfX xfY} {
  ##########
  # Procedure: MenuPopupHandle
  # Description: handle the popup menus
  # Arguments: xfMenu - the menu to attach
  #            xfW - the widget
  #            xfX - the root x coordinate
  #            xfY - the root x coordinate
  # Returns: none
  # Sideeffects: none
  ##########
  
  if {"[info commands $xfMenu]" != "" && [winfo ismapped $xfMenu]} {
    set xfPopMinX [winfo rootx $xfMenu]
    set xfPopMaxX [expr $xfPopMinX+[winfo width $xfMenu]]
    if {($xfX >= $xfPopMinX) &&  ($xfX <= $xfPopMaxX)} {
      $xfMenu activate @[expr $xfY-[winfo rooty $xfMenu]]
    } else {
      $xfMenu activate none
    }
  }
}

################################################################
####			 Utils                              ####
################################################################

########  lmember  ########

proc lmember {l elt} {
  return [expr "[lsearch -exact "$l" "$elt"] >= 0"]
}

proc getAccel {procName} {
  global theBindings

  set blist [split $theBindings "\n"]
  set i [lsearch -glob $blist "*$procName*"]
  if {$i < 0} { return "" }
  if {[catch {lindex [lindex $blist $i] 2} accel]} {
    return ""
  } else {
    return $accel
  }
}

proc isfpnum {s} {
  scan $s {%f} value
  if {$value == [string trim $s]} {
    return 1
  } else {
    warn "Floating point value required"
    return 0
  }
}

################################################################
####		  Text font management                      ####
################################################################

####  Get list of available fonts  ####
set FontList [split [exec xlsfonts] "\n"]

proc getFontName {name size weight slant} {
  global FontList

  set slant [string index $slant 0]
  set i [lsearch -glob $FontList "*$name-$weight-$slant-*--$size*"]
  if {$i < 0} {
    return ""
  } else {
    return [lindex $FontList $i]
  }
}

##  Finds a font name as close as possible of current  ##
##  requested field values (name, size, weight, slant)  ##
## Updates currentFont and current field values accordingly ##

proc setCurrentFont {args} {
  global theFNames theFSizes theFWeights theFSlants
  global currentFName currentFSize currentFWeight currentFSlant
  global currentFont

  set font [getFontName $currentFName $currentFSize $currentFWeight $currentFSlant]

  if {$font != ""} {
    set currentFont $font
    return
  }
  
  ##  Try to modify one of the field. args contains requested fields, so  ##
  ##  don't modify these  ##
  if {![lmember $args "name"] &&
  ($currentFName != "symbol") } {
    #  modify name  #
    foreach name $theFNames {
      if {($name == "symbol") ||
	($name == $currentFName)} { continue }
      set font [getFontName $name $currentFSize $currentFWeight $currentFSlant]
      if {$font != ""} {
	set currentFName $name
	set currentFont $font
	warn "Had to change font name to $name" 5000
	return
      }
    }
  }

  if {![lmember $args "size"]} {
    #  modify size, trying nearest sizes first  #
    set ssizes [lsort -command {nearestSize $currentFSize} $theFSizes]
    
    foreach size $ssizes {
      if {$size == $currentFSize} { continue }
      set font [getFontName $currentFName $size $currentFWeight $currentFSlant]
      if {$font != ""} {
	set currentFSize $size
	set currentFont $font
	warn "Had to change font size to $size" 5000
	return
      }
    }
  }

  if {![lmember $args "weight"]} {
    #  modify weight #
    
    foreach weight $theFWeights {
      if {$weight == $currentFWeight} { continue }
      set font [getFontName $currentFName $currentFSize $weight $currentFSlant]
      if {$font != ""} {
	set currentFWeight $weight
	set currentFont $font
	warn "Had to change font weight to $weight" 5000
	return
      }
    }
  }
  
  if {![lmember $args "slant"]} {
    #  modify slant #
    
    foreach slant $theFSlants {
      if {$slant == $currentFSlant} { continue }
      set font [getFontName $currentFName $currentFSize $currentFWeight $slant]
      if {$font != ""} {
	set currentFSlant $slant
	set currentFont $font
	warn "Had to change font slant to $slant" 5000
	return
      }
    }
  }

  warn "Couldn't find any appropriate font"
}

proc nearestSize {ref s1 s2} {
  return [expr "abs($ref-$s1) - abs($ref-$s2)"]
}


################################################################
####		     Symbolic Names                         ####
################################################################

# Procedure: SN
if {"[info procs SN]" == ""} {
  proc SN { {xfName ""}} {
    ##########
    # Procedure: SN
    # Description: map a symbolic name to the widget path
    # Arguments: xfName
    # Returns: the symbolic name
    # Sideeffects: none
    ##########
    
    SymbolicName $xfName
  }
}

# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
  proc SymbolicName { {xfName ""}} {
    # xf ignore me 7
    ##########
    # Procedure: SymbolicName
    # Description: map a symbolic name to the widget path
    # Arguments: xfName
    # Returns: the symbolic name
    # Sideeffects: none
    ##########
    
    global symbolicName
    
    if {"$xfName" != ""} {
      set xfArrayName ""
      append xfArrayName symbolicName ( $xfName )
      if {![catch "set \"$xfArrayName\"" xfValue]} {
	return $xfValue
      } {
	if {"[info commands XFProcError]" != ""} {
	  XFProcError "Unknown symbolic name:\n$xfName"
	} {
	  puts stderr "XF error: unknown symbolic name:\n$xfName"
	}
      }
    }
    return ""
  }
}

################################################################
####		      Warning area                          ####
################################################################

set lastMsg {}
set lastWarnMsg {}
set lastWarnBg  {}

proc warn {args} {
  global lastWarnMsg lastMsg

  # warn <text> [<timeout>] #

  # If there's already a warning, ignore this one #
  if {$lastWarnMsg == ""} {
    
    if {[llength $args] == 1} {
      set tm 5000
    } else {
      set tm [lindex $args 1]
    }
    
    set bg [lindex [.frame1 configure -background] 4]
    set lastMsg [lindex [.frame1.warnLb configure -text] 4]
    set lastWarnMsg [lindex $args 0]
    .frame1.warnLb configure \
      -text [lindex $args 0] \
      -background {#8ba3ce}
    
    update
    after $tm ".frame1.warnLb configure -background $bg -text [list $lastMsg]
               set lastWarnMsg \"\"
               update"
  }
}

proc saveMsg {} {
  global lastMsg lastWarnBg
  set lastMsg [lindex [.frame1.warnLb configure -text] 4]
  set lastWarnBg [lindex [.frame1 configure -background] 4]
}

proc restoreMsg {} {
  global lastMsg lastWarnBg

  .frame1.warnLb configure \
    -background $lastWarnBg \
    -text $lastMsg
}

proc msg {msg} {
  .frame1.warnLb configure \
    -text "$msg"
  update
}

################################################################
####		    Popup Text area                         ####
################################################################

set textBoxContent {}
set textBoxButton  {}

proc textBox {{label ""} {content ""} args} {
  global textBoxContent textBoxButton
  # args = list of buttons to create #

  catch {destroy .textBox}
  toplevel .textBox -borderwidth 0
  wm geometry .textBox 600x400 
  wm title .textBox {Text box}
  wm maxsize .textBox 1000 1000
  wm minsize .textBox 100 100

  label .textBox.message1  -anchor c  -relief raised \
    -text $label

  text .textBox.text

  .textBox.text insert 1.0 $content

  frame .textBox.buttonFr -borderwidth 0

  if {$args == 0} {
    set args {ok cancel}
  }

  foreach but $args {
    button .textBox.buttonFr.b${but}Bt \
      -text $but \
      -relief raised \
      -command "
	set textBoxContent  \[.textBox.text get 1.0 end\]
	set textBoxButton $but
        grab release .textBox
	destroy .textBox"

    pack append .textBox.buttonFr \
      .textBox.buttonFr.b${but}Bt {left fill expand}
  }

  pack append .textBox \
    .textBox.message1 {top fillx frame n pady 10} \
    .textBox.text     {top expand fill} \
    .textBox.buttonFr {top fill}

  update idletask
  grab set .textBox
  tkwait window .textBox
  grab release .textBox
  focus .
  return [list $textBoxButton $textBoxContent]
}

################################################################
####		    Bitmaps creation                        ####
################################################################

proc mkbitmap {args} {
  global PicassoLib bitmapPath

  #  args == <spec> <par1> ... <parn>  #
  # if file <spec>.<par1>. ... .<parn>.xbm exist, return it #
  #  otherwise build the bitmap  #

  if {[lempty $args]} { return "" }

  set name [join $args .]
  foreach dir $bitmapPath {
    if {[file readable "$dir/$name.xbm"]} {
      return "@$dir/$name.xbm"
    }
    if {[file readable "$dir/$name"]} {
      return "@$dir/$name"
    }
  }

  ##  Build the bitmap following specification  ##
  switch [lvarpop args] {

    set path2 [mkTmpFile $name.xbmt]
    width {
      set w [lindex $args 0]
      #  26x16 bitmap  #
      set bstr ""
      exec echo -n > $path2
      set blankline "[replicate "-" 26]\n"
      loop nl 0 [expr "(16-$w)/2"] {
	exec echo $blankline >> $path2
      }
      set blackline "--[replicate "#" 22]--\n"
      loop nl $nl [expr "$nl + $w"] {
	exec echo $blackline >> $path2
      }
      loop nl $nl 16 {
	exec echo $blankline >> $path2
      }

      set path [mkTmpFile $name.xbm]
      exec atobm $path2 > $path
      exec /bin/rm -f $path2
      return "@$path"
    }

    dashes {
      
      if {[lempty $args]} {
	puts stderr \
	"\nWARNING : couldn't find bitmap $name
  Check your PicassoLib environment variable
  and the directory \$PicassoLib/bitmaps\n"
	return "" }

      # 64x16 bitmap #
      set bstr ""
      set path2 [mkTmpFile $name.xbmt]
      set blankline "[replicate "-" 64]\n"
      loop nl 0 8 {
	exec echo "$bstr$blankline" >> $path2
      }
      set blackline ""
      set i 0
      set chars {# -}
      while {[string length $blackline] < 64} {
	set c [lindex $chars [expr "$i%2"]]
	set l [lindex $args  [expr "$i%[llength $args]"]]
	append blackline [replicate $c $l]
	incr i
      }
      exec echo [string range $blackline 0 63] >> $path2 
      incr nl
      loop nl $nl 16 {
	exec echo $blankline >> $path2
      }

      set path [mkTmpFile $name.xbm]
      exec atobm $path2 > $path
      exec /bin/rm -f $path2
      return "@$path"
    }
    
    default {
      puts stderr \
	"\nWARNING : couldn't find bitmap $name
  Check your PicassoLib environment variable
  and the directory \$PicassoLib/bitmaps\n"
      return "" }
  }      
}

#
#  Fitting a given text in a rectangle.
#    Choose a font as small as possible, and remove chars
#      from the end until we fit in the rectangle
#

proc fitTextInRect {id x1 y1 x2 y2} {

  set w [expr $x2 - $x1]
  set l [string length [lindex [[cv] itemconfigure $id -text] 4]]
  set text [lindex [[cv] itemconfigure $id -text] 4]
  
  ##  temporarily set the text anchor to nw  ##
  set oldAnchor \
    [lindex [[cv] itemconfigure $id -anchor] 4]

  [cv] itemconfigure $id \
    -anchor nw \
    -justify left \
    -font "*-medium-r-normal--6-*"

  #  arrange for the ul corner of bbox to be in the rect  #
  lassign [[cv] bbox $id] tx1 ty1
  [cv] move $id [expr $x1 - $tx1 + 1] [expr $y1 - $ty1 + 1]

  if {[fillTextInRect $id $text $x1 $y1 $x2 $y2] == 0} {
    set sz 6
    set lastSz 6
    set lastText [lindex [[cv] itemconfigure $id -text] 4]

    # try to increase the font size #
    while {$sz < 14} {
      
      incr sz
      if {[catch {[cv] itemconfigure $id \
	-font "*-medium-r-normal--${sz}-*"}]} {
	  continue
	}
      if {[fillTextInRect $id $text $x1 $y1 $x2 $y2] != 0} {
	[cv] itemconfigure $id \
	  -font "*-medium-r-normal--${lastSz}-*" \
	  -text $lastText
	break
      } else {
	set lastSz $sz
	set lastText [lindex [[cv] itemconfigure $id -text] 4]
      }
    }
  }

  ## reset text anchor and place the text ##
  global anchor2just
  [cv] itemconfigure $id -anchor $oldAnchor
  [cv] itemconfigure $id -justify [keylget anchor2just $oldAnchor]
  lassign [[cv] bbox $id] tx1 ty1 tx2 ty2

  #  Don't use coords cause what we wan't is to ensure  #
  #  that the text bbox is inside the rect.  #

  switch $oldAnchor {
    nw {
      [cv] move $id [expr $x1 - $tx1] [expr $y1 - $ty1]
    }
    w {
      [cv] move $id \
	[expr $x1 - $tx1] [expr ($y1 + $y2 - $ty1 - $ty2)/2]
    }
    sw {
      [cv] move $id \
	[expr $x1 - $tx1] [expr $y2 - $ty2]
    }
    n {
      [cv] move $id \
	[expr ($x1 + $x2 - $tx1 - $tx2)/2] [expr $y1 - $ty1]
    }
    center {
      [cv] move $id \
	[expr ($x1 + $x2 - $tx1 - $tx2)/2] [expr ($y1 + $y2 - $ty1 - $ty2)/2]
    }
    s {
      [cv] move $id \
	[expr ($x1 + $x2 - $tx1 - $tx2)/2] [expr $y2 - $ty2]
    }
    ne {
      [cv] move $id \
	[expr $x2 - $tx2] [expr $y1 - $ty1]
    }
    e {
      [cv] move $id \
	[expr $x2 - $tx2] [expr ($y1 + $y2 - $ty1 - $ty2)/2]
    }
    se {
      [cv] move $id \
	[expr $x2 - $tx2] [expr $y2 - $ty2]
    }
  }  
}

proc fillTextInRect {id text x1 y1 x2 y2} {
  #  insert as many chars as possible in the item  #
  # ul text corner must be positionned and #
  # anchor must ne nw #
  
  [cv] itemconfigure $id -text {}

  set pos 0
  set textl [string length $text]
  set len 0
  lassign [[cv] bbox $id] tx1 ty1 tx2 ty2

  while {($ty2 < $y2) && ($pos < $textl) } {
    while {($tx2 < $x2) && ($pos < $textl)} {
      [cv] insert $id end [string index $text $pos]
      incr len
      incr pos
      set tx2 [lindex [[cv] bbox $id] 2]
    }
    incr len -1
    incr pos -1
    [cv] dchars $id $len $len
    set tx2 [lindex [[cv] bbox $id] 2]
    [cv] insert $id end "\n"
    incr len
    set ty2 [lindex [[cv] bbox $id] 3]
  }

  incr len -1
  [cv] dchars $id $len $len

  return [expr $textl - $pos - 1]
}

