/* layout.c

   Takes a layout.data file which specifies which pairs of pages go
together (even-numbered page first) and creates a TeX file on standard
out which lays out the pages correctly.  Relies on the existence of
dvips.

   Rigidly assumes the format of each data statement is
   x y\n
   where x and y are integers and the first digit of x is at the left-
   most column.

   Written May 20, 1993 by Joel F. Klein

   Each page is rotated 90 degrees clockwise.
*/

#include <stdio.h>

void main() {
   FILE *data=fopen("./layout.data", "r");
   char line[80+1];
   char odd[8], even[8];
   int x,y;

   printf("\\nopagenumbers\n");

   while(!feof(data)) {
      fgets(line, 80, data);
      sscanf(line,"%d %d\n",&x,&y);
      sprintf(even, "p%d.ps", x);
      sprintf(odd,  "p%d.ps", y);
      /* even page */
      printf("\\special{psfile=\"%s\" voffset=-720 hoffset=-72}\n", even);

      /* odd page */
      printf("\\special{psfile=\"%s\" voffset=-1116 hoffset=-72}\n", odd);

      /* new sheet */
      printf("\\ \n\\vfill\n\\eject\n");   /* force pagebreak by inserting 
					     a space */
   }

   printf("\\end\n");

   fclose(data);
}
