/*
 *	isdn.h - declarations for Linux ISDN driver
 *
 *	Copyright (c) 1993
 *		Tilo Schuerer <tilo@cs.tu-berlin.de>
 *		Michael Riepe <riepe@ifwsn4.ifw.uni-hannover.de>
 *		Henrik Hempelmann <marsu@palumbia.in-berlin.de>
 *
 *	Parts of this code were derived from Diehl's original MS-DOS loader
 *	which is Copyright (c) Diehl Elektronik GmbH 1988-1991.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef __ISDN_H__
#define __ISDN_H__

/* -------------- Config section -----------------------------------*/

#define MAJOR_NR	29	/* Major-device number for ISDN-device */

#define ISDN_IRQ	10	/* IRQ of ISDN-card                 */
#define ISDN_ADR	0xe0000	/* start of shared memory of card   */

#define DEF_OAD		4	/* default Origination Address      */

#define N_ISDN_B	2	/* Number of B-Channels             */
#define N_SUB_CHAN	8	/* Number of sub B-Channels         */

/*------------------------------------------------------------------*/
/* command-elements for ioctl()                                     */
/*------------------------------------------------------------------*/

#define ISDN_LOAD 1         /* Load OS to ISDN-Board                */    
#define D3_CONN_REQ 2       /* D-Channel Layer 3 Connect Request    */
#define D3_DISC_REQ 3       /* D-Channel Layer 3 Disconnect Request */
#define B2_CONN_REQ 4       /* B-Channel Layer 2 Connect Request    */
#define B2_DISC_REQ 5       /* B-Channel Layer 2 Disconnect Request */
#define D3_LISTEN_REQ 6     /* Wait for incoming call and accept    */
#define NUMBER 7	    /* Called Party Number                  */
#define SET_OAD    8	    /* Origination Address                  */
#define GET_PARAMETER  9    /* Get Indication Parameter             */
#define D3_IND_REQ	10  /* Wait for incoming call               */
#define D3_ACCEPT_CALL	11  /* Accept incoming call                 */    
#define D3_REJECT_CALL	12  /* Reject incoming call                 */

/* for debugging */

#define SET_DEBUG 17
#define CLEAR_DEBUG 18

/*------------------------------------------------------------------*/
/* Debug-level                                                      */
/*------------------------------------------------------------------*/

#define DEBUG_ALL	255		/* ALL                      */
#define DEBUG_LOSS	128		/* lost indication          */
#define DEBUG_FYI	64		/* FYI                      */
#define DEBUG_STAT	32		/* status                   */
#define DEBUG_FUNC	16		/* each function entry      */
#define DEBUG_IO	8		/* read/write               */
#define DEBUG_INFO	4		/* info indication          */
#define DEBUG_INT	2		/* interupts                */
#define DEBUG_ERR	1		/* errors                   */
#define NO_DEBUG	0		/* silent !                 */

/*------------------------------------------------------------------*/
/* data definitions                                                 */
/*------------------------------------------------------------------*/

#define BLOCKSIZE 256           /* Size of blocks while downloading */
#define TIME_OUT 10             /* Timeout for any loops 0.1s       */
#define PACKET_LENGTH 270       /* Size of blocks while reading or  */
                                /* writing on B-channel             */

/*------------------------------------------------------------------*/
/* more definitions from Diehl                                      */
/*------------------------------------------------------------------*/

#define TRUE 1
#define FALSE 0
#define MIN(a,b) ((a)>(b) ? (b) : (a))

/*------------------------------------------------------------------*/
/* Id Fields Coding                                                 */
/*------------------------------------------------------------------*/

#define ID_MASK 0xe0    /* Mask for the ID field                    */
#define GL_ERR_ID 0x1f  /* ID for error reporting on global requests*/

#define DSIG_ID  0x00   /* ID for D-channel signaling               */
#define NL_ID    0x20   /* ID for network-layer access (B or D)     */
#define BLLC_ID  0x60   /* ID for B-channel link level access       */
#define TASK_ID  0x80   /* ID for dynamic user tasks                */
#define TIMER_ID 0xa0   /* ID for timer task                        */
#define TEL_ID   0xc0   /* ID for telephone support                 */

/*------------------------------------------------------------------*/
/* ASSIGN and REMOVE requests are the same for all entities         */
/*------------------------------------------------------------------*/

#define ASSIGN  0x01
#define REMOVE  0xff

/*------------------------------------------------------------------*/
/* Timer Interrupt Task Interface                                   */
/*------------------------------------------------------------------*/

#define ASSIGN_TIM 0x01
#define REMOVE_TIM 0xff

/*------------------------------------------------------------------*/
/* dynamic user task interface                                      */
/*------------------------------------------------------------------*/

#define ASSIGN_TSK 0x01
#define REMOVE_TSK 0xff

#define LOAD 0xf0
#define RELOCATE 0xf1
#define START 0xf2

/*------------------------------------------------------------------*/
/* dynamic user task messages                                       */
/*------------------------------------------------------------------*/

#define TSK_B2          0x0000
#define TSK_WAKEUP      0x2000
#define TSK_TIMER       0x4000
#define TSK_TSK         0x6000
#define TSK_PC          0xe000

/*------------------------------------------------------------------*/
/* LL management primitives                                         */
/*------------------------------------------------------------------*/

#define ASSIGN_LL 1     /* assign logical link                      */
#define REMOVE_LL 0xff  /* remove logical link                      */

/*------------------------------------------------------------------*/
/* LL service primitives                                            */
/*------------------------------------------------------------------*/

#define LL_UDATA 1      /* link unit data request/indication        */
#define LL_ESTABLISH 2  /* link establish request/indication        */
#define LL_RELEASE 3    /* link release request/indication          */
#define LL_DATA 4       /* data request/indication                  */
#define LL_LOCAL 5      /* switch to local operation (COM only)     */
#define LL_REMOTE 6     /* switch to remote operation (COM only)    */
#define LL_TEST 8       /* link test request                        */
#define LL_MDATA 9      /* more data request/indication             */
#define LL_BUDATA 10    /* broadcast unit data request/indication   */

/*------------------------------------------------------------------*/
/* NL service primitives                                            */
/*------------------------------------------------------------------*/

#define N_MDATA         1       /* more data to come REQ/IND        */
#define N_CONNECT       2       /* OSI N-CONNECT REQ/IND            */
#define N_CONNECT_ACK   3       /* OSI N-CONNECT CON/RES            */
#define N_DISC          4       /* OSI N-DISC REQ/IND               */
#define N_DISC_ACK      5       /* OSI N-DISC CON/RES               */
#define N_RESET         6       /* OSI N-RESET REQ/IND              */
#define N_RESET_ACK     7       /* OSI N-RESET CON/RES              */
#define N_DATA          8       /* OSI N-DATA REQ/IND               */
#define N_EDATA         9       /* OSI N-EXPEDITED DATA REQ/IND     */
#define N_UDATA         10      /* OSI D-UNIT-DATA REQ/IND          */
#define N_BDATA         11      /* BROADCAST-DATA REQ/IND           */

/*------------------------------------------------------------------*/
/* Signaling management primitives                                  */
/*------------------------------------------------------------------*/

#define ASSIGN_SIG 1    /* assign signaling task                    */
#define REMOVE_SIG 0xff /* remove signaling task                    */

/*------------------------------------------------------------------*/
/* Signaling service primitives                                     */
/*------------------------------------------------------------------*/

#define CALL_REQ 1      /* call request                             */
#define CALL_CON 1      /* call confirmation                        */
#define CALL_IND 2      /* incoming call connected                  */
#define LISTEN_REQ 2    /* listen request                           */
#define HANGUP 3        /* hangup request/indication                */
#define SUSPEND 4       /* call suspend request/confirm             */
#define RESUME 5        /* call resume request/confirm              */
#define SUSPEND_REJ 6   /* suspend rejected indication              */
#define USER_DATA 8     /* user data for user to user signaling     */
#define CONGESTION 9    /* network congestion indication            */
#define INDICATE_REQ 10 /* request to indicate an incoming call     */
#define INDICATE_IND 10 /* indicates that there is an incoming call */
#define CALL_RES 11     /* accept an incoming call                  */
#define CALL_ALERT 12   /* send ALERT for incoming call             */
#define INFO_IND 13     /* INFO indication                          */
#define REJECT 14       /* reject an incoming call                  */
#define RESOURCES 15    /* reserve B-Channel hardware resources     */
#define TEL_CTRL 16     /* Telephone control request/indication     */
#define STATUS_REQ 17   /* Request D-State (returned in INFO_IND)   */

/*------------------------------------------------------------------*/
/* return code coding                                               */
/*------------------------------------------------------------------*/

#define UNKNOWN_COMMAND         0x01    /* unknown command          */
#define WRONG_COMMAND           0x02    /* wrong command            */
#define WRONG_ID                0x03    /* unknown task/entity id   */
#define WRONG_CH                0x04    /* wrong task/entity id     */
#define UNKNOWN_IE              0x05    /* unknown information el.  */
#define WRONG_IE                0x06    /* wrong information el.    */
#define OUT_OF_RESOURCES        0x07    /* ISDN-S card out of res.  */
#define N_FLOW_CONTROL          0x10    /* Flow-Control, retry      */
#define ASSIGN_RC               0xe0    /* ASSIGN acknowledgement   */
#define ASSIGN_OK               0xef    /* ASSIGN OK                */
#define READY_INT               0xfd    /* Ready interrupt          */
#define TIMER_INT               0xfe    /* timer interrupt          */
#define OK                      0xff    /* command accepted         */

/*------------------------------------------------------------------*/
/* information elements                                             */
/*------------------------------------------------------------------*/

#define SHIFT 0x90              /* codeset shift                    */
#define MORE 0xa0               /* more data                        */
#define CL 0xb0                 /* congestion level                 */

/* codeset 0                                                        */

#define BC  0x04                /* Bearer Capability                */
#define CAU 0x08                /* cause                            */
#define CAD 0x0c                /* Connected address                */
#define CAI 0x10                /* call identity                    */
#define CHI 0x18                /* channel identification           */
#define LLI 0x19                /* logical link id                  */
#define KEY 0x2c                /* keypad information element       */
#define DSP 0x28                /* display                          */
#define OAD 0x6c                /* origination address              */
#define OSA 0x6d                /* origination sub-address          */
#define CPN 0x70                /* called party number              */
#define DSA 0x71                /* destination sub-address          */
#define LLC 0x7c                /* low layer compatibility          */
#define HLC 0x7d                /* high layer compatibility         */
#define UUI 0x7e                /* user user information            */
#define ESC 0x7f                /* escape extension                 */

#define DLC 0x20                /* data link layer configuration    */
#define NLC 0x21                /* network layer configuration      */

/* codeset 6                                                        */

#define SIN 0x01                /* service indicator                */
#define CIF 0x02                /* charging information             */
#define DATE 0x03               /* date                             */
#define CPS 0x07                /* called party status              */

/*------------------------------------------------------------------*/
/* TEL_CTRL contents                                                */
/*------------------------------------------------------------------*/

#define RING_ON         0x01
#define RING_OFF        0x02
#define HANDS_FREE_ON   0x03
#define HANDS_FREE_OFF  0x04
#define ON_HOOK         0x80
#define OFF_HOOK        0x90


/*------------------------------------------------------------------*/
/* dnload-buffer definition                                         */
/*------------------------------------------------------------------*/

struct isdn_load_req 
{
	int len;                         /* length of parameter-buffer */
	unsigned char *data;   /* pointer to buffer (in user space!!!) */
};

/*------------------------------------------------------------------*/
/* Debug macro for printk                                           */
/*------------------------------------------------------------------*/

#define PRINTD(level, format, args...) \
	do { if (level & d_level) printk(format,## args); } while (0)

#endif	/* __ISDN_H__ */
