/*
 *	ind_parms.h - isdn-indication datastracture declarations
 *
 *	Copyright (c) 1993
 *		Tilo Schuerer <tilo@cs.tu-berlin.de>
 *		Michael Riepe <riepe@ifwsn4.ifw.uni-hannover.de>
 *		Henrik Hempelmann <marsu@palumbia.in-berlin.de>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef __IND_PARMS_H__
#define __IND_PARMS_H__

/*------------------------------------------------------------------*/
/*               Parameter Field                                    */
/*------------------------------------------------------------------*/
 
struct bc_data {		/* Bearer Capability                */
	u_char length;
	u_char data[7];
	};

struct cai_data {		/* call identity                    */
	u_char length;
	u_char data[7];
	};

struct cad_data {		/* Connected address                */
	u_char length;
	u_char data[31];
	};

struct cau_data {		/* cause                            */
	u_char length;
	u_char data[3];
	};

struct chi_data {		/* channel identification           */
	u_char length;
	u_char data;
	};

struct cif_data {		/* charging information             */
	u_char length;
	u_char data[15];
	};

struct cl_data {		/* congestion level                 */
	u_char length;
	u_char data[1];
	};

struct cpn_data {		/* called party number              */
	u_char length;
	u_char data[31];
	};

struct cps_data {		/* called party status              */
	u_char length;
	u_char data[1];
	};

struct date_data {		/* date                             */
	u_char length;
	u_char data[15];
	};
	
struct dsa_data {		/* destination sub-address          */
	u_char length;
	u_char data[31];
	};
	
struct esccau_data{		/* escape extension: cause          */
	u_char length;
	u_char data[3];
	};
	
struct escstat_data{		/* escape extension: statistics     */
	u_char length;
	u_char data[44];
	};
	
struct hlc_data {		/* high layer compatibility         */
	u_char length;
	u_char data[7];
	};
	
struct llc_data {		/* low layer compatibility          */
	u_char length;
	u_char data[7];
	};
		
struct oad_data {		/* origination address              */
	u_char length;
	u_char data[31];
	};
	
struct osa_data {		/* origination sub-address          */
	u_char length;
	u_char data[31];
	};
	
struct sin_data {		/* service indicator                */
	u_char length;
	u_char data[2];
	};
	
struct uui_data {		/* user user information            */
	u_char length;
	u_char data[127];
	};
	
struct info_data {
	struct bc_data 		bc;
	struct cai_data 	cai;
	struct cad_data 	cad;
	struct cau_data 	cau;
	struct chi_data 	chi;
	struct cif_data 	cif;
	struct cl_data		cl;
	struct cpn_data		cpn;
	struct cps_data		cps;
	struct date_data	date;
	struct dsa_data		dsa;
	struct esccau_data	esccau;
	struct escstat_data	escstat;
	struct hlc_data		hlc;
	struct llc_data		llc;
	struct oad_data		oad;
	struct osa_data		osa;
	struct sin_data		sin;
	struct uui_data		uui;
};

#endif	/* __IND_PARMS_H__ */
