/*
 *	diehl.h - low-level driver declarations
 *
 *	Copyright (c) 1993
 *		Tilo Schuerer <tilo@cs.tu-berlin.de>
 *		Michael Riepe <riepe@ifwsn4.ifw.uni-hannover.de>
 *		Henrik Hempelmann <marsu@palumbia.in-berlin.de>
 *
 *	Parts of this code were derived from Diehl's original MS-DOS loader
 *	which is Copyright (c) Diehl Elektronik GmbH 1988-1991.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef __DIEHL_H__
#define __DIEHL_H__

#include <linux/ind_parms.h>

#define NR_ISDN		(1)              /* Number of ISDN-Cards */
#define MAX_BACKLOG	(10)
#define MAXNUMLEN (15)                      /* length of tel-number */

#define SIGNATURE	0x4447

/*
 * hardware interface
 */

typedef struct {
	u_short	length;			/* length of data/parameter field			*/
	u_char	P[270];			/* data/parameter field						*/
} PBUFFER;

struct dual {
	u_char	Req;			/* request register				*/
	u_char	ReqId;			/* request task/entity identification		*/
	u_char	Rc;			/* return code register				*/
	u_char	RcId;			/* return code task/entity identification	*/
	u_char	Ind;			/* Indication register				*/
	u_char	IndId;			/* Indication task/entity identification	*/
	u_char	IMask;			/* Interrupt Mask Flag				*/
	u_char	RNR;			/* Receiver Not Ready (set by PC)		*/
	u_char	XLock;			/* XBuffer locked Flag				*/
	u_char	Int;			/* ISDN-S interrupt				*/
	u_char	ReqCh;			/* Channel field for layer-3 Requests		*/
	u_char	RcCh;			/* Channel field for layer-3 Returncodes	*/
	u_char	IndCh;			/* Channel field for layer-3 Indications	*/
	u_char	MInd;			/* more data indication field			*/
	u_short	MLength;		/* more data total packet length		*/
	u_char	ReadyInt;		/* request field for ready interrupt		*/
	u_char	Reserved[13];		/* reserved space				*/
	u_short	Signature;		/* ISDN-S adapter Signature (GD)		*/
	PBUFFER	XBuffer;		/* Transmit Buffer				*/
	PBUFFER	RBuffer;		/* Receive Buffer				*/
};

union dram {
	u_char	c[1024];
	struct {
		u_char	ctrl;
		u_char	card;
		u_char	msize;
		u_char	fill0;
		u_short	ebit;
		u_char	eloc[4];				/* due to alignment problems */
		u_char	reserved[20];
		u_short	signature;
		u_char	fill[224];
		struct buf 
		{
			u_char	b[256];
		} b;
	} load;
};

/*
 * communication buffer
 */

struct isdn_buf {
	struct isdn_buf*	next;			/* chaining */
	struct isdn_buf*	prev;
	struct wait_queue*	wait;			/* wait queue for requests */
	u_char*		data;					/* pointer to data portion */
	u_short		data_len;				/* length of data portion */
	u_short		buf_len;				/* length of this buffer (for kfree_s) */
	u_char		rri_code;				/* request/return/indication code */
	u_char		rri_id;					/* request/return/indication id */
	u_char		rri_ch;					/* request/return/indication channel */
	u_char		pad[1];					/* padding */
};


/*
 * device structure
 */

struct isdn_dev {
	/* common part */
	struct isdn_dev*	next;			/* next device */
	struct wait_queue*	wait;			/* wait queue for sleeping */
	struct isdn_buf*	buffers;		/* buffers for pending requests */
	struct isdn_buf*	assign;			/* buffers for pending assign(s) */
	u_long	shm_addr;					/* shared memory offset */
	int		irq;						/* IRQ used */
	int		(*irq_handler)(struct isdn_dev*);
	int		(*init)(struct isdn_dev*);	/* called once at boot time */
	int		(*loados)(struct isdn_dev*, u_char*, int);
	int		(*send)(struct isdn_dev*, struct isdn_buf*);
	int		timeout;					/* request-wait timeout */
	u_int	present : 1;				/* device is present (set by init) */
	u_int	running : 1;				/* device is running (set by loados) */

	int		num_channels;
	struct channel {
		struct wait_queue	*ind_wait;	/* wait queue for indications*/
		struct isdn_buf		*backlog;	/* buffered indication data */
		struct info_data	info;		/* parameter field */
		u_int		backlog_size;
		u_int		inuse;
		u_int		D3_conn : 1;
		u_int		B2_conn : 1;
		u_char	D3_Id;
		u_char	B2_Id;
		u_char	oad;
		u_short	numlen;
		u_char	number[MAXNUMLEN];
	}		*channels;

	/* special parameters for Diehl cards */
	u_long	software_id;				/* set by loados */
	u_char	card;						/* card type (0..3), set by init */

	/* start-up parameters for Diehl cards */
	u_char	tei;
	u_char	nt2;
	u_char	watchdog;
	u_char	permanent;
	u_char	xinterface;
	u_char	stablel2;
	u_char	noordercheck;
	u_char	oad[32];
	u_char	osa[32];
	u_char	spid[20];
};

extern struct isdn_dev isdn_devices[NR_ISDN];

#endif	/* __DIEHL_H__ */
