# This program will construct ksyms.s.  Ksyms.s contains a symbol table
# for all the kernel symbols included in the file ksyms.lst.  The following
# variables are defined in ksym.s:
#
#	int dscsi_mod_symbol_table_size;		/* number of symbols */
#	struct {
#		void *value;		/* value of symbol */
#		char *name;		/* name of symbol */
#	} dscsi_mod_symbol_table[];
#
#

trap "rm -f ssyms.tmp ssyms.lst" 0 1 2 

sed -e '/^#/d' -e '/^[	 ]*$/d' ssyms.lst | sort > ssyms.tmp

echo '	.data
	.globl	_dscsi_mod_symbol_table_size, _dscsi_mod_symbol_table

_dscsi_mod_symbol_table_size:'
echo "	.long" `wc -l < ssyms.tmp`
echo '
_dscsi_mod_symbol_table:'
awk 'BEGIN {stringloc = 0}
{print "	.long " $1; print "	.long strings+" stringloc; \
        stringloc += length($1) + 1;}' ssyms.tmp
echo '
strings:'
awk '{print "	.ascii \"" $1 "\\0\""}' ssyms.tmp



#
# Alternativly, if the kernel is c++ compiled:
# By using gsub() we can forse all function names to appear as extern "C".
# This allows linkable drivers written in C or C++ - Jon
# awk '{gsub(/__F.*/, "") ; print "	.ascii \"" $0 "\\0\""}' ssyms.tmp
