   #include <stdio.h>
   #ifdef __STDC__
   #include <stdlib.h>
   #endif
   #include <string.h>
   /*
    * linux/drivers/block/pred.c 
    * program for Dave Rand's rendition of the predictor algorithm
    * Modified for Linux compression driver by: 
    * <jmv@receptor.MGH.harvard.edu> (Jean-Marc Verbavatz)
    * Updated by: iand@labtam.labtam.oz.au (Ian Donaldson)
    * Updated by: Carsten Bormann <cabo@cs.tu-berlin.de>
    * Original  : Dave Rand <dlr@bungi.com>/<dave_rand@novell.com>
    */

   /* The following hash code is the heart of the algorithm:
    * It builds a sliding hash sum of the previous 3-and-a-bit characters
    * which will be used to index the guess table.
    * A better hash function would result in additional compression,
    * at the expense of time.
    */
   #define TableSize 16384
   #define HASH(x) Hash = ((Hash << 7) ^ (x))&(TableSize-1)

   static unsigned short int Hash;
   static unsigned char *GuessTable;

   int ipred(void *mem_start)
   {
      GuessTable = (unsigned char *) mem_start;
      return TableSize;
   }

   void wpred(unsigned char *source, int len, unsigned char *dest, int *maxlen)
   {
       int bit;
       unsigned char *flagdest, *orgdest, *maxdest, *p;
       register unsigned char flags;

       memset(GuessTable, 0, TableSize);
       orgdest = dest;
       maxdest = dest+*maxlen;
       Hash = 0;
       while (dest < maxdest) {
           flagdest = dest++;   /* All guess wrong initially */
	   bit = 1;
	   flags = 0;
       begin_wloop:
	   p = GuessTable + Hash;
	   if(*p == *source) flags |= bit;	/* Guess was right */
	   else {				/* Guess was wrong */
		*p = *source;
		*dest++ = *source;
	   }
           HASH(*source++);
	   if(! --len) goto w_done;
           bit <<= 1;
	   if(bit != 0x100) goto begin_wloop;
           *flagdest = flags;
       }
       w_done:
       if(len || dest > maxdest) *maxlen =0;
       else *maxlen = (dest - orgdest);
   }

   void rpred(unsigned char *source, unsigned char *dest, int len)
   {
       int bit;
       register unsigned char flags;

       memset(GuessTable, 0, TableSize);
       Hash = 0;
       for(;;) {
           flags = *source++;
	   bit = 1;
       begin_rloop:	
           if (flags & bit)
              *dest = GuessTable[Hash];       /* Guess correct */
           else {
               GuessTable[Hash] = *source;     /* Guess wrong */
               *dest = *source++;              /* Read from source */
           }
           HASH(*dest++);
           if(! --len) return;
           bit <<= 1;
	   if(bit != 0x100) goto begin_rloop;
       }
   }
