/* external VGAlib functions */
/* Placed out of vga.c to save binary space when not used */

#include <stdlib.h>
#include "vga.h"


static char *modename[] = {
	"",
	"G320x200x16",
	"G640x200x16",
	"G640x350x16",
	"G640x480x16",
	"G320x200x256",
	"G320x240x256",
	"G320x400x256",
	"G360x480x256",
	"G640x480x2",
	"G640x480x256",
	"G800x600x256",
	"G1024x768x256",
	"G320x200x32K",
	"G320x200x64K",
	"G320x200x16M",
	"G640x480x32K",
	"G640x480x64K",
	"G640x480x16M",
	"G800x600x32K",
	"G800x600x64K",
	"G800x600x16M",
	"G1024x768x32K",
	"G1024x768x64K",
	"G1024x768x16M",
	"G1280x1024x256",
	"G1280x1024x32K",
	"G1280x1024x64K",
	"G1280x1024x16M",
	"G720x350x16",
	"G720x480x16"
};

int vga_getmodenumber( char *m ) {
	int i;
	char s[3];
	for (i = G320x200x16; i <= GLASTMODE; i++) {
		if (strcmp(m, modename[i]) == 0)	/* check name */
			return i;
		sprintf(s, "%d", i);
		if (strcmp(m, s) == 0)			/* check number */
			return i;
	}
	if (strcmp(m, "PROMPT") == 0)
		return -1;
	printf("Invalid graphics mode name.\n");
	return -1;
}

char *vga_getmodename( int m ) {
	return modename[m];
}

int vga_getdefaultmode() {
	char *e;
	int m;
	e = getenv("GSVGAMODE");
	if (e != NULL && strcmp(e, "") != 0) {
		m = vga_getmodenumber(e);
		if (m != -1)
			return m;
	}
	return -1;
}
