/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"

int vga_drawscanline(int line, unsigned char* colors)
{
    if (__vga_cur_mode == G640x480x2)
	return vga_drawscansegment(colors, 0, line, __vga_cur_info.xbytes);
    else
	return vga_drawscansegment(colors, 0, line, __vga_cur_info.xdim);
}

/* used to decompose color value into bits (for fast scanline drawing) */
union bits {
    struct {
        unsigned char bit3;
        unsigned char bit2;
        unsigned char bit1;
        unsigned char bit0;
    } b;
    unsigned int i;
};

/* color decompositions */
static union bits color16[16] = {{0,0,0,0},
			         {0,0,0,1},
			      	 {0,0,1,0},
			         {0,0,1,1},
			         {0,1,0,0},
			         {0,1,0,1},
			         {0,1,1,0},
			         {0,1,1,1},
			         {1,0,0,0},
			         {1,0,0,1},
			         {1,0,1,0},
			         {1,0,1,1},
			         {1,1,0,0},
			         {1,1,0,1},
			         {1,1,1,0},
			         {1,1,1,1}};

/* display plane buffers (for fast scanline drawing) */
static unsigned char plane0[256];
static unsigned char plane1[256];
static unsigned char plane2[256];
static unsigned char plane3[256];


int vga_drawscansegment(unsigned char* colors, int x, int y, int length)
{
    /* both length and x must divide with 8 */

    switch (__vga_cur_mode) {
        case G640x480x2:
/*      case G800x600x2: */
/*      case G1024x768x2: not ready yet */
	    {
		/* disable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x00, GRA_D ); 

		/* write to all bits */
	        port_out(0x08, GRA_I ); 
    		port_out(0xFF, GRA_D );   

		/* write to all planes */
	    	port_out(0x02, SEQ_I ); 
    		port_out(0x0F, SEQ_D ); 

		memcpy(graph_mem + (y*__vga_cur_info.xdim+x)/8, colors, length);
	
                /* restore map mask register */
    		port_out(0x0F, SEQ_D ); 
  
		/* enable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x0F, GRA_D );   
            }
            break;
	case G320x200x16:
	case G640x200x16:
	case G640x350x16:
	case G640x480x16:
	case G720x350x16:
	case G720x480x16:
	    {
       		int i, j, k, first, last;
		union bits bytes;
                unsigned char* address;

                k = 0;
                for(i = 0; i < length; i += 8) {
                    bytes.i = 0;
                    first = i;
                    last  = i+8;
                    for(j = first; j < last; j++)
                       bytes.i = (bytes.i<<1) | color16[colors[j]].i;
		    plane0[k]   = bytes.b.bit0;
		    plane1[k]   = bytes.b.bit1;
		    plane2[k]   = bytes.b.bit2;
		    plane3[k++] = bytes.b.bit3;
                }

                address = graph_mem + (y*__vga_cur_info.xdim+x)/8;

		/* disable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x00, GRA_D ); 

		/* write to all bits */
	        port_out(0x08, GRA_I ); 
    		port_out(0xFF, GRA_D );   

		/* select map mask register */
	    	port_out(0x02, SEQ_I ); 

                /* write plane 0 */
    		port_out(0x01, SEQ_D ); 
	        memcpy(address, plane0, length/8);

                /* write plane 1 */
    		port_out(0x02, SEQ_D ); 
	        memcpy(address, plane1, length/8);

                /* write plane 2 */
    		port_out(0x04, SEQ_D ); 
	        memcpy(address, plane2, length/8);

                /* write plane 3 */
    		port_out(0x08, SEQ_D ); 
	        memcpy(address, plane3, length/8);

                /* restore map mask register */
    		port_out(0x0F, SEQ_D ); 
  
		/* enable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x0F, GRA_D );   
            }
            break;
	case G320x200x256:
            /* linear addressing - easy and fast */
	    memcpy(graph_mem + y*__vga_cur_info.xdim+x, colors, length);
            break;
	case G320x240x256:
	case G320x400x256:
	case G360x480x256: 
            {
                int first, last, offset, pixel, plane;

	        /* select map mask register */ 
	        port_out(0x02, SEQ_I); 

                for(plane = 0; plane < 4; plane++) {
                    /* select plane */
    	            port_out(1 << plane, SEQ_D);   

                    pixel = plane;
                    first = (y*__vga_cur_info.xdim+x)/4;
                    last  = (y*__vga_cur_info.xdim+x+length)/4;
                    for(offset = first; offset < last; offset++) {
		        graph_mem[offset] = colors[pixel];  
                        pixel += 4;
                    }
	        }
            }
            break;
	case G320x200x32K  :
	case G640x480x32K  :
	case G800x600x32K  :
	case G1024x768x32K :
	case G1280x1024x32K:
	case G320x200x64K  :
	case G640x480x64K  :
	case G800x600x64K  :
	case G1024x768x64K :
	case G1280x1024x64K:
	case G320x200x16M  :
	case G640x480x16M  :
	case G800x600x16M  :
	case G1024x768x16M :
	case G1280x1024x16M:
		/* quick hack */
        	if (__vga_cur_info.colors == 1<<24)
        		x *= 4;
        	else
        		x *= 2;
	case G640x480x256  :
	case G800x600x256  :
	case G1024x768x256 :
	case G1280x1024x256:
	    {
		unsigned long offset;
		int segment, free;

		offset  = y*__vga_cur_info.xbytes+x; 
		segment = offset >> 16;
		free	= ((segment+1)<<16)-offset;

		if (free < length) {
			vga_setpage(segment);
		    memcpy(graph_mem + (offset & 0xFFFF), colors, free);
   		    	vga_setpage(segment + 1);
		    memcpy(graph_mem, colors+free, length-free);
		} else {
			vga_setpage(segment);
		    memcpy(graph_mem + (offset & 0xFFFF), colors, length);
		}

	    }
            break;
    }
        
    return 0;
}

