/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "vgamacros.h"
#include "chipsets.h"


int vga_clear()
{
    int i, j;
    int pages = 0;

    vga_screenoff();

    switch (__vga_cur_mode) {
    	case G320x200x256 :
        case G320x240x256 :
	case G320x400x256 :
	case G360x480x256 :
            /* write to all planes */ 
            port_out(0x02, SEQ_I ); 
            port_out(0x0F, SEQ_D );
   
    	    /* clear video memory */
    	    memset(graph_mem, 0, 65536);
            break;
	default:
	    switch (__vga_cur_info.colors) {
      		case  2 :
      		case 16 :
	            vga_setcolor(0);

		    /* write to all bits */
	    	    port_out(0x08, GRA_I ); 
        	    port_out(0xFF, GRA_D );

	    	    /* write dummy values to clear video memory */
		    memset(graph_mem, 0, 65536);
	            break;
      		default : 
      		    pages = (__vga_cur_info.ydim * __vga_cur_info.xbytes +
      		    	65535) >> 16;
	            for (i = 0; i < pages; ++i) {
                        vga_setpage(i);
    	                /* clear video memory */
    	                memset(graph_mem, 0, 65536);
    	            }
    	            break;
            }
            break;
    }

    vga_setcolor(15);
        
    vga_screenon();

    return 0;
}

