
#include <stdlib.h>
#include <stdio.h>
#include <vga.h>

#define REGS 100

unsigned char regs[REGS];

void main( int argc, char *argv[]) {
	if (argc == 1) {
		printf("Save/restore textmode registers.\n");
		printf("Syntax: restoretextmode option filename\n");
		printf("	-r filename	Restore registers from file.\n");
		printf("	-w filename	Write registers to file.\n");
		exit(0);
	}
	if (argv[1][0] != '-') {
		printf("Must specify -r or -w.\n");
		exit(1);
	}
	switch (argv[1][1]) {
		case 'r' :
		case 'w' :
			if (argc != 3) {
				printf("Must specify filename.\n");
				exit(1);
			}
			break;
		default :
			printf("Invalid option. Must specify -r or -w.\n");
			exit(1);
	}
	if (argv[1][1] == 'r') {
		FILE *f;
		f = fopen(argv[2], "rb");
		if (f == NULL) {
			printf("Invalid filename.\n");
			exit(1);
		}
		fread(regs, REGS, 1, f);
		fclose(f);
	}
	vga_setmode(G640x480x16);
	switch (argv[1][1]) {
	case 'r' :
		vga_settextmoderegs(regs);
		break;
	case 'w' :
		vga_gettextmoderegs(regs);
		break;
	}
	vga_setmode(TEXT);
	if (argv[1][1] == 'w') {
		FILE *f;
		f = fopen(argv[2], "wb");
		fwrite(regs, REGS, 1, f);
		fclose(f);
	}
	exit(0);
}
