/* Framebuffer Graphics Libary for Linux, Copyright 1993 Harm Hanemaayer */
/* scale.c	Scaling routine */


#include <stdlib.h>
#include <vga.h>
#include "inlstring.h"		/* include inline string operations */

#include "vgagl.h"
#include "def.h"



void gl_scalebox( int w1, int h1, void *_dp1, int w2, int h2, void *_dp2 ) {
	uchar *dp1 = _dp1;
	uchar *dp2 = _dp2;
	short int *scale_tablex = alloca(w1 * sizeof(short int));
    	short int *scale_tabley = alloca(h1 * sizeof(short int));
    	unsigned wfactor;
    	unsigned wround;
    	unsigned hfactor;
    	unsigned hround;
    
    	if ((w2 == 0) || (h2 == 0)) return;

    	if (w2 < w1) {			/* calculate x scale factor */
		wfactor = (w2 << 16) / w1;
		wround = 0;
	}
	else
        	if (w2 > w1) {
        		wround = w2 / w1;
        		wfactor = ((w2 % w1) << 16) / w1;
        	}
        	else {
        		wfactor = 0;
        		wround = 1;
        	} 
    	if (h2 < h1) {			/* calculate y scale factor */
        	hfactor = (h2 << 16) / h1;
        	hround = 0;
        }
	else
        	if (h2 > h1) {
        		hround = h2 / h1;
        		hfactor = ((h2 % h1) << 16) / h1;
        	}
        	else {
            		hfactor = 0;
            		hround = 1;
            	}
            	
    	{
        unsigned factor_count;		/* precalculate x scale table */
        int x = 0;
        factor_count = wfactor / 2;
        while (x < w1) {
            	int w = 0;
            	factor_count += wfactor;
            	if (factor_count > 65535) {
            		factor_count -= 65536;
            		w++;
            	}        		
            	w += wround;
            	scale_tablex[x] = w;
            	x++;
        }
    	}

    	{
        unsigned factor_count;          /* precalculate y scale table */
        int y = 0;
        factor_count = hfactor / 2;
        while (y < h1) {
            	int h = 0;
            	factor_count += hfactor;
            	if (factor_count > 65535) {
            		factor_count -= 65536;
            		h++;
            	}
            	h += hround;
            	scale_tabley[y] = h;
            	y++;
        }
        }
        
        switch (BYTESPERPIXEL) {
        case 1 :
	        {
        	int y;
	        for (y = 0; y < h1; y++) {
        	    	int h = scale_tabley[y];
            		uchar *dp2old = dp2; 
	            	if (h > 0) {
        	        	int x;
                		for (x = 0; x < w1; x++, dp1++) {
                			int w = scale_tablex[x];
	                		uchar c;
        	        		c = *dp1;
                			__memsetb(dp2, c, w);
                			dp2 += w; 
				}
        	        	dp1 -= w1;
                		h--;
	            	}
        	    	while (h > 0) {		/* copy identical lines */
            			int l = dp2 - dp2old;
            			__memcpy(dp2, dp2old, l);
	            		dp2old = dp2;
        	    		dp2 += l;
            			h--;
	            	}  
        	    	dp1 += w1;
	        }
    		}
    		break;
        case 2 :
	        {
        	int y;
	        for (y = 0; y < h1; y++) {
        	    	int h = scale_tabley[y];
            		uchar *dp2old = dp2; 
	            	if (h > 0) {
        	        	int x;
                		for (x = 0; x < w1; x++, dp1 += 2) {
                			int w = scale_tablex[x];
	                		ushort c;
        	        		c = *(ushort *)dp1;
                			__memset2(dp2, c, w);
                			dp2 += w * 2; 
				}
        	        	dp1 -= w1 * 2;
                		h--;
	            	}
        	    	while (h > 0) {		/* copy identical lines */
            			int l = dp2 - dp2old;
            			__memcpy(dp2, dp2old, l);
	            		dp2old = dp2;
        	    		dp2 += l;
            			h--;
	            	}  
        	    	dp1 += w1 * 2;
	        }
    		}
    		break;
        case 3 :
	        {
        	int y;
	        for (y = 0; y < h1; y++) {
        	    	int h = scale_tabley[y];
            		uchar *dp2old = dp2; 
	            	if (h > 0) {
        	        	int x;
                		for (x = 0; x < w1; x++, dp1 += 3) {
                			int w = scale_tablex[x];
	                		uint c;
        	        		c = *(ushort *)dp1
        	        			+ (*(dp1 + 2) << 16);
                			__memset3(dp2, c, w);
                			dp2 += w * 3; 
				}
        	        	dp1 -= w1 * 3;
                		h--;
	            	}
        	    	while (h > 0) {		/* copy identical lines */
            			int l = dp2 - dp2old;
            			__memcpy(dp2, dp2old, l);
	            		dp2old = dp2;
        	    		dp2 += l;
            			h--;
	            	}  
        	    	dp1 += w1 * 3;
	        }
    		}
    		break;
	}	/* switch */
}
