
#include <stdlib.h>
#include <stdio.h>
#include <vga.h>

#define FONT_SIZE 8192

unsigned char font[FONT_SIZE];

void main( int argc, char *argv[]) {
	if (argc == 1) {
		printf("Restore corrupted textmode font.\n");
		printf("Syntax: restorefont option filename\n");
		printf("	-r filename	Restore VGA font from file.\n");
		printf("	-w filename	Write current VGA font to file.\n");
		exit(0);
	}
	if (argv[1][0] != '-') {
		printf("Must specify -r or -w.\n");
		exit(1);
	}
	switch (argv[1][1]) {
		case 'r' :
		case 'w' :
			if (argc != 3) {
				printf("Must specify filename.\n");
				exit(1);
			}
			break;
		default :
			printf("Invalid option. Must specify -r or -w.\n");
			exit(1);
	}
	if (argv[1][1] == 'r') {
		FILE *f;
		f = fopen(argv[2], "rb");
		if (f == NULL) {
			printf("Invalid filename.\n");
			exit(1);
		}
		fread(font, FONT_SIZE, 1, f);
		fclose(f);
	}
	vga_setchipset(VGA);	/* avoid SVGA detection */
	vga_setmode(G640x480x16);
	switch (argv[1][1]) {
	case 'r' :
		vga_puttextfont(font);
		break;
	case 'w' :	/* this line was missing */
		vga_gettextfont(font);
		break;
	}
	vga_setmode(TEXT);
	if (argv[1][1] == 'w') {
		FILE *f;
		f = fopen(argv[2], "wb");
		fwrite(font, FONT_SIZE, 1, f);
		fclose(f);
	}
	exit(0);
}