/*
 * tload.c	- terminal version of xload
 *
 * Options:
 *	-d delay
 *
 * Copyright (c) 1992 Michael K. Johnson, with a bit copied from
 * Branko Lankester's ps to do the argument handling...
 * -johnsonm@stolaf.edu
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/stat.h>
#include <getopt.h>
#include <fcntl.h>
#include <unistd.h>

void main(int argc, char **argv)
{
    int i, opt, loadfd, delay = 5;
    char loadstring[100];

    while ((opt = getopt(argc, argv, "bs:d:")) != -1)
	switch (opt) {
	    case 'd': delay = atoi(optarg); break;
	    default:
		printf("usage: tload [-d delay]\n");
		exit(1);
	}

    printf("\033[H\033[2J");
    loadfd = open("/proc/loadavg", O_RDONLY, 0);
    if (loadfd == -1) {perror("/proc/loadavg"); exit(1);}

    while (1) {
      lseek(loadfd, 0L, 0);
      i = read(loadfd, loadstring, 99);
      loadstring[i+1] = 0;
      printf("\033[H%s", loadstring);
      sleep(delay);
    }
}
