/* this is loosly based on Branko Lankester's ps, and is derived
 * from a simple hack posted to c.o.l
 * -Michael K. Johnson, johnsonm@stolaf.edu
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/dir.h>
#include <regex.h>
#include <sys/stat.h>
#include <pwd.h>
#include <string.h>
#include <unistd.h>
#include "ps.h"

struct direct *ent;
char filename[80];


int mycpy(char *ret, char *what)
{
  FILE *fp;
  int i=0;
  char c;

  sprintf(filename, "/proc/%s/%s", ent->d_name, what);
  fp = fopen(filename, "r");
  if(fp) {
    while(!feof(fp))
      ret[i++] = ((c = getc(fp)) ? c : ' ');
    ret[i-1] = '\0';
  } else return 0;
  fclose(fp);
  return 1;
}



struct ps_proc * take_snapshot(char a, char u, char x, char m)
{
  DIR *proc;
  static char stat_str[4096];
  struct ps_proc * ret = NULL, *this = NULL, *that = NULL;
  int uid;
  struct stat sb;

  proc = opendir("/proc");
  re_comp("^[0-9]*$");
  uid = getuid();

  while(ent = readdir(proc)) {
    if(!re_exec(ent->d_name))
      continue;
    sprintf(filename, "/proc/%s", ent->d_name);
    stat(filename, &sb);
    if(!a && (sb.st_uid != uid))
      continue;
    if(!ret) {
      ret = (struct ps_proc *) calloc(1,sizeof(struct ps_proc));
      this = ret;
      that = NULL;
    } else {
      that = this;
      this = (struct ps_proc *) calloc(1,sizeof(struct ps_proc));
      if (!this) {
	fprintf(stderr, "Out of memory.  mail johnsonm@stolaf.edu about this.\n");
	perror("take_snapshot:this");
	exit(1);
      }
      that->next = this;
    }      
    this->uid = sb.st_uid;
    mycpy(this->cmdline, "cmdline");
    if(!mycpy(stat_str, "stat")) {
      if(this == ret) ret = NULL;
      free(this);
      this = that;
      continue;
    }
    sscanf(stat_str, "%d %s %c %d %d %d %d %d %u %u \
%u %u %u %d %d %d %d %d %d %u %u %d %u %u %u %u %u %u %u %u %d \
%d %d %d %u",
	   &this->pid, this->cmd, &this->state, &this->ppid,
	   &this->pgrp, &this->session, &this->tty, &this->tpgid,
	   &this->flags, &this->min_flt, &this->cmin_flt,
	   &this->maj_flt, &this->cmaj_flt,
	   &this->utime, &this->stime, &this->cutime, &this->cstime,
	   &this->counter, &this->priority, &this->timeout,
	   &this->it_real_value, &this->start_time,
	   &this->vsize, &this->rss, &this->rss_rlim,
	   &this->start_code, &this->end_code, &this->start_stack,
	   &this->kstk_esp, &this->kstk_eip,
	   &this->signal, &this->blocked, &this->sigignore, &this->sigcatch,
	   &this->wchan);
    if(!x && (this->tty == -1)) {
      if(this == ret) ret = NULL;
      free(this);
      this = that;
      continue;
    }
    if(m) {
      if(!mycpy(stat_str, "statm")) {
	if(this == ret) ret = NULL;
	free(this);
	this = that;
	continue;
      }
      sscanf(stat_str, "%d %d %d %d %d %d %d",
	     &this->statm.size, &this->statm.resident,
	     &this->statm.share, &this->statm.trs,
	     &this->statm.lrs, &this->statm.drs,
	     &this->statm.dt);
    }
    if (this->state == 'Z') strcat(this->cmd," <zombie>");
    dev_to_tty(this->ttyc, this->tty);
    if(u) {
      strncpy(this->user, user_from_uid(this->uid), 9);
    }
  }
  closedir(proc);
  return ret;
}
