/*
 * ps.h
 *
 * Copyright (c) 1992 Branko Lankester
 *
 * Modified by Michael K. Johnson
 */


#include <linux/sched.h>


#define	MAXCMD	512	/* max # bytes to copy from args/env */

#define	PZERO	15	/* priority of init (in sched.h) */


char *find_func();
void dev_to_tty(char *tty, int dev);
char *wchan();
char *status();
char *xmalloc();
struct ps_proc * take_snapshot(char a, char u, char x, char m);
void dev_to_tty(char *tty, int dev);
int tty_to_dev(char *tty);
char *user_from_uid(int uid);

struct ps_statm {
  int size, resident, share, trs, lrs, drs, dt;
};

struct ps_proc {
  char user[10], cmdline[1024], cmd[40], ttyc[3], state;
  int uid, pid, ppid, pgrp, session, tty, tpgid, utime, stime,
    cutime, cstime, counter, priority, start_time, signal, blocked,
    sigignore, sigcatch;
  unsigned int flags, min_flt, cmin_flt, maj_flt, cmaj_flt, timeout,
    it_real_value, vsize, rss, rss_rlim, start_code, end_code,
    start_stack, kstk_esp, kstk_eip, wchan;
  struct ps_proc *next;
  struct ps_statm statm;
};
