#include <unistd.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

void print_indication(struct info_data *info)
{
	int i;

	if (info->cau.length != 0)
		switch (info->cau.data[0])	/* for german 1tr6 */
		{
		case 0x80:
			break;
		case 0xb5:
			printf("destination not obtainable\n");
			break;
		case 0xba:
			printf("no user responding\n");
			break;
		case 0xbb:
			printf("Number Busy\n");
			break;
		default:
			printf("code: %2x\n",info->cau.data[0]);
			break;
		}
	if (info->esccau.length != 0)
	{
		printf("ESCCAU: ");	/* for german 1tr6 */
		switch (info->esccau.data[2])
		{
		case 0x80:
			printf("no cause\n");
			break;
		case 0xb5:
			printf("destination not obtainable\n");
			break;
		case 0xba:
			printf("no user responding\n");
			break;
		case 0xbb:
			printf("Number Busy\n");
			break;
		case 0xda:
			printf("remote user initiated\n");
			break;
		default:
			printf("Cause code: %2x\n",(unsigned char)info->esccau.data[0]);
			break;
		}
	}
	if (info->date.length != 0 )
		printf("date: %s\n",info->date.data);
	if (info->cpn.length != 0 )
	{
		printf("CPN: ");
		for (i = 1; i < info->cpn.length; i++)
			printf("%c",info->cpn.data[i]);
		printf("\n");
	}
	if (info->dsa.length != 0 )
	{
		printf("DSA: ");
		for (i = 1; i < info->dsa.length; i++)
			printf("%c",info->dsa.data[i]);
		printf("\n");
	} 
	printf("User info: %d bytes\n",info->uui.length);
	if (info->cif.length != 0 )
	{
		printf("Carging Units:");
		for (i = 1; i < info->cif.length; i++)
			printf("%c klicks",info->cif.data[i]);
		printf("\n");
	}
	if (info->cad.length != 0 )
	{
		printf("CAD: ");
		for (i = 1; i < info->cad.length; i++)
			printf("%c",info->cad.data[i]);
		printf("\n");
	}

	if (info->chi.length != 0 )
	{
		printf("B-Channel:");
		if (info->chi.data & 1)
			printf("1");
		if (info->chi.data & 2)
			printf("2");
		printf("\n");
	}
	if (info->oad.length != 0 )
	{
		printf("originator: ");
		for (i = 1; i < info->oad.length; i++)
			printf("%c",info->oad.data[i]);
		printf("\n");
	}
	if (info->osa.length != 0 )
	{
		printf("originator subadr: ");
		for (i = 1; i < info->osa.length; i++)
			printf("%c",info->osa.data[i]);
		printf("\n"); 
	}
}

