#include <stdio.h>
#include <fcntl.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

#define OS_PATH "/usr/isdn/os/te_1tr6.sy" 	/* German-OS for D-channel */

struct buf tcbuf[256];
struct isdn_load_req lrq;

int
main()
{
	unsigned long pointer;
	int isdn_device, ok, counter;
	int os_fd;

	os_fd = open(OS_PATH, O_RDONLY); 
	if (os_fd == -1)
	{
		perror(OS_PATH);
		return 1;
	}
	isdn_device = open("/dev/isdn", O_RDWR);         /* ISDN-device */
	if (isdn_device == -1)
	{
		perror("/dev/isdn");
		return 1;
	}

	counter = read(os_fd, tcbuf, sizeof(tcbuf));
	if (counter == -1)
	{
		perror(OS_PATH);
		return 1;
	}
	close(os_fd);

	lrq.len = counter;
	lrq.data = (char*)tcbuf;

	ok = ioctl(isdn_device, ISDN_LOAD, (unsigned long)&lrq);
	if (ok == -1)
	{
		perror("ioctl: load");
		return -1;
	}

	close(isdn_device);
	return 0;

}
