#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include <linux/isdn.h>
#include <linux/diehl.h>

int isdn_device;
struct info_data info;

sig_handler()
{
	close(isdn_device);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int number;
	
	if ( (argc != 2 ))
	{
		fprintf(stderr,"usage: listen number\n");
		exit -1;
	}
	
	number=atoi(argv[1]);


	signal(SIGHUP,sig_handler);
	signal(SIGINT,sig_handler);
	signal(SIGQUIT,sig_handler);

	isdn_device = open("/dev/isdn1", O_RDWR);          /* ISDN-device */
	if (isdn_device == -1)
		{
		perror("/dev/isdn1");
		return 1;
		}

	ioctl(isdn_device,SET_OAD,3);
	if(ioctl(isdn_device,D3_IND_REQ,10000))	/* wait 100 Seconds */
	{
		perror("/dev/isdn1");
		return 1;
	}
	if(ioctl(isdn_device,GET_PARAMETER,&info))
	{
		perror("/dev/isdn1");
		return 1;
	}
	print_indication(&info);

	if (strncmp(info.oad.data+1,argv[1],info.oad.length-1)==0)
	{
		if(ioctl(isdn_device,D3_ACCEPT_CALL,0))
		{
			perror("/dev/isdn1");
			return 1;
		}
		if(ioctl(isdn_device,B2_CONN_REQ,0))
		{
			perror("/dev/isdn1");
			return 1;
		}
		
		/* do something usefull */
		printf("call accepted\nserver 1 ready\nsleeping\n");
		while(TRUE)
			sleep(1);
	}
	else
	{
		if(ioctl(isdn_device,D3_REJECT_CALL,0))
		{
			perror("/dev/isdn1");
			return 1;
		}
		
		printf("call rejected\n");
	}


	close(isdn_device);
	ioctl(isdn_device,GET_PARAMETER,&info);
	print_indication(&info);
	return 0;

}
