#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include <linux/isdn.h>

void usage(void)
{
	fprintf(stderr,"usage: debug [-r] ALL|LOSS|FYI|STAT|FUNC|IO|INFO|INT|ERR\n");
}

int isdn_device;
struct huba {
	char *text;
	int mode;
	} debug_mode[]=
		{{"ALL",DEBUG_ALL},
		 {"LOSS",DEBUG_LOSS},
		 {"FYI",DEBUG_FYI},
		 {"STAT",DEBUG_STAT},
		 {"FUNC",DEBUG_FUNC},
		 {"IO",DEBUG_IO},
		 {"INFO",DEBUG_INFO},
		 {"INT",DEBUG_INT},
		 {"ERR",DEBUG_ERR},
		 {"",0}};

sig_handler()
{
	close(isdn_device);
	exit(0);
}

int
main(int argc, char *argv[])
{
	int mode;
	int i;

	signal(SIGHUP,sig_handler);
	signal(SIGINT,sig_handler);
	signal(SIGQUIT,sig_handler);

	isdn_device = open("/dev/isdn1", O_WRONLY);          /* ISDN-device */
	if (isdn_device == -1)
	{
		perror("/dev/isdn1");
		return 1;
	}

	mode=0;

	if (strcmp(argv[1],"-r")==0)
	{
		if (argc == 3)
		{
			for(i=0;debug_mode[i].text!=NULL;i++)
				if (strcasecmp(argv[2],debug_mode[i].text)==0)
				{
					mode=debug_mode[i].mode;
					ioctl(isdn_device,CLEAR_DEBUG,mode);
					exit(0);
				}
		}
	}
	else /* not -r */
	{
		if (argc == 2)
		{
			for(i=0;debug_mode[i].text!=NULL;i++)
				if (strcasecmp(argv[1],debug_mode[i].text)==0)
				{
					mode=debug_mode[i].mode;
					ioctl(isdn_device,SET_DEBUG,mode);
					exit(0);
				}
		}
	}
	usage();
	close(isdn_device);
	return -1;

}
