/*
 * ckvar.h		- Global variables used by e2fsck
 *
 * Copyright (C) 1992, 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/05/26	- Creation from e2fsck
 */

extern struct ext2_super_block * Super;

extern char * bad_map;
extern char * block_map;
extern char * inode_map;

extern unsigned short * block_count;
extern unsigned short * inode_count;

extern char blkbuf[EXT2_MAX_BLOCK_SIZE * TEST_BUFFER_BLOCKS];

extern int repair;
extern int automatic;
extern int verbose;
extern int list;
extern int show;
extern int debug;
extern int test_disk;
extern int force;
extern int check_mounted;

extern int no_bad_inode;
extern int no_lpf;
extern int lpf_corrupted;

extern int directory;
extern int regular;
extern int blockdev;
extern int chardev;
extern int links;
extern int symlinks;
extern int fast_symlinks;
extern int fifo;
extern int total;
extern int badblocks;
extern int sockets;

extern int changed;

extern int inode_blocks_per_group;
extern int block_size;
extern int addr_per_block;

#define MAX_DEPTH 50
extern int name_depth;
extern char name_list [MAX_DEPTH] [EXT2_NAME_LEN + 1];

extern unsigned long group_desc_count;
extern unsigned long group_desc_size;
extern unsigned long desc_blocks;
extern struct ext2_group_desc * group_desc;

extern unsigned long last_block_read;
