/*
 * fsetflags.c		- Set a file flags on an ext2 file system
 *
 * Copyright (C) 1993  Remy Card <card@masi.ibp.fr>
 *
 * This file can be redistributed under the terms of the GNU General
 * Public License
 */

/*
 * History:
 * 93/10/30	- Creation
 */

#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include <linux/ext2_fs.h>

int fsetflags (const char * name, unsigned long flags)
{
	int fd;
	int r;

	fd = open (name, O_RDONLY);
	if (fd == -1)
		return -1;
	r = ioctl (fd, EXT2_IOC_SETFLAGS, &flags);
	close (fd);
	return r;
}
