      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinTwoC.
      *
      *    Programm
      *    zum Kapitel  :  4.5 Mehr als eine Zeile
      *
      *    Programm Name:  WinTwoC.CBL
      *
      *    bersetzung  :  COBOL WINTWOC OMF(obj) ANS85;
      *                    LINK WINTWOC+CBLWGUI+CBLWINA, WINTWOC.EXE,
      *                         WINTWOC,COBLIBW+COBLIB+COBW,
      *                         WINTWOC.DEF /noe/nod
      *                    (Siehe auch Seite 12-13 in COBOL USER GUIDE)
      *
      *    Start mit    :  WIN WINTWOC <RETURN>
      *
      *    Stand        :  16. 7. 93 NWK
      *
       SPECIAL-NAMES.
                CALL-CONVENTION 3 is WINAPI.

       DATA DIVISION.
       WORKING-STORAGE SECTION.
      
       78  WM-PAINT                    VALUE h"000F".
       78  WM-DESTROY                  VALUE h"0002".
      *
      *
       78  DT-WORDBREAK                VALUE h"10".

       01  MyWndProc                   PROCEDURE-POINTER.
       01  MyClassName                 PIC X(0020) VALUE
                                       "Welcome1" & x"00".
       01  dwSize.
           03 dwWidth                  PIC s9(0004) COMP-5.
           03 dwHight                  PIC s9(0004) COMP-5.
      
       01  MyData.
           03  loop-flag               PIC x(0001) VALUE 'C'.
               88  loop-end            VALUE 'E'.
           03  bool                    PIC 9(0004) COMP-5.
               88  boolTRUE            VALUE 1.
               88  boolFALSE           VALUE 0.
      
           COPY "WNDCLASS.CPY".
           COPY "MSG1.CPY".
      
       01  TextStrings.
           03 FILLER                   PIC X(0212) VALUE
              "Dieser Text zeigt Ihnen wie Sie mit dem Flag DT-WORDBREAK
      -       " Texte anzuzeigen knnen,  ohne sich dabei Gedanken um ei
      -       "nen Zeilenumbruch machen zu men. Dabei erfolgt der Zeil
      -       "umbruch niemals innerhalb eines Wortes." & x"00".

       LOCAL-STORAGE SECTION.
       01  MyData.
           03 mResult                  PIC 9(0009) COMP-5.
           03 tmpFlag                  PIC 9(0004) COMP-5.
           03 hWindow                  PIC 9(0004) COMP-5.
      
        01  hps                        PIC x(0002) COMP-5.
      
           COPY "PPAINT.CPY".
      
       01  LenOffString                PIC s9(0004) COMP-5.

       LINKAGE SECTION.
          COPY "LINKAGE1.CPY".
      
       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.

           CALL  "PC_WIN_STARTUP".
           STOP RUN.
      
       ENTRY "WinMain" WINAPI USING hInst,
                                    hPrevInstance,
                                    lpszCmdLine,
                                    nCmdShow.
      
       MyWinMain section.
           IF hPrevInstance EQUAL 0
      
              MOVE 3 TO style
              SET lpfnWndProc TO ENTRY "MyWndProc"
      
              MOVE 0     TO cbClsExtra
              MOVE 0     TO cbWndExtra
              MOVE hInst TO hInstance
      
              CALL  WINAPI "__LoadIcon"
                    USING BY VALUE 0 SIZE 2
                          BY VALUE h"00007f00" SIZE 4
              RETURNING hIcon
      
              CALL  WINAPI "__LoadCursor"
                    USING BY VALUE 0 SIZE 2
                          BY VALUE h"00007f00" SIZE 4
              RETURNING hCursor
      
              CALL  WINAPI "__GetStockObject"
                    USING BY VALUE 0 SIZE 2
              RETURNING hbrBackground
      
              SET lpszMenuName  TO NULL
              SET lpszClassName TO ADDRESS OF MyClassName
      
              CALL  WINAPI '__RegisterClass'
                    USING WndClass
              RETURNING tmpFlag
      
              IF tmpFlag EQUAL 0
                 EXIT PROGRAM RETURNING 0
              END-IF
      
           END-IF
      
           CALL  WINAPI "__CreateWindow"
                 USING BY REFERENCE MyClassName
                       BY REFERENCE "COBOL & Windows" & x"00"
                       BY VALUE h"00CF0000" SIZE 4
                       BY VALUE h"8000" SIZE 2
                       BY VALUE 0 SIZE 2
                       BY VALUE h"8000" SIZE 2
                       BY VALUE 0 SIZE 2
                       BY VALUE 0 SIZE 2
                       BY VALUE 0 SIZE 2
                       BY VALUE hInst
                       BY VALUE 0 SIZE 4
           RETURNING hWindow
      
           CALL  WINAPI "__ShowWindow"
                 USING BY VALUE hWindow
                       BY VALUE nCmdShow
      
           CALL  WINAPI "__UpdateWindow"
                 USING BY VALUE hWindow
      
           PERFORM UNTIL loop-end
      
              CALL  WINAPI '__GetMessage'
                    USING BY REFERENCE msg
                          BY VALUE 0 SIZE 2
                          BY VALUE 0 SIZE 2
                          BY VALUE 0 SIZE 2
              RETURNING bool
      
              IF boolFALSE
      
                 SET loop-end TO true
      
              ELSE
                 CALL  WINAPI '__TranslateMessage'
                       USING BY reference msg
      
                 CALL  WINAPI '__DispatchMessage'
                       USING BY reference msg
      
              END-IF
      
           END-PERFORM
      
           EXIT PROGRAM RETURNING msg-wParam
           STOP RUN.
      
      
       MyWindowProcedure SECTION.
       ENTRY "MyWndProc" USING BY VALUE hWnd
                               BY VALUE iMessage
                               BY VALUE wParam
                               BY VALUE lParam.
      
           MOVE 0 TO mResult
           EVALUATE iMessage
      
           WHEN WM-PAINT
                CALL  WINAPI '__BeginPaint'
                      USING BY VALUE hwnd
                            BY reference ppaint
                RETURNING hps
      *
      *         Ausgabeweite ermitteln
      *
                CALL  WINAPI '__GetTextExtent'
                              USING BY VALUE hdc
                                    BY REFERENCE "X" & x"00"
                                    BY VALUE 1 SIZE 2
                RETURNING dwSize
      *
      *         Koordinaten des Ausgabebereiches ermitteln
      *
                CALL  WINAPI '__GetClientRect'
                      USING BY VALUE hwnd
                            BY REFERENCE rcl
      *
      *         Rnder des Ausgabesektors bestimmen
      *
                COMPUTE yTop    = yTop + dwHight
                COMPUTE yBottom = yBottom - dwHight
                COMPUTE xLeft   = xLeft + dwWidth * 2
                COMPUTE xRight  = xRight - dwWidth * 2
      *
      *         Lnge der Zeichenkette ermitteln
      *
                CALL WinApi '__lStrLen'
                     USING BY REFERENCE TextStrings
                RETURNING LenOffString
      *
      *        Text ausgeben...
      *
                CALL  WINAPI '__DrawText'
                     USING BY VALUE hdc
                           BY REFERENCE TextStrings
                           BY VALUE LenOffString
                           BY REFERENCE rcl
                           BY VALUE DT-Wordbreak size 2
      
      
                CALL  WINAPI '__EndPaint'
                      USING BY VALUE hwnd
                            BY reference ppaint
      
           WHEN WM-DESTROY
                CALL  WINAPI '__PostQuitMessage'
                      USING BY VALUE 0 SIZE 2
      
           WHEN OTHER
                CALL  WINAPI "__DefWindowProc"
                      USING BY VALUE hWnd
                            BY VALUE iMessage
                            BY VALUE wParam
                            BY VALUE lParam
                RETURNING mResult
      
           END-EVALUATE
      
        EXIT PROGRAM RETURNING mResult.
