      $ set ans85 noosvs mf defaultbyte"00"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. WinTwoB.
      *    
      *    Programm 
      *    zum Kapitel  :  4.4.2 Die Wahl der Schriften
      *
      *    Programm Name:  WinTwoB.CBL
      *
      *    bersetzung  :  COBOL WINTWOB OMF(obj) ANS85;
      *                    LINK WINTWOB+CBLWGUI+CBLWINA, WINTWOB.EXE,
      *                         WINTWOB,COBLIBW+COBLIB+COBW,
      *                         WINTWOB.DEF /noe/nod
      *                    (Siehe auch Seite 12-13 in COBOL USER GUIDE)
      *
      *    Start mit    :  WIN WINTWOB <RETURN>
      *
      *
       SPECIAL-NAMES.
		CALL-CONVENTION 3 IS WINAPI.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      *    Konstanten zur verarbeitung der Meldungen welche
      *    von der Meldeschleife generiert bzw. weitergegeben werden.
      *   
       78  WM-PAINT                   VALUE h"000F".
       78  WM-DESTROY                 VALUE h"0002".
       78  WM-CREATE                  VALUE h"0001".

       01  MyWndProc                   PROCEDURE-POINTER.
       01  MyClassName                 PIC X(0020) VALUE 
					   "Welcome1" & x"00".
       01  MyData.
	   03  loop-flag               PIC x(0001) VALUE 'C'.
	       88  loop-end            VALUE 'E'.
	   03  bool                    PIC 9(0004) COMP-5.
	       88  boolTRUE            VALUE 1.
	       88  boolFALSE           VALUE 0.

	    COPY "WNDCLASS.CPY".
	    COPY "MSG1.CPY".
	    COPY "LOGFONT.CPY".
	    COPY "TM.CPY".
      *
      *     Die folgenden Datenstze und Felder dienen zum
      *     Aufbau der Ausgabemaske
      *
       01   FontAusgabeSatz.
	    03 HwdFontSystem           PIC 9(0004) COMP-5.
	    03 HwdFontCourier          PIC 9(0004) COMP-5.
	    03 FontNameSystem          PIC X(0032) VALUE
	       "System" & x"00".
	    03 FontNameCourier         PIC X(0032) VALUE
	       "COURIER NEW" & x"00".
	    03 CharType.
	       05 FILLER               PIC X(0022) VALUE
		  "Aktueller Font ist  : ".
	       05 CharTypeFonts        PIC X(0015).

         03 CharAveWidth.
      	       05 FILLER               PIC X(0022) VALUE
      		  "Breite im Schnitt   : ".
      	       05 CharAve              PIC X(0004).

      	    03 CharMaxWidth.
      	       05 FILLER               PIC X(0022) VALUE
      		  "Maximale Breite     : ".
      	       05 CharMax              PIC X(0004). 

	    03 CharHeight.
	       05 FILLER               PIC X(0022) VALUE
		  "Aktuelle Hhe in Pt : ".
	       05 CharHeightPt         PIC x(0004).

	    03 CharLen                 PIC S9(0004) COMP-5.
	    03 BufferGruppe.
	       05 BufferText           PIC  X(0080).
	       05 BufferLen            PIC s9(0004) COMP-5.


       LOCAL-STORAGE SECTION.
       01  MyData.
	   03 mResult                  PIC 9(0009) COMP-5.
	   03 tmpFlag                  PIC 9(0004) COMP-5.
	   03 hWindow                  PIC 9(0004) COMP-5.

	01  hps                        PIC x(0002) COMP-5.

	    COPY "PPAINT.CPY".

      *
      *    Felder werden zur Positionierung der Zeichenketten
      *    bentigt.
      *
       01  xText                       PIC s9(0004) COMP-5.
       01  yText                       PIC s9(0004) COMP-5.
       01  yLineHeight                 PIC s9(0004) COMP-5.

       LINKAGE SECTION.
	   COPY "LINKAGE1.CPY".

       PROCEDURE DIVISION WINAPI.
       MSWindowsInit SECTION.
	   CALL  "PC_WIN_STARTUP".
	   STOP RUN.

       ENTRY "WinMain" WINAPI USING hInst, 
				    hPrevInstance,
				    lpszCmdLine,
				    nCmdShow.

       MyWinMain section.
	   IF hPrevInstance EQUAL 0

	      MOVE 3 TO style
	      SET lpfnWndProc TO ENTRY "MyWndProc"

	      MOVE 0     TO cbClsExtra
	      MOVE 0     TO cbWndExtra
	      MOVE hInst TO hInstance

	      CALL  WINAPI "__LoadIcon" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hIcon

	      CALL  WINAPI "__LoadCursor" 
		    USING BY VALUE 0 SIZE 2
			  BY VALUE h"00007f00" SIZE 4
	      RETURNING hCursor

	      CALL  WINAPI "__GetStockObject" 
		    USING BY VALUE 0 SIZE 2
	      RETURNING hbrBackground

	      SET lpszMenuName  TO NULL
	      SET lpszClassName TO ADDRESS OF MyClassName

	      CALL  WINAPI '__RegisterClass' 
		    USING WndClass
	      RETURNING tmpFlag

	      IF tmpFlag EQUAL 0
		 EXIT PROGRAM RETURNING 0
	      END-IF

	   END-IF

	   CALL  WINAPI "__CreateWindow" 
		 USING BY REFERENCE MyClassName
		       BY REFERENCE "COBOL & Windows" & x"00"
		       BY VALUE h"00CF0000" SIZE 4
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE h"8000" SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE 0 SIZE 2
		       BY VALUE hInst
		       BY VALUE 0 SIZE 4
	   RETURNING hWindow

	   CALL  WINAPI "__ShowWindow" 
		 USING BY VALUE hWindow
		       BY VALUE nCmdShow

	   CALL  WINAPI "__UpdateWindow" 
		 USING BY VALUE hWindow

	   PERFORM UNTIL loop-end

	      CALL  WINAPI '__GetMessage' 
		    USING BY REFERENCE msg
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
			  BY VALUE 0 SIZE 2
	      RETURNING bool

	      IF boolFALSE

		 SET loop-end TO true

	      ELSE
		 CALL  WINAPI '__TranslateMessage'
		       USING BY reference msg

		 CALL  WINAPI '__DispatchMessage'
		       USING BY reference msg

	      END-IF

	   END-PERFORM

	   EXIT PROGRAM RETURNING msg-wParam
	   STOP RUN.


       MyWindowProcedure SECTION.
       ENTRY "MyWndProc" USING BY VALUE hWnd
			       BY VALUE iMessage
			       BY VALUE wParam
			       BY VALUE lParam.

	   MOVE 0 TO mResult
	   EVALUATE iMessage
	   WHEN WM-CREATE

		CALL WINAPI '__GetDC'
		     USING BY VALUE hWnd
		RETURNING hdc
      *
      *         LogFont fr die Schrift SYSTEM initialisieren
      * 
		MOVE FontNameSystem TO lfFaceName               
		MOVE 16 TO lfHeight
		MOVE  7 TO lfWidth
		MOVE  0 TO lfItalic
			   lfStrikeout
      *
      *         Handle auf die Schrift System erstellen
      *
		CALL WINAPI '__CreateFontIndirect'
		     USING BY REFERENCE LogFont
		RETURNING HwdFontSystem

      *
      *         Jetz Handle fr Courier...
      *
		MOVE FontNameCourier TO lfFaceName

		CALL WINAPI '__CreateFontIndirect'
		     USING BY REFERENCE LogFont
		RETURNING HwdFontCourier

		CALL WINAPI '__ReleaseDC'
		     USING BY VALUE hWnd
			   BY VALUE Hdc                

	   WHEN WM-PAINT
		CALL  WINAPI '__BeginPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint
		RETURNING hps

      *-----------------------------------------------------------------
      *         Informationen ber den Font SYSTEM
      *-----------------------------------------------------------------
      *
      *         Font whlen
      *
		CALL WINAPI '__SelectObject'
		     USING BY VALUE Hdc
			   BY VALUE HwdFontSystem
      *
      *         Informationen ber den Font lesen
      *
		CALL WINAPI '__GetTextMetrics'
		     USING BY VALUE Hdc
			   BY REFERENCE Tm
      *
      *         Zeile setzen     (xText)  
      *         Spalte berechnen (yText)
      *
		MOVE 30 TO yText
		COMPUTE yText = yText +  TmHeight + TmExternalLeading
      *          
      *         Fontname lesen (der Buffer mu 79 Zeichen lang sein)
      *
		CALL WINAPI '__GetTextFace'
		     USING BY VALUE Hdc
			   BY VALUE 79 SIZE 2
			   BY REFERENCE BufferText
		RETURNING BufferLen
      *
      *         Fontname weitergeben
      *
		MOVE BufferText TO CharTypeFonts  
      *
      *         Lnge der Ausgabe berechnen
      *
		CALL WINAPI '__LStrLen'
		     USING BY REFERENCE CharType
		RETURNING CharLen

      *
      *         Ausgabe des Textes
      *       
		CALL WINAPI '__TextOut' 
		     USING BY VALUE Hdc
			   BY VALUE 50 size 2
			   BY VALUE yText
			   BY REFERENCE CharType
			   BY VALUE CharLen
      *
      *                 Nchste Zeile berechnen
      *
		COMPUTE yText = yText +  TmHeight + TmExternalLeading

		MOVE TmHeight  TO CharHeightPt

      *
      *         Ausgabe des Textes
      *       
		CALL WINAPI '__TextOut' 
		     USING BY VALUE Hdc
			   BY VALUE 50 size 2
			   BY VALUE yText
			   BY REFERENCE CharHeight
			   BY VALUE 26 SIZE 2
      *
      *                 Nchste Zeile berechnen
      *
		COMPUTE yText = yText +  TmHeight + TmExternalLeading

       		MOVE TmAveCharWidth TO CharAve
      *
      *         Ausgabe des Textes
      *       
      		CALL WINAPI '__TextOut' 
      		     USING BY VALUE Hdc
      			   BY VALUE 50 size 2
      			   BY VALUE yText
      			   BY REFERENCE CharAveWidth
      			   BY VALUE 26 SIZE 2
      *
      *                 Nchste Zeile berechnen
      *
        	COMPUTE yText = yText +  TmHeight + TmExternalLeading

         	MOVE TmMaxCharWidth TO CharMax
 
      *
      *         Ausgabe des Textes
      *       
      		CALL WINAPI '__TextOut' 
      		     USING BY VALUE Hdc
      			   BY VALUE 50 size 2
      			   BY VALUE yText
      			   BY REFERENCE CharMaxWidth
      			   BY VALUE 26 size 2
      
      *-----------------------------------------------------------------
      *         Ausgabe von Informationen ber den Font 
      *         Courier New.
      *-----------------------------------------------------------------
      *
      *         Font whlen
      *
		CALL WINAPI '__SelectObject'
		     USING BY VALUE Hdc
			   BY VALUE HwdFontCourier
      *
      *         Informationen ber den Font lesen
      *
		CALL WINAPI '__GetTextMetrics'
		     USING BY VALUE Hdc
			   BY REFERENCE Tm

		COMPUTE yText = 
			yText +  TmHeight + TmExternalLeading + 50
      *          
      *         Fontname lesen (der Buffer mu 79 Zeichen lang sein)
      *
		CALL WINAPI '__GetTextFace'
		     USING BY VALUE Hdc
			   BY VALUE 79 SIZE 2
			   BY REFERENCE BufferText
		RETURNING BufferLen
      *
      *         Fontname weitergeben
      *
		MOVE BufferText TO CharTypeFonts  
      *
      *         Lnge der Ausgabe berechnen
      *
		CALL WINAPI '__LStrLen'
		     USING BY REFERENCE CharType
		RETURNING CharLen

      *
      *         Ausgabe des Textes
      *       
		CALL WINAPI '__TextOut' 
		     USING BY VALUE Hdc
			   BY VALUE 50 size 2
			   BY VALUE yText
			   BY REFERENCE CharType
			   BY VALUE CharLen
      *
      *                 Nchste Zeile berechnen
      *
		COMPUTE yText = yText +  TmHeight + TmExternalLeading

		MOVE TmHeight  TO CharHeightPt

      *
      *         Ausgabe des Textes
      *       
		CALL WINAPI '__TextOut' 
		     USING BY VALUE Hdc
			   BY VALUE 50 size 2
			   BY VALUE yText
			   BY REFERENCE CharHeight
			   BY VALUE 26 SIZE 2
      *
      *                 Nchste Zeile berechnen
      *
		COMPUTE yText = yText +  TmHeight + TmExternalLeading

      		MOVE TmAveCharWidth TO CharAve

      *
      *         Ausgabe des Textes
      *       
      		CALL WINAPI '__TextOut' 
      		     USING BY VALUE Hdc
      			   BY VALUE 50 size 2
      			   BY VALUE yText
         		   BY REFERENCE CharAveWidth
      			   BY VALUE 26 SIZE 2
      *
      *                 Nchste Zeile berechnen
      *
		COMPUTE yText = yText +  TmHeight + TmExternalLeading

      		MOVE TmMaxCharWidth TO CharMax
      *
      *         Ausgabe des Textes
      *       
      		CALL WINAPI '__TextOut' 
      		     USING BY VALUE Hdc
      			   BY VALUE 50 size 2
      			   BY VALUE yText
      			   BY REFERENCE CharMaxWidth
      			   BY VALUE 26 SIZE 2
      
	      
		CALL  WINAPI '__EndPaint'
		      USING BY VALUE hwnd
			    BY reference ppaint

	   WHEN WM-DESTROY
		CALL  WINAPI '__PostQuitMessage' 
		      USING BY VALUE 0 SIZE 2

	   WHEN OTHER
		CALL  WINAPI "__DefWindowProc"
		      USING BY VALUE hWnd
			    BY VALUE iMessage
			    BY VALUE wParam
			    BY VALUE lParam
		RETURNING mResult

	   END-EVALUATE

	   EXIT PROGRAM RETURNING mResult.
